/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.action.actions.other;

import de.keksuccino.fancymenu.customization.action.Action;
import de.keksuccino.fancymenu.customization.action.ActionInstance;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.cycle.CommonCycles;
import de.keksuccino.fancymenu.util.cycle.LocalizedEnumValueCycle;
import de.keksuccino.fancymenu.util.enums.LocalizedEnum;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.StringBuilderScreen;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.CycleButton;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3283;
import net.minecraft.class_3288;
import net.minecraft.class_339;
import net.minecraft.class_437;
import net.minecraft.class_7919;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManageResourcePackAction
extends Action {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String VALUE_SEPARATOR = "|||";

    public ManageResourcePackAction() {
        super("manage_resource_pack");
    }

    @Override
    public boolean canRunAsync() {
        return false;
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public void execute(@Nullable String value) {
        if (value == null || value.isEmpty()) {
            LOGGER.error("[FANCYMENU] ManageResourcePackAction: No value provided!");
            return;
        }
        try {
            ResourcePackConfig config = ResourcePackConfig.parse(value);
            if (config == null) {
                LOGGER.error("[FANCYMENU] ManageResourcePackAction: Failed to parse configuration: {}", (Object)value);
                return;
            }
            String targetName = config.packName.trim();
            if (targetName.isEmpty()) {
                LOGGER.error("[FANCYMENU] ManageResourcePackAction: Pack name is empty!");
                return;
            }
            class_310 minecraft = class_310.method_1551();
            class_3283 repository = minecraft.method_1520();
            class_3288 pack = this.findPack(repository, targetName);
            if (pack == null) {
                LOGGER.warn("[FANCYMENU] ManageResourcePackAction: Unable to find resource pack with display name '{}'.", (Object)targetName);
                return;
            }
            ArrayList<class_3288> workingSelection = new ArrayList<class_3288>(repository.method_14444());
            boolean modified = config.mode.apply(workingSelection, pack);
            if (!modified) {
                return;
            }
            ArrayList<String> selectedIds = new ArrayList<String>();
            for (class_3288 entry : workingSelection) {
                selectedIds.add(entry.method_14463());
            }
            repository.method_14447(selectedIds);
            this.refreshOptions(minecraft.field_1690, repository);
            this.updateHighContrastOption(minecraft, repository);
            if (config.reloadOnChange) {
                minecraft.method_1521();
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] ManageResourcePackAction failed to change resource pack state!", (Throwable)ex);
        }
    }

    @Override
    @NotNull
    public class_2561 getActionDisplayName() {
        return class_2561.method_43471((String)"fancymenu.actions.manage_resource_pack");
    }

    @Override
    @NotNull
    public class_2561[] getActionDescription() {
        return LocalizationUtils.splitLocalizedLines("fancymenu.actions.manage_resource_pack.desc", new String[0]);
    }

    @Override
    public class_2561 getValueDisplayName() {
        return class_2561.method_43473();
    }

    @Override
    public String getValueExample() {
        return "Programmer Art|||TOGGLE|||true";
    }

    @Override
    public void editValue(@NotNull class_437 parentScreen, @NotNull ActionInstance instance) {
        ManageResourcePackActionValueScreen screen = new ManageResourcePackActionValueScreen(Objects.requireNonNullElse(instance.value, this.getValueExample()), editedValue -> {
            if (editedValue != null) {
                instance.value = editedValue;
            }
            class_310.method_1551().method_1507(parentScreen);
        });
        class_310.method_1551().method_1507((class_437)screen);
    }

    private void refreshOptions(@NotNull class_315 options, @NotNull class_3283 repository) {
        boolean changed;
        ArrayList previous = new ArrayList(options.field_1887);
        ArrayList previousIncompatible = new ArrayList(options.field_1846);
        options.field_1887.clear();
        options.field_1846.clear();
        for (class_3288 selected : repository.method_14444()) {
            if (selected.method_14465()) continue;
            options.field_1887.add(selected.method_14463());
            if (selected.method_14460().method_14437()) continue;
            options.field_1846.add(selected.method_14463());
        }
        boolean bl = changed = !previous.equals(options.field_1887) || !previousIncompatible.equals(options.field_1846);
        if (changed) {
            options.method_1640();
        }
    }

    private void updateHighContrastOption(@NotNull class_310 minecraft, @NotNull class_3283 repository) {
        boolean highContrastEnabled = false;
        for (class_3288 selected : repository.method_14444()) {
            if (!"high_contrast".equals(selected.method_14463())) continue;
            highContrastEnabled = true;
            break;
        }
        minecraft.field_1690.method_49600().method_41748((Object)highContrastEnabled);
    }

    @Nullable
    private class_3288 findPack(@NotNull class_3283 repository, @NotNull String search) {
        String trimmed = search.trim();
        if (trimmed.isEmpty()) {
            return null;
        }
        for (class_3288 pack : repository.method_14444()) {
            if (!this.matchesPack(pack, trimmed)) continue;
            return pack;
        }
        for (class_3288 pack : repository.method_14441()) {
            if (!this.matchesPack(pack, trimmed)) continue;
            return pack;
        }
        return null;
    }

    private boolean matchesPack(@NotNull class_3288 pack, @NotNull String search) {
        String title = pack.method_14457().getString();
        if (title.equalsIgnoreCase(search)) {
            return true;
        }
        return pack.method_14463().equalsIgnoreCase(search);
    }

    protected static class ResourcePackConfig {
        @NotNull
        protected String packName = "";
        @NotNull
        protected ResourcePackMode mode = ResourcePackMode.TOGGLE;
        protected boolean reloadOnChange = true;

        protected ResourcePackConfig() {
        }

        @NotNull
        public String serialize() {
            return ResourcePackConfig.sanitize(this.packName) + ManageResourcePackAction.VALUE_SEPARATOR + this.mode.getName() + ManageResourcePackAction.VALUE_SEPARATOR + this.reloadOnChange;
        }

        @Nullable
        public static ResourcePackConfig parse(@NotNull String value) {
            ResourcePackConfig config = new ResourcePackConfig();
            String[] parts = value.split("\\|\\|\\|", -1);
            if (parts.length >= 1) {
                config.packName = parts[0];
            }
            if (parts.length >= 2) {
                config.mode = ResourcePackMode.byName(parts[1]);
            }
            if (parts.length >= 3) {
                config.reloadOnChange = Boolean.parseBoolean(parts[2]);
            }
            return config;
        }

        @NotNull
        private static String sanitize(@NotNull String input) {
            return input.replace(ManageResourcePackAction.VALUE_SEPARATOR, "").trim();
        }
    }

    public static enum ResourcePackMode implements LocalizedEnum<ResourcePackMode>
    {
        ENABLE("enable", (Supplier)LocalizedEnum.SUCCESS_TEXT_STYLE){

            @Override
            boolean apply(@NotNull List<class_3288> selection, @NotNull class_3288 pack) {
                if (selection.contains(pack)) {
                    return false;
                }
                pack.method_14466().method_14468(selection, (Object)pack, class_3288::method_56934, false);
                return true;
            }
        }
        ,
        DISABLE("disable", (Supplier)LocalizedEnum.ERROR_TEXT_STYLE){

            @Override
            boolean apply(@NotNull List<class_3288> selection, @NotNull class_3288 pack) {
                if (pack.method_14464()) {
                    LOGGER.warn("[FANCYMENU] ManageResourcePackAction: Tried to disable required resource pack '{}'.", (Object)pack.method_14463());
                    return false;
                }
                return selection.remove(pack);
            }
        }
        ,
        TOGGLE("toggle", (Supplier)LocalizedEnum.WARNING_TEXT_STYLE){

            @Override
            boolean apply(@NotNull List<class_3288> selection, @NotNull class_3288 pack) {
                if (selection.contains(pack)) {
                    return DISABLE.apply(selection, pack);
                }
                return ENABLE.apply(selection, pack);
            }
        };

        private final String name;
        private final Supplier<class_2583> styleSupplier;

        private ResourcePackMode(String name, Supplier<class_2583> styleSupplier) {
            this.name = name;
            this.styleSupplier = styleSupplier;
        }

        abstract boolean apply(@NotNull List<class_3288> var1, @NotNull class_3288 var2);

        @Override
        @NotNull
        public String getLocalizationKeyBase() {
            return "fancymenu.actions.manage_resource_pack.mode";
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public ResourcePackMode[] getValues() {
            return ResourcePackMode.values();
        }

        @Override
        @Nullable
        public ResourcePackMode getByNameInternal(@NotNull String name) {
            return ResourcePackMode.byName(name);
        }

        @Override
        @NotNull
        public class_2583 getValueComponentStyle() {
            return this.styleSupplier.get();
        }

        public static ResourcePackMode byName(@Nullable String name) {
            if (name != null) {
                for (ResourcePackMode mode : ResourcePackMode.values()) {
                    if (!mode.getName().equalsIgnoreCase(name)) continue;
                    return mode;
                }
            }
            return TOGGLE;
        }
    }

    public static class ManageResourcePackActionValueScreen
    extends StringBuilderScreen {
        protected ResourcePackConfig config;

        protected ManageResourcePackActionValueScreen(@NotNull String value, @NotNull Consumer<String> callback) {
            super((class_2561)class_2561.method_43471((String)"fancymenu.actions.manage_resource_pack.edit_value"), callback);
            this.config = ResourcePackConfig.parse(value);
            if (this.config == null) {
                this.config = new ResourcePackConfig();
            }
        }

        @Override
        protected void initCells() {
            this.addStartEndSpacerCell();
            this.addLabelCell((class_2561)class_2561.method_43471((String)"fancymenu.actions.manage_resource_pack.edit.pack_name"));
            CellScreen.TextInputCell nameCell = this.addTextInputCell(null, true, true).setEditListener(text -> {
                this.config.packName = text;
            }).setText(this.config.packName);
            nameCell.editBox.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"fancymenu.actions.manage_resource_pack.edit.pack_name.desc")));
            this.addCellGroupEndSpacerCell();
            this.addLabelCell((class_2561)class_2561.method_43471((String)"fancymenu.actions.manage_resource_pack.edit.mode.label"));
            LocalizedEnumValueCycle modeCycle = LocalizedEnumValueCycle.ofArray((String)"fancymenu.actions.manage_resource_pack.edit.mode", (LocalizedEnum[])ResourcePackMode.values());
            modeCycle.setCurrentValue(this.config.mode, false);
            CycleButton<ResourcePackMode> modeButton = new CycleButton<ResourcePackMode>(0, 0, 20, 20, modeCycle, (selectedMode, button) -> {
                this.config.mode = selectedMode;
            });
            modeButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"fancymenu.actions.manage_resource_pack.edit.mode.desc")));
            modeButton.setSelectedValue(this.config.mode);
            this.addWidgetCell((class_339)modeButton, true);
            this.addCellGroupEndSpacerCell();
            this.addLabelCell((class_2561)class_2561.method_43471((String)"fancymenu.actions.manage_resource_pack.edit.reload.label"));
            CycleButton<CommonCycles.CycleEnabledDisabled> reloadButton = new CycleButton<CommonCycles.CycleEnabledDisabled>(0, 0, 20, 20, CommonCycles.cycleEnabledDisabled("fancymenu.actions.manage_resource_pack.edit.reload", this.config.reloadOnChange), (state, button) -> {
                this.config.reloadOnChange = state.getAsBoolean();
            });
            reloadButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"fancymenu.actions.manage_resource_pack.edit.reload.desc")));
            reloadButton.setSelectedValue(CommonCycles.CycleEnabledDisabled.getByBoolean(this.config.reloadOnChange));
            this.addWidgetCell((class_339)reloadButton, true);
            this.addStartEndSpacerCell();
        }

        @Override
        public boolean allowDone() {
            return !this.config.packName.trim().isEmpty();
        }

        @Override
        @NotNull
        public String buildString() {
            this.config.packName = this.config.packName.trim();
            return this.config.serialize();
        }
    }
}

