/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.background.backgrounds.image;

import de.keksuccino.fancymenu.customization.background.backgrounds.image.ImageMenuBackground;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.cycle.CommonCycles;
import de.keksuccino.fancymenu.util.file.type.types.ImageFileType;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.resource.ResourceChooserScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorScreen;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.CycleButton;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;

public class ImageMenuBackgroundConfigScreen
extends CellScreen {
    @NotNull
    protected Consumer<ImageMenuBackground> callback;
    @NotNull
    ImageMenuBackground background;

    protected ImageMenuBackgroundConfigScreen(@NotNull ImageMenuBackground background, @NotNull Consumer<ImageMenuBackground> callback) {
        super((class_2561)class_2561.method_43471((String)"fancymenu.backgrounds.image.configure"));
        this.background = background;
        this.callback = callback;
    }

    @Override
    protected void initCells() {
        this.addStartEndSpacerCell();
        this.addWidgetCell((class_339)new ExtendedButton(0, 0, 20, 20, (class_2561)class_2561.method_43471((String)"fancymenu.backgrounds.image.configure.choose_image.local"), button -> {
            ResourceChooserScreen<ITexture, ImageFileType> s = ResourceChooserScreen.image(null, source -> {
                if (source != null) {
                    this.background.textureSupplier = ResourceSupplier.image(source);
                }
                class_310.method_1551().method_1507((class_437)this);
            });
            s.setSource(this.background.textureSupplier != null ? this.background.textureSupplier.getSourceWithPrefix() : null, false);
            class_310.method_1551().method_1507(s);
        }), true);
        this.addWidgetCell((class_339)new ExtendedButton(0, 0, 20, 20, (class_2561)class_2561.method_43471((String)"fancymenu.backgrounds.image.type.web.fallback"), var1 -> {
            ResourceChooserScreen<ITexture, ImageFileType> s = ResourceChooserScreen.image(null, source -> {
                if (source != null) {
                    this.background.fallbackTextureSupplier = ResourceSupplier.image(source);
                }
                class_310.method_1551().method_1507((class_437)this);
            });
            s.setSource(this.background.fallbackTextureSupplier != null ? this.background.fallbackTextureSupplier.getSourceWithPrefix() : null, false);
            class_310.method_1551().method_1507(s);
        }).setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.backgrounds.image.type.web.fallback.desc", new String[0]))), true);
        this.addWidgetCell((class_339)new ExtendedButton(0, 0, 20, 20, (class_2561)class_2561.method_43471((String)"fancymenu.backgrounds.image.type.web.fallback.reset").method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().error_text_color.getColorInt())), var1 -> {
            this.background.fallbackTextureSupplier = null;
        }), true);
        this.addCellGroupEndSpacerCell();
        this.addCycleButtonCell(CommonCycles.cycleEnabledDisabled("fancymenu.backgrounds.image.restart_animated_on_menu_load", this.background.restartAnimatedOnMenuLoad), true, (value, button) -> {
            this.background.restartAnimatedOnMenuLoad = value.getAsBoolean();
        });
        CellScreen.WidgetCell repeatButton = this.addCycleButtonCell(CommonCycles.cycleEnabledDisabled("fancymenu.backgrounds.image.configure.repeat", this.background.repeat), true, (value, button) -> {
            this.background.repeat = value.getAsBoolean();
        });
        class_339 class_3392 = repeatButton.widget;
        if (class_3392 instanceof CycleButton) {
            CycleButton b = (CycleButton)class_3392;
            b.setIsActiveSupplier(consumes -> !this.background.slideLeftRight);
        }
        CellScreen.WidgetCell slideButton = this.addCycleButtonCell(CommonCycles.cycleEnabledDisabled("fancymenu.backgrounds.image.configure.slide", this.background.slideLeftRight), true, (value, button) -> {
            this.background.slideLeftRight = value.getAsBoolean();
        });
        class_339 class_3393 = slideButton.widget;
        if (class_3393 instanceof CycleButton) {
            CycleButton b = (CycleButton)class_3393;
            b.setIsActiveSupplier(consumes -> !this.background.repeat && !this.background.parallaxEnabled);
        }
        CellScreen.WidgetCell parallaxButton = this.addCycleButtonCell(CommonCycles.cycleEnabledDisabled("fancymenu.backgrounds.image.configure.parallax", this.background.parallaxEnabled), true, (value, button) -> {
            this.background.parallaxEnabled = value.getAsBoolean();
        });
        class_339 class_3394 = parallaxButton.widget;
        if (class_3394 instanceof CycleButton) {
            CycleButton b = (CycleButton)class_3394;
            b.setIsActiveSupplier(consumes -> !this.background.slideLeftRight);
        }
        this.addWidgetCell((class_339)new ExtendedButton(0, 0, 0, 20, (class_2561)class_2561.method_43471((String)"fancymenu.backgrounds.image.configure.parallax_intensity"), var1 -> {
            class_437 currentScreen = class_310.method_1551().field_1755;
            TextEditorScreen s = TextEditorScreen.build((class_2561)class_2561.method_43471((String)"fancymenu.backgrounds.image.configure.parallax_intensity"), null, callback -> {
                if (callback != null) {
                    this.background.parallaxIntensityString = callback;
                }
                class_310.method_1551().method_1507(currentScreen);
            });
            s.setText(this.background.parallaxIntensityString);
            class_310.method_1551().method_1507((class_437)s);
        }).setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.backgrounds.image.configure.parallax_intensity.desc", new String[0]))), true);
        CellScreen.WidgetCell invertParallaxCell = this.addCycleButtonCell(CommonCycles.cycleEnabledDisabled("fancymenu.backgrounds.image.configure.invert_parallax", this.background.invertParallax), true, (value, button) -> {
            this.background.invertParallax = value.getAsBoolean();
        });
        class_339 class_3395 = invertParallaxCell.widget;
        if (class_3395 instanceof ExtendedButton) {
            ExtendedButton b = (ExtendedButton)class_3395;
            b.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.backgrounds.image.configure.invert_parallax.desc", new String[0])));
        }
        this.addStartEndSpacerCell();
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        if (this.doneButton != null) {
            this.doneButton.setTooltipSupplier(consumes -> {
                if (this.background.textureSupplier == null) {
                    return Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.backgrounds.image.configure.no_image_chosen", new String[0]));
                }
                return null;
            });
        }
    }

    @Override
    public boolean allowDone() {
        return this.background.textureSupplier != null;
    }

    @Override
    protected void onCancel() {
        this.callback.accept(null);
    }

    @Override
    protected void onDone() {
        this.callback.accept(this.background);
    }
}

