/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.animationcontroller;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.SerializedElement;
import de.keksuccino.fancymenu.customization.element.anchor.ElementAnchorPoints;
import de.keksuccino.fancymenu.customization.element.elements.animationcontroller.AnimationControllerEditorElement;
import de.keksuccino.fancymenu.customization.element.elements.animationcontroller.AnimationControllerElement;
import de.keksuccino.fancymenu.customization.element.elements.animationcontroller.AnimationKeyframe;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.SerializationUtils;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import java.awt.Color;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.class_2561;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnimationControllerElementBuilder
extends ElementBuilder<AnimationControllerElement, AnimationControllerEditorElement> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new Gson();
    private static final Type KEYFRAME_LIST_TYPE = new TypeToken<ArrayList<AnimationKeyframe>>(){}.getType();
    private static final Type IDS_LIST_TYPE = new TypeToken<ArrayList<String>>(){}.getType();

    public AnimationControllerElementBuilder() {
        super("animation_controller");
    }

    @Override
    @NotNull
    public AnimationControllerElement buildDefaultInstance() {
        AnimationControllerElement element = new AnimationControllerElement(this);
        element.baseWidth = 100;
        element.baseHeight = 100;
        element.inEditorColor = DrawableColor.of(new Color(0, 255, 0, 100));
        return element;
    }

    @Override
    public AnimationControllerElement deserializeElement(@NotNull SerializedElement serialized) {
        AnimationControllerElement element = this.buildDefaultInstance();
        try {
            String targetIds = serialized.getValue("target_element_ids");
            if (targetIds != null) {
                ArrayList<String> ids = Objects.requireNonNullElse((ArrayList)GSON.fromJson(targetIds, IDS_LIST_TYPE), new ArrayList());
                ids.forEach(s -> element.targetElements.add(new AnimationControllerElement.TargetElement((String)s)));
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to deserialize target element IDs of AnimationControllerElement!", (Throwable)ex);
        }
        String keyframesJson = serialized.getValue("keyframes");
        if (keyframesJson != null) {
            try {
                element.keyframes = Objects.requireNonNullElse((ArrayList)GSON.fromJson(keyframesJson, KEYFRAME_LIST_TYPE), new ArrayList());
                element.keyframes.forEach(animationKeyframe -> {
                    animationKeyframe.anchorPoint = animationKeyframe.anchorPoint != null ? Objects.requireNonNullElse(ElementAnchorPoints.getAnchorPointByName(animationKeyframe.anchorPoint.getName()), ElementAnchorPoints.TOP_LEFT) : ElementAnchorPoints.TOP_LEFT;
                });
            }
            catch (Exception ex) {
                LOGGER.error("[FANCYMENU] Failed to deserialize animation keyframes of AnimationControllerElement!", (Throwable)ex);
            }
        }
        element.loop = SerializationUtils.deserializeBoolean(element.loop, serialized.getValue("loop"));
        element.offsetMode = SerializationUtils.deserializeBoolean(element.offsetMode, serialized.getValue("offset_mode"));
        element.ignoreSize = SerializationUtils.deserializeBoolean(element.ignoreSize, serialized.getValue("ignore_size"));
        element.ignorePosition = SerializationUtils.deserializeBoolean(element.ignorePosition, serialized.getValue("ignore_position"));
        return element;
    }

    @Override
    protected SerializedElement serializeElement(@NotNull AnimationControllerElement element, @NotNull SerializedElement serializeTo) {
        if (!element.targetElements.isEmpty()) {
            ArrayList ids = new ArrayList();
            element.targetElements.forEach(targetElement -> ids.add(targetElement.targetElementId));
            serializeTo.putProperty("target_element_ids", GSON.toJson(ids, IDS_LIST_TYPE));
        }
        if (!element.getKeyframes().isEmpty()) {
            String keyframesJson = GSON.toJson(element.getKeyframes(), KEYFRAME_LIST_TYPE);
            serializeTo.putProperty("keyframes", keyframesJson);
        }
        serializeTo.putProperty("loop", "" + element.loop);
        serializeTo.putProperty("offset_mode", "" + element.offsetMode);
        serializeTo.putProperty("ignore_size", "" + element.ignoreSize);
        serializeTo.putProperty("ignore_position", "" + element.ignorePosition);
        return serializeTo;
    }

    @Override
    @NotNull
    public AnimationControllerEditorElement wrapIntoEditorElement(@NotNull AnimationControllerElement element, @NotNull LayoutEditorScreen editor) {
        return new AnimationControllerEditorElement(element, editor);
    }

    @Override
    @NotNull
    public class_2561 getDisplayName(@Nullable AbstractElement element) {
        return class_2561.method_43471((String)"fancymenu.elements.animation_controller");
    }

    @Override
    @Nullable
    public class_2561[] getDescription(@Nullable AbstractElement element) {
        return LocalizationUtils.splitLocalizedLines("fancymenu.elements.animation_controller.desc", new String[0]);
    }
}

