/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.ticker;

import de.keksuccino.fancymenu.customization.action.ActionInstance;
import de.keksuccino.fancymenu.customization.action.blocks.AbstractExecutableBlock;
import de.keksuccino.fancymenu.customization.action.blocks.ExecutableBlockDeserializer;
import de.keksuccino.fancymenu.customization.action.blocks.GenericExecutableBlock;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.SerializedElement;
import de.keksuccino.fancymenu.customization.element.elements.ticker.TickerEditorElement;
import de.keksuccino.fancymenu.customization.element.elements.ticker.TickerElement;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayer;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayerHandler;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.events.ModReloadEvent;
import de.keksuccino.fancymenu.events.ticking.ClientTickEvent;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import de.keksuccino.fancymenu.util.event.acara.EventListener;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.konkrete.math.MathUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TickerElementBuilder
extends ElementBuilder<TickerElement, TickerEditorElement> {
    private static final Logger LOGGER = LogManager.getLogger();
    public static volatile List<TickerElement.TickerElementThreadController> cachedThreadControllers = new ArrayList<TickerElement.TickerElementThreadController>();
    public static volatile List<String> cachedOncePerSessionItems = new ArrayList<String>();

    public TickerElementBuilder() {
        super("fancymenu_customization_item_ticker");
        EventHandler.INSTANCE.registerListenersOf(this);
    }

    @EventListener
    public void onClientTickPost(ClientTickEvent.Post e) {
        ScreenCustomizationLayer m;
        ArrayList<TickerElement.TickerElementThreadController> activeControllers = new ArrayList<TickerElement.TickerElementThreadController>();
        if (class_310.method_1551().field_1755 != null && (m = ScreenCustomizationLayerHandler.getLayerOfScreen(class_310.method_1551().field_1755)) != null) {
            ArrayList<AbstractElement> elements = new ArrayList<AbstractElement>();
            elements.addAll(m.normalElements.backgroundElements);
            elements.addAll(m.normalElements.foregroundElements);
            for (AbstractElement element : elements) {
                if (!(element instanceof TickerElement)) continue;
                TickerElement te = (TickerElement)element;
                if (te.asyncThreadController == null) continue;
                activeControllers.add(te.asyncThreadController);
            }
        }
        ArrayList<TickerElement.TickerElementThreadController> keep = new ArrayList<TickerElement.TickerElementThreadController>();
        for (TickerElement.TickerElementThreadController c : cachedThreadControllers) {
            if (!activeControllers.contains(c)) {
                c.running = false;
                continue;
            }
            keep.add(c);
        }
        cachedThreadControllers = keep;
    }

    @EventListener
    public void onModReload(ModReloadEvent e) {
        cachedOncePerSessionItems.clear();
        LOGGER.info("[FancyMenu] Successfully cleared cached once-per-session ticker elements.");
    }

    @Override
    @NotNull
    public TickerElement buildDefaultInstance() {
        TickerElement i = new TickerElement(this);
        i.baseWidth = 70;
        i.baseHeight = 70;
        i.inEditorColor = DrawableColor.of(Color.ORANGE);
        return i;
    }

    @Override
    public TickerElement deserializeElement(@NotNull SerializedElement serialized) {
        TickerElement.TickMode t;
        String tickModeString;
        String isAsyncString;
        TickerElement element = this.buildDefaultInstance();
        String tickerExecutableBlockId = serialized.getValue("ticker_element_executable_block_identifier");
        if (tickerExecutableBlockId != null) {
            AbstractExecutableBlock b = ExecutableBlockDeserializer.deserializeWithIdentifier(serialized, tickerExecutableBlockId);
            if (b instanceof GenericExecutableBlock) {
                GenericExecutableBlock g;
                element.actionExecutor = g = (GenericExecutableBlock)b;
            }
        } else {
            GenericExecutableBlock g = new GenericExecutableBlock();
            g.getExecutables().addAll(ActionInstance.deserializeAll(serialized));
            element.actionExecutor = g;
        }
        String tickDelayMsString = serialized.getValue("tick_delay");
        if (tickDelayMsString != null && MathUtils.isLong((String)tickDelayMsString)) {
            element.tickDelayMs = Long.parseLong(tickDelayMsString);
        }
        if ((isAsyncString = serialized.getValue("is_async")) != null && isAsyncString.equalsIgnoreCase("true")) {
            element.isAsync = true;
        }
        if ((tickModeString = serialized.getValue("tick_mode")) != null && (t = TickerElement.TickMode.getByName(tickModeString)) != null) {
            element.tickMode = t;
        }
        return element;
    }

    @Override
    protected SerializedElement serializeElement(@NotNull TickerElement element, @NotNull SerializedElement serializeTo) {
        serializeTo.putProperty("is_async", "" + element.isAsync);
        serializeTo.putProperty("tick_delay", "" + element.tickDelayMs);
        serializeTo.putProperty("tick_mode", element.tickMode.name);
        serializeTo.putProperty("ticker_element_executable_block_identifier", element.actionExecutor.identifier);
        element.actionExecutor.serializeToExistingPropertyContainer(serializeTo);
        return serializeTo;
    }

    @Override
    @NotNull
    public TickerEditorElement wrapIntoEditorElement(@NotNull TickerElement element, @NotNull LayoutEditorScreen editor) {
        return new TickerEditorElement(element, editor);
    }

    @Override
    @NotNull
    public class_2561 getDisplayName(@Nullable AbstractElement element) {
        return class_2561.method_43471((String)"fancymenu.elements.ticker");
    }

    @Override
    @Nullable
    public class_2561[] getDescription(@Nullable AbstractElement element) {
        return LocalizationUtils.splitLocalizedLines("fancymenu.elements.ticker.desc", new String[0]);
    }
}

