/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.listener.listeners;

import de.keksuccino.fancymenu.customization.listener.AbstractListener;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OnStartLookingAtEntityListener
extends AbstractListener {
    @Nullable
    private LookedEntityData currentEntityData;

    public OnStartLookingAtEntityListener() {
        super("start_looking_at_entity");
    }

    public boolean onLookAtEntity(@NotNull class_1297 entity, double distanceToPlayer) {
        LookedEntityData newData = LookedEntityData.from(entity, distanceToPlayer);
        LookedEntityData existingData = this.currentEntityData;
        if (existingData != null && existingData.uuid().equals(newData.uuid())) {
            this.currentEntityData = newData;
            return false;
        }
        this.currentEntityData = newData;
        this.notifyAllInstances();
        return true;
    }

    public void clearCurrentEntity() {
        this.currentEntityData = null;
    }

    @Nullable
    public LookedEntityData getCurrentEntityData() {
        return this.currentEntityData;
    }

    @Nullable
    public UUID getCurrentEntityUuid() {
        return this.currentEntityData != null ? this.currentEntityData.uuid() : null;
    }

    @Override
    protected void buildCustomVariablesAndAddToList(List<AbstractListener.CustomVariable> list) {
        list.add(new AbstractListener.CustomVariable("entity_key", () -> {
            LookedEntityData data = this.currentEntityData;
            if (data == null || data.entityKey() == null) {
                return "ERROR";
            }
            return data.entityKey();
        }));
        list.add(new AbstractListener.CustomVariable("distance_to_player", () -> {
            LookedEntityData data = this.currentEntityData;
            if (data == null) {
                return "0";
            }
            return Double.toString(data.distanceToPlayer());
        }));
        list.add(new AbstractListener.CustomVariable("entity_pos_x", () -> {
            LookedEntityData data = this.currentEntityData;
            if (data == null) {
                return "0";
            }
            return Double.toString(data.entityPosX());
        }));
        list.add(new AbstractListener.CustomVariable("entity_pos_y", () -> {
            LookedEntityData data = this.currentEntityData;
            if (data == null) {
                return "0";
            }
            return Double.toString(data.entityPosY());
        }));
        list.add(new AbstractListener.CustomVariable("entity_pos_z", () -> {
            LookedEntityData data = this.currentEntityData;
            if (data == null) {
                return "0";
            }
            return Double.toString(data.entityPosZ());
        }));
        list.add(new AbstractListener.CustomVariable("entity_uuid", () -> {
            LookedEntityData data = this.currentEntityData;
            if (data == null) {
                return "ERROR";
            }
            return data.uuid().toString();
        }));
    }

    @Override
    @NotNull
    public class_2561 getDisplayName() {
        return class_2561.method_43471((String)"fancymenu.listeners.on_start_looking_at_entity");
    }

    @Override
    @NotNull
    public List<class_2561> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedLines("fancymenu.listeners.on_start_looking_at_entity.desc", new String[0]));
    }

    public record LookedEntityData(@NotNull UUID uuid, @Nullable String entityKey, double distanceToPlayer, double entityPosX, double entityPosY, double entityPosZ) {
        @NotNull
        public static LookedEntityData from(@NotNull class_1297 entity, double distanceToPlayer) {
            class_2960 entityKeyLocation = class_7923.field_41177.method_10221((Object)entity.method_5864());
            String entityKey = entityKeyLocation != null ? entityKeyLocation.toString() : null;
            return new LookedEntityData(entity.method_5667(), entityKey, distanceToPlayer, entity.method_23317(), entity.method_23318(), entity.method_23321());
        }
    }
}

