/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.placeholder.placeholders.advanced;

import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.SerializationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.class_1074;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SplitTextPlaceholder
extends Placeholder {
    private static final Logger LOGGER = LogManager.getLogger();

    public SplitTextPlaceholder() {
        super("split_text");
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        try {
            String input = dps.values.get("input");
            String regex = dps.values.get("regex");
            int maxParts = SerializationUtils.deserializeNumber(Integer.class, -1, dps.values.get("max_parts"));
            int splitIndex = SerializationUtils.deserializeNumber(Integer.class, -1, dps.values.get("split_index"));
            if (maxParts > 0 && maxParts - 1 < splitIndex) {
                LOGGER.error("[FANCYMENU] Failed to parse 'Split Text' placeholder! Max_parts is smaller than split_index!");
                return "Failed to parse! Max_parts is smaller than split_index!";
            }
            if (input != null && regex != null) {
                String[] inSplit = maxParts <= 0 ? input.split(regex) : input.split(regex, maxParts);
                if (inSplit.length - 1 < splitIndex) {
                    LOGGER.error("[FANCYMENU] Failed to parse 'Split Text' placeholder! There is no part with index " + splitIndex + "! Only " + inSplit.length + " parts found! Keep in mind first part index is 0!");
                    return "Failed to parse! There is no part with index " + splitIndex + "! Only " + inSplit.length + " parts found! Keep in mind first part index is 0!";
                }
                return inSplit[splitIndex];
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to parse 'Split Text' placeholder!", (Throwable)ex);
        }
        return null;
    }

    @Override
    @Nullable
    public List<String> getValueNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("input");
        l.add("regex");
        l.add("max_parts");
        l.add("split_index");
        return l;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return class_1074.method_4662((String)"fancymenu.placeholders.split_text", (Object[])new Object[0]);
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines("fancymenu.placeholders.split_text.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return class_1074.method_4662((String)"fancymenu.requirements.categories.advanced", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public DeserializedPlaceholderString getDefaultPlaceholderString() {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        m.put("input", "some text");
        m.put("regex", "e");
        m.put("max_parts", "2");
        m.put("split_index", "0");
        return DeserializedPlaceholderString.build(this.getIdentifier(), m);
    }
}

