/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.placeholder.placeholders.video.background;

import de.keksuccino.fancymenu.customization.background.MenuBackground;
import de.keksuccino.fancymenu.customization.background.backgrounds.video.IVideoMenuBackground;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayer;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayerHandler;
import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.class_1074;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VideoMenuBackgroundPlaytimePlaceholder
extends Placeholder {
    public VideoMenuBackgroundPlaytimePlaceholder() {
        super("video_background_playtime");
    }

    @Override
    public boolean canRunAsync() {
        return false;
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        MenuBackground background;
        ScreenCustomizationLayer layer;
        String backId = dps.values.get("background_identifier");
        String showPercentageStr = dps.values.get("show_percentage");
        boolean showPercentage = StringUtils.equalsIgnoreCase((CharSequence)showPercentageStr, (CharSequence)"true");
        if (backId != null && (layer = ScreenCustomizationLayerHandler.getActiveLayer()) != null && (background = layer.getMenuBackgroundByInstanceIdentifier(backId)) instanceof IVideoMenuBackground) {
            IVideoMenuBackground video = (IVideoMenuBackground)((Object)background);
            float playTimeSeconds = video.getPlayTime();
            float durationSeconds = video.getDuration();
            if (showPercentage) {
                if (durationSeconds > 0.0f) {
                    int percentage = (int)(playTimeSeconds / durationSeconds * 100.0f);
                    return String.valueOf(Math.min(100, Math.max(0, percentage)));
                }
                return "0";
            }
            int minutes = (int)(playTimeSeconds / 60.0f);
            int seconds = (int)(playTimeSeconds % 60.0f);
            return String.format("%02d:%02d", minutes, seconds);
        }
        return showPercentage ? "0" : "00:00";
    }

    @Override
    @Nullable
    public List<String> getValueNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("background_identifier");
        l.add("show_percentage");
        return l;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return class_1074.method_4662((String)"fancymenu.placeholders.video_background_playtime", (Object[])new Object[0]);
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines("fancymenu.placeholders.video_background_playtime.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return class_1074.method_4662((String)"fancymenu.placeholders.categories.video", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public DeserializedPlaceholderString getDefaultPlaceholderString() {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        m.put("background_identifier", "put_identifier_of_video_background_here");
        m.put("show_percentage", "false");
        return DeserializedPlaceholderString.build(this.getIdentifier(), m);
    }
}

