/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.placeholder.placeholders.world;

import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.util.LevelData;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.WorldUtils;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.class_1074;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorldSaveDataPlaceholder
extends Placeholder {
    public WorldSaveDataPlaceholder() {
        super("level_save_data");
    }

    @Override
    public boolean canRunAsync() {
        return false;
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        String levelName = dps.values.get("level_name");
        if (levelName == null) {
            return "";
        }
        List<LevelData> levelsData = WorldUtils.getLevelsAsData();
        for (LevelData data : levelsData) {
            if (!data.settings_level_name.equals(levelName)) continue;
            return data.serialize();
        }
        return "";
    }

    @Override
    @Nullable
    public List<String> getValueNames() {
        return List.of("level_name");
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return class_1074.method_4662((String)"fancymenu.placeholders.world.level_save_data", (Object[])new Object[0]);
    }

    @Override
    @Nullable
    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines("fancymenu.placeholders.world.level_save_data.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return class_1074.method_4662((String)"fancymenu.placeholders.categories.world", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public DeserializedPlaceholderString getDefaultPlaceholderString() {
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        values.put("level_name", "World");
        return new DeserializedPlaceholderString(this.getIdentifier(), values, "");
    }
}

