/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.level;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

public class StructureUtils {
    public static boolean isInStructure(@NotNull class_3218 level, @NotNull class_2338 pos, @NotNull class_5321<class_3195> structure) {
        if (!level.method_8477(pos)) {
            return false;
        }
        List<class_5321<class_3195>> structures = StructureUtils.getAllStructuresAt(level, pos);
        for (class_5321<class_3195> key : structures) {
            if (!key.toString().equals(structure.toString())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static List<class_5321<class_3195>> getAllStructuresAt(@NotNull class_3218 level, @NotNull class_2338 pos) {
        if (!level.method_8477(pos)) {
            return List.of();
        }
        class_2378 structureRegistry = level.method_30349().method_30530(class_7924.field_41246);
        ArrayList<class_5321<class_3195>> keys = new ArrayList<class_5321<class_3195>>();
        level.method_27056().method_41037(pos).forEach((structure, longs) -> {
            Optional structureKey = structureRegistry.method_29113(structure);
            structureKey.ifPresent(keys::add);
        });
        return keys;
    }

    @NotNull
    public static class_5321<class_3195> getStructureKey(@NotNull String structureId) {
        class_2960 resourceLocation = class_2960.method_60654((String)structureId);
        return StructureUtils.getStructureKey(resourceLocation);
    }

    @NotNull
    public static class_5321<class_3195> getStructureKey(@NotNull class_2960 location) {
        return class_5321.method_29179((class_5321)class_7924.field_41246, (class_2960)location);
    }

    @NotNull
    public static List<class_5321<class_3195>> getAllStructureKeys(@NotNull class_5455 registryAccess) {
        class_2378 structureRegistry = registryAccess.method_30530(class_7924.field_41246);
        return new ArrayList<class_5321<class_3195>>(structureRegistry.method_42021());
    }

    @NotNull
    public static Optional<class_5321<class_3195>> findStructureKey(@NotNull class_5455 registryAccess, @NotNull String structureName) {
        try {
            class_2960 resourceLocation = class_2960.method_60654((String)structureName);
            class_5321 key = class_5321.method_29179((class_5321)class_7924.field_41246, (class_2960)resourceLocation);
            class_2378 structureRegistry = registryAccess.method_30530(class_7924.field_41246);
            if (structureRegistry.method_35842(key)) {
                return Optional.of(key);
            }
            return Optional.empty();
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    @NotNull
    public static List<String> convertStructureKeysToStrings(@NotNull List<class_5321<class_3195>> keys) {
        ArrayList<String> stringKeys = new ArrayList<String>();
        keys.forEach(structureResourceKey -> stringKeys.add(structureResourceKey.method_29177().toString()));
        return stringKeys;
    }
}

