/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.media;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import de.keksuccino.fancymenu.util.terminal.CommandResult;
import de.keksuccino.fancymenu.util.terminal.PowerShellUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class GsmtcNowPlaying {
    private static final Gson GSON = new GsonBuilder().create();
    private static final Pattern JSON_NET_DATE = Pattern.compile("\\\\/Date\\((?<epoch>\\d+)\\)\\\\/");
    private static final String SCRIPT = "        [CmdletBinding()]\n        param(\n          [switch]$AllSessions,\n          [switch]$Json\n        )\n\n        $ErrorActionPreference = 'SilentlyContinue'\n\n        # When invoked under PowerShell Core, hop into Windows PowerShell for WinRT support.\n        if ($PSVersionTable.PSEdition -eq 'Core' -and $PSCommandPath) {\n          if (-not $env:__GSMTC_NOWPLAYING_FALLBACK) {\n            $env:__GSMTC_NOWPLAYING_FALLBACK = '1'\n            $argsList = @('-NoLogo', '-NoProfile', '-ExecutionPolicy', 'Bypass', '-File', $PSCommandPath)\n            if ($AllSessions) { $argsList += '-AllSessions' }\n            if ($Json)        { $argsList += '-Json' }\n            & \"$env:SystemRoot\\System32\\WindowsPowerShell\\v1.0\\powershell.exe\" @argsList\n            $exitCode = $LASTEXITCODE\n            Remove-Item Env:__GSMTC_NOWPLAYING_FALLBACK -ErrorAction Ignore\n            exit $exitCode\n          } else {\n            Remove-Item Env:__GSMTC_NOWPLAYING_FALLBACK -ErrorAction Ignore\n          }\n        }\n\n        # Ensure WinRT interop helpers are available (needed on Windows PowerShell 5.1)\n        try { Add-Type -AssemblyName System.Runtime.WindowsRuntime | Out-Null } catch {}\n\n        function Get-WinRtType {\n          param([Parameter(Mandatory)][string]$TypeName)\n\n          foreach ($assemblyName in @(\n            'Windows.Media.Control',\n            'Windows.Media',\n            'Windows.Storage.Streams',\n            'Windows.Storage',\n            'Windows.Foundation',\n            'Windows'\n          )) {\n            $candidate = \"$TypeName, $assemblyName, ContentType=WindowsRuntime\"\n            $resolved = [Type]::GetType($candidate, $false)\n            if ($resolved) { return $resolved }\n          }\n          $null\n        }\n\n        function Invoke-WinRtAsyncOperation {\n          param(\n            [Parameter(Mandatory)][object]$Operation,\n            [Parameter(Mandatory)][Type]$ResultType\n          )\n\n          if (-not $Operation -or -not $ResultType) { return $null }\n\n          try {\n            $opType = $Operation.GetType()\n            $getAwaiter = $opType.GetMethod('GetAwaiter', [Type[]]@())\n            if ($getAwaiter) {\n              $awaitable = $getAwaiter.Invoke($Operation, @())\n              if ($awaitable) {\n                $getResult = $awaitable.GetType().GetMethod('GetResult', [Type[]]@())\n                if ($getResult) {\n                  return $getResult.Invoke($awaitable, @())\n                }\n              }\n            }\n          } catch {}\n\n          try { Add-Type -AssemblyName System.Runtime.WindowsRuntime | Out-Null } catch {}\n          try { $extensionsType = [System.WindowsRuntimeSystemExtensions] } catch { $extensionsType = $null }\n          if ($extensionsType) {\n            $method = $extensionsType.GetMethods() | Where-Object {\n              if ($_.Name -ne 'AsTask' -or -not $_.IsGenericMethodDefinition) { return $false }\n              $parameters = $_.GetParameters()\n              if ($parameters.Count -ne 1) { return $false }\n              $paramTypeName = $parameters[0].ParameterType.ToString()\n              return $paramTypeName.StartsWith('Windows.Foundation.IAsyncOperation`1')\n            } | Select-Object -First 1\n\n            if ($method) {\n              try {\n                $generic = $method.MakeGenericMethod($ResultType)\n                $task    = $generic.Invoke($null, @($Operation))\n\n                if ($task) {\n                  $taskAwaiter = $task.GetType().GetMethod('GetAwaiter', [Type[]]@())\n                  if ($taskAwaiter) {\n                    $awaitable = $taskAwaiter.Invoke($task, @())\n                    if ($awaitable) {\n                      $getResult = $awaitable.GetType().GetMethod('GetResult', [Type[]]@())\n                      if ($getResult) {\n                        return $getResult.Invoke($awaitable, @())\n                      }\n                    }\n                  }\n\n                  if ($task -is [System.Threading.Tasks.Task]) {\n                    $task.Wait()\n                    $resultProp = $task.GetType().GetProperty('Result')\n                    if ($resultProp) {\n                      return $resultProp.GetValue($task, $null)\n                    }\n                  }\n                }\n              } catch {}\n            }\n          }\n\n          $null\n        }\n\n        # Selects the first session whose playback status matches the provided preference order.\n        function Get-SessionByStatusPriority {\n          param(\n            [Windows.Media.Control.GlobalSystemMediaTransportControlsSessionManager]$Manager,\n            [string[]]$Statuses\n          )\n\n          if (-not $Manager) { return $null }\n          $sessions = $Manager.GetSessions()\n          if (-not $sessions) { return $null }\n\n          foreach ($statusName in $Statuses) {\n            $match = $sessions | Where-Object {\n              try {\n                $info = $_.GetPlaybackInfo()\n                if (-not $info) { return $false }\n                $status = $info.PlaybackStatus\n                if (-not $status) { return $false }\n                $status.ToString() -eq $statusName\n              } catch {\n                $false\n              }\n            } | Select-Object -First 1\n\n            if ($match) { return $match }\n          }\n\n          $sessions | Select-Object -First 1\n        }\n\n        # Cached WinRT helper types used later\n        $randomAccessStreamType = Get-WinRtType 'Windows.Storage.Streams.IRandomAccessStreamWithContentType'\n        try { $streamExtensionsType = [System.IO.WindowsRuntimeStreamExtensions] } catch { $streamExtensionsType = $null }\n\n        # Get the manager\n        $mgrType = Get-WinRtType 'Windows.Media.Control.GlobalSystemMediaTransportControlsSessionManager'\n        $mgrOp   = if ($mgrType) { $mgrType::RequestAsync() } else { $null }\n        $mgr     = if ($mgrOp)   { Invoke-WinRtAsyncOperation -Operation $mgrOp -ResultType $mgrType } else { $null }\n\n        if (-not $mgr) {\n          Write-Error \"Couldn't get GSMTC session manager. Are you on Windows 10/11?\"\n          exit 1\n        }\n\n        $mediaPropsType = Get-WinRtType 'Windows.Media.Control.GlobalSystemMediaTransportControlsSessionMediaProperties'\n\n        function Get-SessionObject {\n          param([Windows.Media.Control.GlobalSystemMediaTransportControlsSession]$s)\n          if (-not $s) { return $null }\n          try {\n            $propsOp  = $s.TryGetMediaPropertiesAsync()\n            $props    = Invoke-WinRtAsyncOperation -Operation $propsOp -ResultType $mediaPropsType\n            if (-not $props) { return $null }\n            $timeline = $s.GetTimelineProperties()\n            $playback = $s.GetPlaybackInfo()\n            $thumbnailValue         = $null\n            $thumbnailContentType   = ''\n            $thumbnailBytes         = 0\n\n            if ($props.Thumbnail -and $randomAccessStreamType -and $streamExtensionsType) {\n              try {\n                $thumbOp = $props.Thumbnail.OpenReadAsync()\n                $thumbStream = Invoke-WinRtAsyncOperation -Operation $thumbOp -ResultType $randomAccessStreamType\n                if ($thumbStream) {\n                  try { $thumbnailContentType = $thumbStream.ContentType } catch { $thumbnailContentType = '' }\n\n                  try {\n                    $netStream = $streamExtensionsType::AsStreamForRead($thumbStream)\n                    if ($netStream) {\n                      $memoryStream = New-Object System.IO.MemoryStream\n                      try {\n                        $netStream.CopyTo($memoryStream)\n                        $bytes = $memoryStream.ToArray()\n                        if ($bytes -and $bytes.Length -gt 0) {\n                          $thumbnailBytes       = $bytes.Length\n                          $base64               = [Convert]::ToBase64String($bytes)\n                          $thumbnailValue       = if ($thumbnailContentType) { \"data:$thumbnailContentType;base64,$base64\" } else { $base64 }\n                        }\n                      } finally {\n                        $memoryStream.Dispose()\n                        $netStream.Dispose()\n                      }\n                    }\n                  } catch {}\n\n                  try {\n                    if ($thumbStream -is [System.IDisposable]) {\n                      $thumbStream.Dispose()\n                    } else {\n                      $thumbStream.Close()\n                    }\n                  } catch {}\n                }\n              } catch {}\n            }\n\n            $status     = $playback.PlaybackStatus\n            $statusName = if ($status) { $status.ToString() } else { '' }\n            $isPlaying  = $statusName -eq 'Playing'\n            $timelinePosition = if ($timeline.Position.Ticks -gt 0) { $timeline.Position.TotalSeconds } else { 0 }\n            $timelineEnd      = if ($timeline.EndTime.Ticks   -gt 0) { $timeline.EndTime.TotalSeconds   } else { 0 }\n            $positionSeconds  = $timelinePosition\n\n            if ($isPlaying -and $timeline.LastUpdatedTime -and $timeline.LastUpdatedTime -ne [DateTimeOffset]::MinValue) {\n              try {\n                $elapsed = ([DateTimeOffset]::Now - $timeline.LastUpdatedTime).TotalSeconds\n                $rate = if ($playback -and $playback.PlaybackRate) { $playback.PlaybackRate } else { 1.0 }\n                if ($elapsed -gt 0 -and $rate) {\n                  $positionSeconds = $timelinePosition + ($elapsed * $rate)\n                }\n              } catch {}\n            }\n\n            if ($timelineEnd -gt 0) {\n              if ($positionSeconds -gt $timelineEnd) { $positionSeconds = $timelineEnd }\n              if ($positionSeconds -lt 0) { $positionSeconds = 0 }\n            }\n\n            $pos = [math]::Round($positionSeconds)\n            $dur = [math]::Round($timelineEnd)\n\n            [pscustomobject]@{\n              appId       = $s.SourceAppUserModelId\n              title       = $props.Title\n              artist      = $props.Artist\n              album       = $props.AlbumTitle\n              albumArtist = $props.AlbumArtist\n              genres      = ($props.Genres -join ', ')\n              trackNumber = $props.TrackNumber\n              playback    = $statusName\n              playing     = $isPlaying\n              position    = $pos\n              duration    = $dur\n              thumbnail   = $thumbnailValue\n              thumbnailContentType = $thumbnailContentType\n              thumbnailBytes       = $thumbnailBytes\n              lastUpdated = if ($timeline.LastUpdatedTime) { $timeline.LastUpdatedTime } else { $null }\n              playbackRate = if ($playback -and $playback.PlaybackRate) { $playback.PlaybackRate } else { $null }\n            }\n          } catch {\n            $null\n          }\n        }\n\n        if ($AllSessions) {\n          $objs = @()\n          foreach ($s in $mgr.GetSessions()) {\n            $o = Get-SessionObject $s\n            if ($o) { $objs += $o }\n          }\n          if ($Json) {\n            $objs | ConvertTo-Json -Compress\n          } else {\n            $objs | Format-Table -Property appId,title,artist,playback,playing,position,duration -AutoSize\n          }\n          exit 0\n        }\n\n        # Default path: current session; if not playing, pick the first playing session\n        $cur = $mgr.GetCurrentSession()\n        $curStatusName = ''\n        if ($cur) {\n          try {\n            $currentStatus = $cur.GetPlaybackInfo().PlaybackStatus\n            $curStatusName = if ($currentStatus) { $currentStatus.ToString() } else { '' }\n          } catch {\n            $curStatusName = ''\n          }\n        }\n\n        $preferredStatuses = @('Playing', 'Paused', 'Changing', 'Stopped')\n\n        if (-not $cur -or $curStatusName -ne 'Playing') {\n          $candidate = Get-SessionByStatusPriority -Manager $mgr -Statuses $preferredStatuses\n          if ($candidate) {\n            $cur = $candidate\n          }\n        }\n\n        $obj = Get-SessionObject $cur\n        if ($obj) {\n          if ($Json) { $obj | ConvertTo-Json -Compress } else { $obj | Format-List }\n          exit 0\n        } else {\n        if ($Json) { '{}' } else { Write-Host \"No active media session found.\" }\n        exit 2\n      }\n";
    private static final String PERSISTENT_MODULE_SCRIPT = GsmtcNowPlaying.buildPersistentModuleScript();
    private static final PersistentPowerShell PERSISTENT = new PersistentPowerShell();

    private GsmtcNowPlaying() {
    }

    public static Optional<MediaInfo> getCurrentSession() throws IOException, InterruptedException {
        CommandResult result = GsmtcNowPlaying.runScript(false);
        if (result.exitCode() == 0) {
            return Optional.ofNullable(GsmtcNowPlaying.parseMediaInfo(result.output()));
        }
        if (result.exitCode() == 2) {
            return Optional.empty();
        }
        throw new IOException(GsmtcNowPlaying.buildErrorMessage(result));
    }

    private static MediaInfo parseMediaInfo(String json) throws JsonSyntaxException {
        String trimmed;
        String string = trimmed = json == null ? "" : json.trim();
        if (trimmed.isEmpty() || "{}".equals(trimmed)) {
            return null;
        }
        return (MediaInfo)GSON.fromJson(trimmed, MediaInfo.class);
    }

    private static CommandResult runScript(boolean allSessions) throws InterruptedException {
        try {
            return PERSISTENT.invoke(allSessions);
        }
        catch (IOException | InterruptedException e) {
            PERSISTENT.invalidate();
            if (e instanceof InterruptedException) {
                InterruptedException interrupted = (InterruptedException)e;
                Thread.currentThread().interrupt();
                throw interrupted;
            }
            return new CommandResult(2, "");
        }
    }

    private static String buildPersistentModuleScript() {
        String normalized = SCRIPT.replace("\r\n", "\n");
        String[] lines = normalized.split("\n", -1);
        StringBuilder body = new StringBuilder();
        boolean paramStarted = false;
        boolean paramClosed = false;
        boolean resetInserted = false;
        for (String line : lines) {
            String trimmed = line.trim();
            int leadingCount = line.length() - trimmed.length();
            if (leadingCount < 0) {
                leadingCount = 0;
            }
            String leading = line.substring(0, leadingCount);
            boolean isExit = false;
            if (trimmed.startsWith("exit") && (trimmed.length() == 4 || Character.isWhitespace(trimmed.charAt(4)))) {
                isExit = true;
            }
            if (isExit) {
                String exitArg = trimmed.substring(4).trim();
                if (exitArg.isEmpty()) {
                    exitArg = "0";
                }
                String indent = "    " + leading;
                body.append(indent).append("$script:__GsmtcExitCode = ").append(exitArg).append('\n');
                body.append(indent).append("return\n");
                continue;
            }
            body.append("    ").append(line).append('\n');
            if (!paramStarted && trimmed.startsWith("param(")) {
                paramStarted = true;
                continue;
            }
            if (!paramStarted || paramClosed || !trimmed.equals(")")) continue;
            paramClosed = true;
            if (resetInserted) continue;
            body.append("    Set-Variable -Scope Script -Name __GsmtcExitCode -Value 0\n");
            resetInserted = true;
        }
        if (!resetInserted) {
            body.insert(0, "    Set-Variable -Scope Script -Name __GsmtcExitCode -Value 0\n");
        }
        StringBuilder module = new StringBuilder();
        module.append("$script:__GsmtcExitCode = 0\n");
        module.append("function Invoke-GsmtcNowPlayingCore {\n");
        module.append((CharSequence)body);
        module.append("}\n");
        module.append("function Invoke-GsmtcNowPlayingRunner {\n");
        module.append("    param([switch]$AllSessions, [switch]$Json)\n");
        module.append("    $result = (& { Invoke-GsmtcNowPlayingCore -AllSessions:$AllSessions -Json:$Json } *>&1) | Out-String\n");
        module.append("    [pscustomobject]@{\n");
        module.append("        ExitCode = $script:__GsmtcExitCode\n");
        module.append("        Output = $result\n");
        module.append("    }\n");
        module.append("}\n");
        return module.toString();
    }

    private static String buildErrorMessage(CommandResult result) {
        return "PowerShell exited with " + result.exitCode() + (String)(result.output().isBlank() ? "" : " Output: " + result.output().trim());
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(PERSISTENT::close, "GsmtcNowPlaying-PS-Shutdown"));
    }

    public static final class MediaInfo {
        private String appId;
        private String title;
        private String artist;
        private String album;
        private String albumArtist;
        private String genres;
        private Integer trackNumber;
        private String playback;
        private Boolean playing;
        private Integer position;
        private Integer duration;
        private String thumbnail;
        private String thumbnailContentType;
        private Integer thumbnailBytes;
        private String lastUpdated;
        private Double playbackRate;

        public String getAppId() {
            return this.appId;
        }

        public String getTitle() {
            return this.title;
        }

        public String getArtist() {
            return this.artist;
        }

        public String getAlbum() {
            return this.album;
        }

        public String getAlbumArtist() {
            return this.albumArtist;
        }

        public String getGenres() {
            return this.genres;
        }

        public Integer getTrackNumber() {
            return this.trackNumber;
        }

        public String getPlayback() {
            return this.playback;
        }

        public boolean isPlaying() {
            return Boolean.TRUE.equals(this.playing);
        }

        public Integer getPositionSeconds() {
            return this.position;
        }

        public Integer getDurationSeconds() {
            return this.duration;
        }

        public String getThumbnail() {
            return this.thumbnail;
        }

        public String getThumbnailContentType() {
            return this.thumbnailContentType;
        }

        public Integer getThumbnailBytes() {
            return this.thumbnailBytes;
        }

        public String getLastUpdatedRaw() {
            return this.lastUpdated;
        }

        public Double getPlaybackRate() {
            return this.playbackRate;
        }

        public Instant getLastUpdatedInstant() {
            if (this.lastUpdated == null) {
                return null;
            }
            Matcher matcher = JSON_NET_DATE.matcher(this.lastUpdated);
            if (matcher.matches()) {
                long epochMillis = Long.parseLong(matcher.group("epoch"));
                return Instant.ofEpochMilli(epochMillis);
            }
            return null;
        }

        public String toString() {
            return "MediaInfo{appId='" + this.appId + "', title='" + this.title + "', artist='" + this.artist + "', playback='" + this.playback + "', playing=" + this.playing + ", position=" + this.position + ", duration=" + this.duration + "}";
        }

        public int hashCode() {
            return Objects.hash(this.appId, this.title, this.artist, this.album, this.playback, this.playing, this.position, this.duration);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof MediaInfo)) {
                return false;
            }
            MediaInfo other = (MediaInfo)obj;
            return Objects.equals(this.appId, other.appId) && Objects.equals(this.title, other.title) && Objects.equals(this.artist, other.artist) && Objects.equals(this.album, other.album) && Objects.equals(this.albumArtist, other.albumArtist) && Objects.equals(this.playback, other.playback) && Objects.equals(this.playing, other.playing) && Objects.equals(this.position, other.position) && Objects.equals(this.duration, other.duration);
        }
    }

    private static class PersistentPowerShell {
        public static final String READY_MARKER = "__READY__";
        public static final String END_MARKER = "__END__";
        public Process process;
        public BufferedWriter writer;
        public BufferedReader reader;

        private PersistentPowerShell() {
        }

        public synchronized CommandResult invoke(boolean allSessions) throws IOException, InterruptedException {
            this.ensureStarted();
            String command = this.buildInvocation(allSessions);
            this.writer.write(command);
            this.writer.flush();
            PersistentEnvelope envelope = this.readEnvelope();
            String output = envelope.output == null ? "" : envelope.output;
            return new CommandResult(envelope.exitCode, output);
        }

        public synchronized void invalidate() {
            this.close();
        }

        public synchronized void close() {
            if (this.writer != null) {
                try {
                    this.writer.write("exit\n");
                    this.writer.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.process != null) {
                this.process.destroy();
                try {
                    this.process.waitFor();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            PersistentPowerShell.closeQuietly(this.writer);
            PersistentPowerShell.closeQuietly(this.reader);
            this.process = null;
            this.writer = null;
            this.reader = null;
        }

        public void ensureStarted() throws IOException {
            if (this.process != null && this.process.isAlive()) {
                return;
            }
            this.startProcess();
        }

        public void startProcess() throws IOException {
            this.close();
            ArrayList<String> command = new ArrayList<String>();
            command.add(PowerShellUtils.locatePowerShell());
            command.add("-NoLogo");
            command.add("-NoProfile");
            command.add("-ExecutionPolicy");
            command.add("Bypass");
            command.add("-Command");
            command.add("-");
            ProcessBuilder pb = new ProcessBuilder(command);
            pb.redirectErrorStream(true);
            this.process = pb.start();
            this.writer = new BufferedWriter(new OutputStreamWriter(this.process.getOutputStream(), StandardCharsets.UTF_8));
            this.reader = new BufferedReader(new InputStreamReader(this.process.getInputStream(), StandardCharsets.UTF_8));
            this.initialize();
        }

        public void initialize() throws IOException {
            String line;
            String scriptBase64 = Base64.getEncoder().encodeToString(PERSISTENT_MODULE_SCRIPT.getBytes(StandardCharsets.UTF_8));
            this.writer.write("[Console]::InputEncoding = [System.Text.Encoding]::UTF8\n");
            this.writer.write("[Console]::OutputEncoding = [System.Text.Encoding]::UTF8\n");
            this.writer.write("$__gsmtc_script = [System.Text.Encoding]::UTF8.GetString([System.Convert]::FromBase64String('" + scriptBase64 + "'))\n");
            this.writer.write("Invoke-Expression $__gsmtc_script\n");
            this.writer.write("Write-Output '__READY__'\n");
            this.writer.flush();
            while ((line = this.reader.readLine()) != null) {
                if (READY_MARKER.equals(line)) {
                    return;
                }
                if (!line.isBlank()) continue;
            }
            this.close();
            throw new IOException("Failed to initialise persistent PowerShell host.");
        }

        public String buildInvocation(boolean allSessions) {
            String allSessionsFlag = allSessions ? "$true" : "$false";
            return "$__gsmtc_result = Invoke-GsmtcNowPlayingRunner -AllSessions:" + allSessionsFlag + " -Json:$true\n$__gsmtc_json = $__gsmtc_result | ConvertTo-Json -Compress\nWrite-Output $__gsmtc_json\nWrite-Output '__END__'\n";
        }

        public PersistentEnvelope readEnvelope() throws IOException {
            String line;
            StringBuilder buffer = new StringBuilder();
            while ((line = this.reader.readLine()) != null && !END_MARKER.equals(line)) {
                if (!buffer.isEmpty()) {
                    buffer.append('\n');
                }
                buffer.append(line);
            }
            if (line == null) {
                throw new IOException("Persistent PowerShell host terminated unexpectedly.");
            }
            String json = buffer.toString();
            if (json.isBlank()) {
                throw new IOException("Persistent PowerShell host returned empty payload.");
            }
            try {
                PersistentEnvelope envelope = (PersistentEnvelope)GSON.fromJson(json, PersistentEnvelope.class);
                if (envelope == null) {
                    throw new IOException("Unable to parse persistent PowerShell response.");
                }
                return envelope;
            }
            catch (JsonSyntaxException ex) {
                throw new IOException("Unable to parse persistent PowerShell response.", ex);
            }
        }

        public static void closeQuietly(AutoCloseable closeable) {
            if (closeable == null) {
                return;
            }
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public static final class PersistentEnvelope {
            @SerializedName(value="ExitCode")
            int exitCode;
            @SerializedName(value="Output")
            String output;
        }
    }
}

