/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.screen.scrollnormalizer;

import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.customgui.CustomGuiBaseScreen;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.scrollnormalizer.ScrollScreenNormalizerHandler;
import de.keksuccino.fancymenu.util.rendering.ui.widget.UniqueWidget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_2588;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4069;
import net.minecraft.class_437;
import net.minecraft.class_4667;
import net.minecraft.class_500;
import net.minecraft.class_5250;
import net.minecraft.class_526;
import net.minecraft.class_5375;
import net.minecraft.class_6379;
import net.minecraft.class_7417;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ScrollScreenNormalizer {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final List<ScrollableScreenBlacklistRule> SCROLLABLE_SCREEN_BLACKLIST = new ArrayList<ScrollableScreenBlacklistRule>();

    @NotNull
    public static class_437 normalizeScrollableScreen(@NotNull class_437 screen) {
        if (ScrollScreenNormalizer.isBlacklisted(screen)) {
            return screen;
        }
        if (!ScrollScreenNormalizerHandler.shouldNormalize(screen)) {
            return screen;
        }
        if (!ScreenCustomization.isCustomizationEnabledForScreen(screen)) {
            return screen;
        }
        List<class_339> extracted = ScrollScreenNormalizer.extractAllWidgetsFromScrollListsOfScreen(screen);
        IMixinScreen accessor = (IMixinScreen)screen;
        ScrollScreenNormalizer.extractAllScrollListsOfScreen(screen).forEach(scroll -> {
            scroll.method_57714(1000000, 1000000, 0);
            accessor.getChildrenFancyMenu().remove(scroll);
            accessor.getNarratablesFancyMenu().remove(scroll);
            accessor.getRenderablesFancyMenu().remove(scroll);
        });
        extracted.forEach(widget -> {
            accessor.getChildrenFancyMenu().remove(widget);
            accessor.getNarratablesFancyMenu().remove(widget);
            accessor.getRenderablesFancyMenu().remove(widget);
        });
        int pos = 50;
        HashMap<Object, Integer> ids = new HashMap<Object, Integer>();
        for (class_339 widget2 : extracted) {
            widget2.method_46421(pos);
            widget2.method_46419(pos);
            ++pos;
            if (screen instanceof class_4667 && widget2 instanceof UniqueWidget) {
                UniqueWidget w = (UniqueWidget)widget2;
                StringBuilder id = new StringBuilder("options");
                ScrollScreenNormalizer.buildId(widget2.method_25369().method_10851(), id);
                Object idString = id.toString();
                if (((String)idString).equals("options")) {
                    idString = (String)idString + "_generic";
                }
                if (ids.containsKey(idString)) {
                    int count = (Integer)ids.get(idString);
                    ids.put(idString, ++count);
                    idString = (String)idString + "_" + count;
                } else {
                    ids.put(idString, 0);
                }
                w.setWidgetIdentifierFancyMenu((String)idString);
            }
            accessor.getChildrenFancyMenu().add((class_364)widget2);
            accessor.getRenderablesFancyMenu().add((class_4068)widget2);
            accessor.getNarratablesFancyMenu().add((class_6379)widget2);
        }
        return screen;
    }

    @NotNull
    private static StringBuilder buildId(@NotNull class_7417 contents, @NotNull StringBuilder builder) {
        if (contents instanceof class_2588) {
            class_5250 c;
            class_7417 class_74172;
            Object object;
            class_2588 t = (class_2588)contents;
            builder.append("_");
            Object[] args = t.method_11023();
            if (args.length > 0 && (object = args[0]) instanceof class_5250 && (class_74172 = (c = (class_5250)object).method_10851()) instanceof class_2588) {
                class_2588 t2 = (class_2588)class_74172;
                builder.append(t2.method_11022());
                return builder;
            }
            builder.append(t.method_11022());
        }
        return builder;
    }

    public static boolean isBlacklisted(@NotNull class_437 screen) {
        for (ScrollableScreenBlacklistRule e : SCROLLABLE_SCREEN_BLACKLIST) {
            if (!e.isBlacklisted(screen)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static List<class_350<?>> extractAllScrollListsOfScreen(@NotNull class_437 screen) {
        ArrayList list = new ArrayList();
        screen.method_25396().forEach(o -> {
            if (o instanceof class_350) {
                class_350 l = (class_350)o;
                list.add(l);
            }
        });
        return list;
    }

    @NotNull
    public static List<class_339> extractAllWidgetsFromScrollListsOfScreen(@NotNull class_437 screen) {
        ArrayList<class_339> list = new ArrayList<class_339>();
        for (class_364 o : ((IMixinScreen)screen).getChildrenFancyMenu()) {
            if (!(o instanceof class_350)) continue;
            class_350 sel = (class_350)o;
            sel.method_25396().forEach(entry -> {
                if (entry instanceof class_4069) {
                    class_4069 h = (class_4069)entry;
                    ScrollScreenNormalizer.extractWidgetsRecursively(h, list);
                }
            });
        }
        return list;
    }

    private static void extractWidgetsRecursively(@NotNull class_4069 container, @NotNull List<class_339> list) {
        container.method_25396().forEach(child -> {
            if (child instanceof class_4069) {
                class_4069 childContainer = (class_4069)child;
                ScrollScreenNormalizer.extractWidgetsRecursively(childContainer, list);
            } else if (child instanceof class_339) {
                class_339 widget = (class_339)child;
                list.add(widget);
            }
        });
    }

    public static void addScrollableScreenBlacklistRule(@NotNull ScrollableScreenBlacklistRule rule) {
        SCROLLABLE_SCREEN_BLACKLIST.add(rule);
    }

    static {
        ScrollScreenNormalizer.addScrollableScreenBlacklistRule(screen -> screen instanceof class_526);
        ScrollScreenNormalizer.addScrollableScreenBlacklistRule(screen -> screen instanceof class_500);
        ScrollScreenNormalizer.addScrollableScreenBlacklistRule(screen -> screen instanceof class_5375);
        ScrollScreenNormalizer.addScrollableScreenBlacklistRule(screen -> screen instanceof CustomGuiBaseScreen);
    }

    @FunctionalInterface
    public static interface ScrollableScreenBlacklistRule {
        public boolean isBlacklisted(@NotNull class_437 var1);
    }
}

