package de.keksuccino.fancymenu;

import de.keksuccino.fancymenu.customization.gameintro.GameIntroOverlay;
import de.keksuccino.fancymenu.events.screen.ScreenKeyPressedEvent;
import de.keksuccino.fancymenu.events.screen.ScreenKeyReleasedEvent;
import de.keksuccino.fancymenu.networking.PacketHandler;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import de.keksuccino.fancymenu.util.reload.FancyMenuResourceReload;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenKeyboardEvents;
import net.fabricmc.fabric.api.resource.v1.ResourceLoader;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FancyMenuFabricClientEvents {

    private static final Logger LOGGER = LogManager.getLogger();

    public static void registerAll() {

        registerScreenEvents();

        ClientPlayConnectionEvents.JOIN.register((clientPacketListener, packetSender, minecraft) -> {
            class_310.method_1551().execute(PacketHandler::sendHandshakeToServer);
        });

        LOGGER.info("[FANCYMENU] Registering FancyMenu's resource reload listener via Fabric API..");
        ResourceLoader.get(class_3264.field_14188).registerReloader(FancyMenuResourceReload.FANCYMENU_RELOAD_LISTENER_ID, FancyMenuResourceReload.createMinecraftPreparableReloadListener());

    }

    private static void registerScreenEvents() {
        ScreenEvents.BEFORE_INIT.register((client, screen, scaledWidth, scaledHeight) -> {

            ScreenKeyboardEvents.afterKeyPress(screen).register((screen1, event) ->  {

                EventHandler.INSTANCE.postEvent(new ScreenKeyPressedEvent(screen1, event));

                if (class_310.method_1551().method_18506() instanceof GameIntroOverlay o) o.keyPressed(event);

            });

            ScreenKeyboardEvents.afterKeyRelease(screen).register((screen1, event) -> {

                EventHandler.INSTANCE.postEvent(new ScreenKeyReleasedEvent(screen1, event));

            });

        });
    }

}
