package de.keksuccino.fancymenu.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import de.keksuccino.fancymenu.networking.PacketHandler;
import de.keksuccino.fancymenu.networking.packets.commands.opengui.OpenGuiCommandPacket;
import de.keksuccino.fancymenu.util.CommandUtils;
import org.jetbrains.annotations.Nullable;
import java.util.Collection;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class OpenGuiScreenCommand {

    public static void register(CommandDispatcher<class_2168> d) {
        d.register(class_2170.method_9247("openguiscreen").then(class_2170.method_9244("screen_identifier", StringArgumentType.string())
                .executes((stack) -> {
                    return openGui(stack.getSource(), StringArgumentType.getString(stack, "screen_identifier"), null);
                })
                .suggests((context, provider) -> {
                    return CommandUtils.buildStringSuggestionsList(context, "<screen_identifier>");
                })
                .then(class_2170.method_9244("target_players", class_2186.method_9308())
                        .requires(stack -> stack.method_9259(2))
                        .executes(stack -> {
                            return openGui(stack.getSource(), StringArgumentType.getString(stack, "screen_identifier"), class_2186.method_9312(stack, "target_players"));
                        }))
        ));
    }

    private static int openGui(class_2168 stack, String menuIdentifierOrCustomGuiName, @Nullable Collection<class_3222> targets) {
        try {
            if (targets == null) {
                class_3222 sender = stack.method_9207();
                OpenGuiCommandPacket packet = new OpenGuiCommandPacket();
                packet.screen_identifier = menuIdentifierOrCustomGuiName;
                PacketHandler.sendToClient(sender, packet);
            } else {
                for (class_3222 target : targets) {
                    OpenGuiCommandPacket packet = new OpenGuiCommandPacket();
                    packet.screen_identifier = menuIdentifierOrCustomGuiName;
                    PacketHandler.sendToClient(target, packet);
                }
            }
        } catch (Exception ex) {
            stack.method_9213(class_2561.method_43470("Error while executing command!"));
            ex.printStackTrace();
        }
        return 1;
    }

}