package de.keksuccino.fancymenu.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import de.keksuccino.fancymenu.networking.PacketHandler;
import de.keksuccino.fancymenu.networking.packets.commands.variable.command.VariableCommandPacket;
import de.keksuccino.fancymenu.util.CommandUtils;
import java.util.*;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class VariableCommand {

    public static final Map<String, List<String>> CACHED_VARIABLE_SUGGESTIONS = Collections.synchronizedMap(new HashMap<>());

    public static void register(CommandDispatcher<class_2168> d) {
        d.register(class_2170.method_9247("fmvariable")
                .then(class_2170.method_9247("get")
                        .then(class_2170.method_9244("variable_name", StringArgumentType.string())
                                .suggests((context, builder) -> {
                                    return CommandUtils.buildStringSuggestionsList(context, getVariableNameSuggestions(context.getSource().method_9207()));
                                })
                                .executes((stack) -> {
                                    return getVariable(stack.getSource(), StringArgumentType.getString(stack, "variable_name"));
                                })
                        )
                )
                .then(class_2170.method_9247("set")
                        .then(class_2170.method_9244("variable_name", StringArgumentType.string())
                                .suggests((context, builder) -> {
                                    return CommandUtils.buildStringSuggestionsList(context, getVariableNameSuggestions(context.getSource().method_9207()));
                                })
                                .then(class_2170.method_9244("send_chat_feedback", BoolArgumentType.bool())
                                        .then(class_2170.method_9244("set_to_value", StringArgumentType.greedyString())
                                                .suggests((context, builder) -> {
                                                    return CommandUtils.buildStringSuggestionsList(context, "<set_to_value>");
                                                })
                                                .executes((stack) -> {
                                                    return setVariable(stack.getSource(), StringArgumentType.getString(stack, "variable_name"), StringArgumentType.getString(stack, "set_to_value"), BoolArgumentType.getBool(stack, "send_chat_feedback"));
                                                })
                                        )
                                )
                        )
                )
        );
    }

    private static String[] getVariableNameSuggestions(class_3222 sender) {
        List<String> l = new ArrayList<>(Objects.requireNonNullElse(CACHED_VARIABLE_SUGGESTIONS.get(sender.method_5667().toString()), new ArrayList<>()));
        if (l.isEmpty()) {
            l.add("<no_variables_found>");
        }
        return l.toArray(new String[0]);
    }

    private static int getVariable(class_2168 stack, String variableName) {
        try {
            if (variableName != null) {
                class_3222 sender = stack.method_9207();
                VariableCommandPacket packet = new VariableCommandPacket();
                packet.set = false;
                packet.variable_name = variableName;
                PacketHandler.sendToClient(sender, packet);
            }
        } catch (Exception ex) {
            stack.method_9213(class_2561.method_43470("Error while executing command!"));
            ex.printStackTrace();
        }
        return 1;
    }

    private static int setVariable(class_2168 stack, String variableName, String setToValue, boolean sendFeedback) {
        try {
            if ((variableName != null) && (setToValue != null)) {
                class_3222 sender = stack.method_9207();
                VariableCommandPacket packet = new VariableCommandPacket();
                packet.set = true;
                packet.variable_name = variableName;
                packet.set_to_value = setToValue;
                packet.feedback = sendFeedback;
                PacketHandler.sendToClient(sender, packet);
            }
        } catch (Exception ex) {
            stack.method_9213(class_2561.method_43470("Error while executing command!"));
            ex.printStackTrace();
        }
        return 1;
    }

}