package de.keksuccino.fancymenu.customization;

import java.io.File;
import java.io.IOException;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_6379;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.customization.customgui.CustomGuiBaseScreen;
import de.keksuccino.fancymenu.customization.widget.WidgetMeta;
import de.keksuccino.fancymenu.events.screen.CloseScreenEvent;
import de.keksuccino.fancymenu.events.screen.InitOrResizeScreenStartingEvent;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinScreen;
import de.keksuccino.fancymenu.customization.widget.WidgetLocatorHandler;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.util.event.acara.EventPriority;
import de.keksuccino.fancymenu.util.event.acara.EventListener;
import de.keksuccino.fancymenu.events.ticking.ClientTickEvent;
import de.keksuccino.fancymenu.events.ScreenReloadEvent;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CustomizableScreen;
import de.keksuccino.fancymenu.util.rendering.ui.widget.CustomizableWidget;
import de.keksuccino.fancymenu.util.window.WindowHandler;
import de.keksuccino.fancymenu.events.ModReloadEvent;
import de.keksuccino.konkrete.file.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SuppressWarnings("unused")
public class ScreenCustomizationEvents {

	private static final Logger LOGGER = LogManager.getLogger();

	private boolean iconSetAfterFullscreen = false;
	private boolean scaleChecked = false;
	private boolean resumeWorldMusic = false;
	protected class_437 lastScreen = null;

	@EventListener(priority = EventPriority.HIGH)
	public void onModReloaded(ModReloadEvent e) {
		WidgetLocatorHandler.clearCache();
		ScreenCustomization.isNewMenu = true;
		this.lastScreen = null;
	}

	@EventListener(priority =  EventPriority.HIGH)
	public void onSoftReload(ScreenReloadEvent e) {
		WidgetLocatorHandler.clearCache();
		ScreenCustomization.isNewMenu = true;
		this.lastScreen = null;
	}

	@EventListener
	public void onCloseScreen(CloseScreenEvent e) {
		if (e.getScreen() != null) {
			//Reset customizable widgets before close, so button backgrounds and other stuff gets correctly stopped
			for (class_364 l : e.getScreen().method_25396()) {
				if (l instanceof CustomizableWidget w) {
					w.resetWidgetCustomizationsFancyMenu();
				}
			}
			if (e.getScreen() instanceof LayoutEditorScreen editor) {
				for (WidgetMeta m : editor.cachedVanillaWidgetMetas) {
					if (m.getWidget() instanceof CustomizableWidget w) {
						w.resetWidgetCustomizationsFancyMenu();
					}
				}
			}
		}
	}

	@EventListener
	public void onInitStarting(InitOrResizeScreenStartingEvent e) {

		//Reset customizable widgets before init/resize (in case the screen doesn't rebuild its widgets on init/resize)
		for (class_364 l : e.getScreen().method_25396()) {
			if (l instanceof CustomizableWidget w) {
				w.resetWidgetCustomizationsFancyMenu();
			}
		}

		//Remove all remove-on-init widgets from the screen's widgets
		if (e.getScreen() instanceof CustomizableScreen c) {
			for (class_364 l : c.removeOnInitChildrenFancyMenu()) {
				((IMixinScreen)e.getScreen()).getChildrenFancyMenu().remove(l);
				if (l instanceof class_4068 r) ((IMixinScreen)e.getScreen()).getRenderablesFancyMenu().remove(r);
				if (l instanceof class_6379 n) ((IMixinScreen)e.getScreen()).getNarratablesFancyMenu().remove(n);
			}
			c.removeOnInitChildrenFancyMenu().clear();
		}

		if (this.lastScreen != null) {
			ScreenCustomization.isNewMenu = !this.lastScreen.getClass().getName().equals(e.getScreen().getClass().getName());
			if ((this.lastScreen instanceof CustomGuiBaseScreen cLast) && (e.getScreen() instanceof CustomGuiBaseScreen cNow)) {
				ScreenCustomization.isNewMenu = !cLast.getIdentifier().equals(cNow.getIdentifier());
			}
		} else {
			ScreenCustomization.isNewMenu = true;
		}

		this.lastScreen = e.getScreen();
		if (ScreenCustomization.isNewMenu) {
			WidgetLocatorHandler.clearCache();
		}

		//Stopping menu music when deactivated in config
		if ((class_310.method_1551().field_1687 == null)) {
			if (!FancyMenu.getOptions().playVanillaMenuMusic.getValue()) {
				class_310.method_1551().method_1538().method_4859();
			}
		}

	}

	@SuppressWarnings("all")
	@EventListener
	public void onTick(ClientTickEvent.Pre e) {

		if (class_310.method_1551().field_1755 == null) {
			this.lastScreen = null;
		}

		if ((class_310.method_1551().field_1687 != null) && (class_310.method_1551().field_1755 == null) && this.resumeWorldMusic) {
			class_310.method_1551().method_1483().method_4880();
			this.resumeWorldMusic = false;
		}

		if (class_310.method_1551().method_22683().method_4498()) {
			this.iconSetAfterFullscreen = false;
		} else {
			if (!this.iconSetAfterFullscreen) {
				WindowHandler.updateCustomWindowIcon();
				this.iconSetAfterFullscreen = true;
			}
		}

		//Handle default GUI scale
		if (!scaleChecked) {
			scaleChecked = true;
			int scale = FancyMenu.getOptions().defaultGuiScale.getValue();
			if ((scale != -1) && (scale != 0)) {
				File f = FancyMenu.INSTANCE_DATA_DIR;
				if (!f.exists()) {
					f.mkdirs();
				}
				File f2 = new File(f.getPath() + "/default_scale_set.fm");
				if (!f2.exists()) {
					try {
						f2.createNewFile();
						FileUtils.writeTextToFile(f2, false, "You're not supposed to be here! Shoo!");
					} catch (IOException e1) {
						e1.printStackTrace();
					}
					LOGGER.info("[FANCYMENU] Setting default GUI scale..");
					class_310.method_1551().field_1690.method_42474().method_41748(scale);
					class_310.method_1551().field_1690.method_1640();
					class_310.method_1551().method_15993();
				}
			}
		}
		
	}
	
}
