package de.keksuccino.fancymenu.customization.action.actions.screen;

import de.keksuccino.fancymenu.customization.action.Action;
import de.keksuccino.fancymenu.customization.customgui.CustomGuiBaseScreen;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.events.screen.CloseScreenEvent;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import de.keksuccino.fancymenu.util.event.acara.EventListener;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackToLastScreenAction extends Action {

    @Nullable
    protected class_437 lastScreen = null;

    public BackToLastScreenAction() {
        super("back_to_last_screen");
        EventHandler.INSTANCE.registerListenersOf(this);
    }

    @Override
    public boolean canRunAsync() {
        return false;
    }

    @Override
    public boolean hasValue() {
        return false;
    }

    @Override
    public void execute(@Nullable String value) {
        if (class_310.method_1551().field_1755 instanceof CustomGuiBaseScreen c) {
            if (c.getParentScreen() != null) {
                class_310.method_1551().method_1507(c.getParentScreen());
                return;
            }
        }
        if (this.lastScreen instanceof LayoutEditorScreen) {
            this.lastScreen = null;
        }
        class_310.method_1551().method_1507(this.lastScreen);
    }

    @Override
    public @NotNull class_2561 getActionDisplayName() {
        return class_2561.method_43471("fancymenu.actions.back_to_last_screen");
    }

    @Override
    public @NotNull class_2561[] getActionDescription() {
        return LocalizationUtils.splitLocalizedLines("fancymenu.actions.back_to_last_screen.desc");
    }

    @Override
    public class_2561 getValueDisplayName() {
        return null;
    }

    @Override
    public String getValueExample() {
        return null;
    }

    @EventListener
    public void onCloseScreen(CloseScreenEvent e) {
        if (e.getNewScreen() instanceof LayoutEditorScreen) return;
        if (this.lastScreen == e.getNewScreen()) return;
        this.lastScreen = e.getClosedScreen();
        if (e.getNewScreen() == null) this.lastScreen = null;
    }

}
