package de.keksuccino.fancymenu.customization.action.actions.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.action.Action;
import de.keksuccino.fancymenu.customization.customgui.CustomGuiHandler;
import de.keksuccino.fancymenu.customization.screen.identifier.ScreenIdentifierHandler;
import de.keksuccino.fancymenu.customization.screen.ScreenInstanceFactory;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.ui.screen.NotificationScreen;
import de.keksuccino.fancymenu.util.threading.MainThreadTaskExecutor;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_424;
import net.minecraft.class_437;
import net.minecraft.class_525;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenScreenAction extends Action {

    private static final Logger LOGGER = LogManager.getLogger();

    private static long lastErrorTriggered = -1;

    public OpenScreenAction() {
        super("opengui");
    }

    @Override
    public boolean canRunAsync() {
        return false;
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public void execute(@Nullable String value) {
        if (value != null) {
            if (RenderSystem.isOnRenderThread()) {
                value = ScreenIdentifierHandler.tryFixInvalidIdentifierWithNonUniversal(value);
                if (value.equals(class_525.class.getName())) {
                    class_437 current = class_310.method_1551().field_1755;
                    class_525.method_31130(class_310.method_1551(), () -> class_310.method_1551().method_1507(current));
                } else {
                    if (CustomGuiHandler.guiExists(value)) {
                        class_437 custom = CustomGuiHandler.constructInstance(value, class_310.method_1551().field_1755, null);
                        if (custom != null) class_310.method_1551().method_1507(custom);
                    } else {
                        class_437 s = ScreenInstanceFactory.tryConstruct(value);
                        if (s != null) {
                            class_310.method_1551().method_1507(s);
                        } else {
                            LOGGER.error("[FANCYMENU] Unable to construct screen instance for '" + value + "'!", new Exception());
                            class_437 current = class_310.method_1551().field_1755;
                            class_310.method_1551().method_1507(NotificationScreen.error(aBoolean -> {
                                class_310.method_1551().method_1507(current);
                            }, LocalizationUtils.splitLocalizedLines("fancymenu.actions.open_screen.error")));
                        }
                    }
                }
            } else {
                long now = System.currentTimeMillis();
                if ((lastErrorTriggered + 60000) < now) {
                    lastErrorTriggered = now;
                    MainThreadTaskExecutor.executeInMainThread(
                            () -> class_310.method_1551().method_1507(new class_424(class_2561.method_43469("fancymenu.actions.generic.async_error", this.getActionDisplayName()))),
                            MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK);
                }
            }
        }
    }

    @Override
    public @NotNull class_2561 getActionDisplayName() {
        return class_2561.method_43471("fancymenu.actions.opengui");
    }

    @Override
    public @NotNull class_2561[] getActionDescription() {
        return LocalizationUtils.splitLocalizedLines("fancymenu.actions.opengui.desc");
    }

    @Override
    public class_2561 getValueDisplayName() {
        return class_2561.method_43471("fancymenu.actions.opengui.desc.value");
    }

    @Override
    public String getValueExample() {
        return "example.menu.identifier";
    }

}
