package de.keksuccino.fancymenu.customization.action.ui;

import de.keksuccino.fancymenu.customization.action.Action;
import de.keksuccino.fancymenu.customization.action.ActionRegistry;
import de.keksuccino.fancymenu.customization.action.ActionInstance;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.util.rendering.text.TextFormattingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.InitialWidgetFocusScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.LogicExecutorScreen;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v2.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v2.scrollarea.entry.ScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v2.scrollarea.entry.TextListScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v2.scrollarea.entry.TextScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.ExtendedEditBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class ChooseActionScreen extends class_437 implements InitialWidgetFocusScreen {

    protected final ActionInstance instance;
    protected Consumer<ActionInstance> callback;
    protected Action originalAction = null;
    protected String originalActionValue = null;

    protected ScrollArea actionsListScrollArea = new ScrollArea(0, 0, 0, 0);
    protected ScrollArea descriptionScrollArea = new ScrollArea(0, 0, 0, 0);
    protected ExtendedEditBox searchBar;

    public boolean isEdit;

    public ChooseActionScreen(@Nullable ActionInstance instanceToEdit, @NotNull Consumer<ActionInstance> callback) {

        super((instanceToEdit != null) ? class_2561.method_43471("fancymenu.actions.screens.edit_action") : class_2561.method_43471("fancymenu.actions.screens.add_action"));

        this.isEdit = (instanceToEdit != null);

        if (this.isEdit) {
            this.originalAction = instanceToEdit.action;
            this.originalActionValue = instanceToEdit.value;
        }
        this.instance = this.isEdit ? instanceToEdit : new ActionInstance(Action.EMPTY, null);
        this.callback = callback;

    }

    @Override
    protected void method_25426() {

        String oldSearchValue = (this.searchBar != null) ? this.searchBar.method_1882() : "";
        this.searchBar = new ExtendedEditBox(class_310.method_1551().field_1772, 20 + 1, 50 + 15 + 1, (this.field_22789 / 2) - 40 - 2, 20 - 2, class_2561.method_43473());
        this.searchBar.setHintFancyMenu(consumes -> class_2561.method_43471("fancymenu.actions.build_action.screen.search_action"));
        this.searchBar.method_1852(oldSearchValue);
        this.searchBar.method_1863(s -> this.updateActionsList());
        this.method_37063(this.searchBar);
        UIBase.applyDefaultWidgetSkinTo(this.searchBar);
        this.setupInitialFocusWidget(this, this.searchBar);

        // Set positions for scroll areas
        this.actionsListScrollArea.setWidth((this.field_22789 / 2) - 40, true);
        this.actionsListScrollArea.setHeight(this.field_22790 - 85 - 25, true);
        this.actionsListScrollArea.setX(20, true);
        this.actionsListScrollArea.setY(50 + 15 + 25, true);
        this.method_37063(this.actionsListScrollArea);

        this.descriptionScrollArea.setWidth((this.field_22789 / 2) - 40, true);
        this.descriptionScrollArea.setHeight(Math.max(40, (this.field_22790 / 2) - 50 - 25), true);
        this.descriptionScrollArea.setX(this.field_22789 - 20 - this.descriptionScrollArea.getWidthWithBorder(), true);
        this.descriptionScrollArea.setY(50 + 15, true);
        this.descriptionScrollArea.horizontalScrollBar.active = false;
        this.method_37063(this.descriptionScrollArea);

        // Calculate button positions
        int cancelButtonX = this.field_22789 - 20 - 150;
        int cancelButtonY = this.field_22790 - 20 - 20 - 5 - 20;
        int doneButtonX = this.field_22789 - 20 - 150;
        int doneButtonY = this.field_22790 - 20 - 20;

        // Create buttons with proper positions in constructors
        ExtendedButton doneOrNextButton = new ExtendedButton(doneButtonX, doneButtonY, 150, 20, class_2561.method_43473(), (button) -> {
            this.onNextStep();
        }).setLabelSupplier(consumes -> this.needsValueFirst() ? class_2561.method_43471("fancymenu.ui.generic.next_step") : class_2561.method_43471("fancymenu.common_components.done"));
        this.method_37063(doneOrNextButton);
        UIBase.applyDefaultWidgetSkinTo(doneOrNextButton);

        ExtendedButton cancelButton = new ExtendedButton(cancelButtonX, cancelButtonY, 150, 20, class_2561.method_43471("fancymenu.common_components.cancel"), (button) -> {
            this.callback.accept(null);
        });
        this.method_37063(cancelButton);
        UIBase.applyDefaultWidgetSkinTo(cancelButton);

        this.updateActionsList();
        this.setDescription(this.instance.action);

        if (this.isEdit) {
            // Skip this screen and go directly to value configuration it's an edit
            this.onNextStep();
        }

    }

    protected void onEditValue() {
        if (this.instance.action == Action.EMPTY) return;
        this.originalAction = null;
        this.originalActionValue = null;
        this.instance.action.editValue(LogicExecutorScreen.build(() -> {
            if (this.canClickDone()) {
                this.onDone();
            } else {
                class_310.method_1551().method_1507(this);
            }
        }), this.instance);
    }

    protected boolean hasValue() {
        return (this.instance.action != Action.EMPTY) && this.instance.action.hasValue();
    }

    protected void onDone() {
        this.callback.accept((this.instance.action != Action.EMPTY) ? this.instance : null);
    }

    protected boolean canClickDone() {
        if (this.instance.action == Action.EMPTY) return false;
        return (this.instance.value != null) || !this.instance.action.hasValue();
    }

    protected boolean needsValueFirst() {
        return this.hasValue() && !this.canClickDone();
    }

    protected void onNextStep() {
        if (this.hasValue()) {
            this.onEditValue();
        } else if (this.canClickDone()) {
            this.onDone();
        }
    }

    @Override
    public void method_25419() {
        this.callback.accept(null);
    }

    @Override
    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {

        graphics.method_25294(0, 0, this.field_22789, this.field_22790, UIBase.getUIColorTheme().screen_background_color.getColorInt());

        class_2561 titleComp = this.field_22785.method_27661().method_27696(class_2583.field_24360.method_10982(true));
        graphics.method_51439(this.field_22793, titleComp, 20, 20, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);

        graphics.method_51439(this.field_22793, class_2561.method_43471("fancymenu.actions.screens.build_screen.available_actions"), 20, 50, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);

        class_2561 descLabel = class_2561.method_43471("fancymenu.actions.screens.build_screen.action_description");
        int descLabelWidth = this.field_22793.method_27525(descLabel);
        graphics.method_51439(this.field_22793, descLabel, this.field_22789 - 20 - descLabelWidth, 50, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);

        super.method_25394(graphics, mouseX, mouseY, partial);

        this.performInitialWidgetFocusActionInRender();

    }

    @Override
    public void method_25420(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
    }

    protected void setDescription(@Nullable Action action) {

        this.descriptionScrollArea.clearEntries();

        this.descriptionScrollArea.addEntry(new CellScreen.SpacerScrollAreaEntry(this.descriptionScrollArea, 5));

        if ((action != null) && (action.getActionDescription() != null)) {
            for (class_2561 c : action.getActionDescription()) {
                this.addDescriptionLine(c);
            }
        }

        this.descriptionScrollArea.addEntry(new CellScreen.SpacerScrollAreaEntry(this.descriptionScrollArea, 5));

    }

    protected void addDescriptionLine(@NotNull class_2561 line) {
        List<class_2561> lines = new ArrayList<>();
        int maxWidth = (int)(this.descriptionScrollArea.getInnerWidth() - 15F);
        if (this.field_22793.method_27525(line) > maxWidth) {
            this.field_22793.method_27527().method_27495(line, maxWidth, class_2583.field_24360).forEach(formatted -> {
                lines.add(TextFormattingUtils.convertFormattedTextToComponent(formatted));
            });
        } else {
            lines.add(line);
        }
        lines.forEach(component -> {
            TextScrollAreaEntry e = new TextScrollAreaEntry(this.descriptionScrollArea, component, (entry) -> {});
            e.setSelectable(false);
            e.setBackgroundColorHover(e.getBackgroundColorNormal());
            e.setPlayClickSound(false);
            e.setTextBaseColor(UIBase.getUIColorTheme().description_area_text_color.getColorInt());
            this.descriptionScrollArea.addEntry(e);
        });
    }

    protected boolean actionFitsSearchValue(@NotNull Action action, @Nullable String s) {
        if ((s == null) || s.isBlank()) return true;
        s = s.toLowerCase();
        if (action.getActionDisplayName().getString().toLowerCase().contains(s)) return true;
        return this.actionDescriptionContains(action, s);
    }

    protected boolean actionDescriptionContains(@NotNull Action action, @NotNull String s) {
        class_2561[] desc = Objects.requireNonNullElse(action.getActionDescription(), new class_2561[0]);
        for (class_2561 c : desc) {
            if (c.getString().toLowerCase().contains(s)) return true;
        }
        return false;
    }

    protected void setContentOfActionsList() {

        String searchValue = (this.searchBar != null) ? this.searchBar.method_1882() : "";
        if (searchValue.isBlank()) searchValue = null;

        this.actionsListScrollArea.clearEntries();
        List<Action> actions = ActionRegistry.getActions();
        actions.sort(Comparator
                .comparing((Action action) -> action.getActionDisplayName().getString(), String.CASE_INSENSITIVE_ORDER)
                .thenComparing(action -> action.getActionDisplayName().getString())
                .thenComparing(Action::getIdentifier));
        for (Action action : actions) {
            if ((LayoutEditorScreen.getCurrentInstance() != null) && !action.shouldShowUpInEditorActionMenu(LayoutEditorScreen.getCurrentInstance())) continue;
            if (!this.actionFitsSearchValue(action, searchValue)) continue;
            ActionScrollEntry e = new ActionScrollEntry(this.actionsListScrollArea, action, (entry) -> {
                this.instance.action = action;
                if (this.originalAction == action) {
                    this.instance.value = this.originalActionValue;
                } else {
                    this.instance.value = null;
                }
                this.setDescription(action);
            });
            this.actionsListScrollArea.addEntry(e);
        }

    }

    protected void updateActionsList() {

        this.setContentOfActionsList();

        //Select correct entry
        if (this.instance.action != Action.EMPTY) {
            for (ScrollAreaEntry e : this.actionsListScrollArea.getEntries()) {
                if ((e instanceof ActionScrollEntry) && (((ActionScrollEntry)e).action == this.instance.action)) {
                    e.setSelected(true);
                    break;
                }
            }
        }

    }

    public class ActionScrollEntry extends TextListScrollAreaEntry {

        public Action action;
        protected long lastClickTime = 0;
        protected static final long DOUBLE_CLICK_TIME = 500; // milliseconds

        public ActionScrollEntry(ScrollArea parent, @NotNull Action action, @NotNull Consumer<TextListScrollAreaEntry> onClick) {
            super(parent, buildLabel(action), UIBase.getUIColorTheme().listing_dot_color_1, onClick);
            this.action = action;
        }

        @NotNull
        private static class_2561 buildLabel(@NotNull Action action) {
            class_5250 c = action.getActionDisplayName().method_27661().method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().element_label_color_normal.getColorInt()));
            if (action.isDeprecated()) {
                c = c.method_27696(class_2583.field_24360.method_36140(true));
                c = c.method_10852(class_2561.method_43470(" ").method_10862(class_2583.field_24360.method_36140(false)));
                c = c.method_10852(class_2561.method_43471("fancymenu.actions.deprecated").method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().error_text_color.getColorInt()).method_36140(false)));
            }
            return c;
        }

        @Override
        public void onClick(ScrollAreaEntry entry, double mouseX, double mouseY, int button) {
            long currentTime = System.currentTimeMillis();
            
            // Check if this is a double-click
            if (currentTime - this.lastClickTime < DOUBLE_CLICK_TIME) {
                // Double-click detected
                if (ChooseActionScreen.this.instance.action == this.action) {
                    ChooseActionScreen.this.onNextStep();
                    this.lastClickTime = 0; // Reset to prevent triple clicks
                    return;
                }
            }
            
            this.lastClickTime = currentTime;
            
            // Normal single click behavior
            super.onClick(entry, mouseX, mouseY, button);
        }

    }

}
