package de.keksuccino.fancymenu.customization.background;

import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementMemories;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayer;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayerHandler;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.util.properties.RuntimePropertyContainer;
import de.keksuccino.fancymenu.util.rendering.ui.widget.NavigatableWidget;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import de.keksuccino.fancymenu.customization.layout.Layout;

public abstract class MenuBackground implements class_4068, class_364, class_6379, NavigatableWidget {

    public final MenuBackgroundBuilder<?> builder;
    @NotNull
    protected String instanceIdentifier = ScreenCustomization.generateUniqueIdentifier();
    /** This gets set by the {@link ScreenCustomizationLayer} when screens fade in or out and should only get used as getter. **/
    public float opacity = 1.0F;
    /** This gets set by the {@link ScreenCustomizationLayer} and should only be used as getter. **/
    public boolean keepBackgroundAspectRatio = false;
    @Nullable
    protected RuntimePropertyContainer cachedMemory;

    public MenuBackground(MenuBackgroundBuilder<?> builder) {
        this.builder = builder;
    }

    @Override
    public abstract void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial);

    /** Gets called every {@link class_437} tick, after {@link class_437#method_25393()} got called. **/
    public void tick() {
    }

    /**
     * Gets called before a {@link class_437} gets closed.<br>
     * A screen gets closed when a new active {@link class_437} gets set via {@link class_310#method_1507(class_437)}.<br><br>
     */
    public void onCloseScreen(@Nullable class_437 closedScreen, @Nullable class_437 newScreen) {
    }

    /**
     * Gets called before a {@link class_437} gets closed.<br>
     * A screen gets closed when a new {@link class_437} gets set via {@link class_310#method_1507(class_437)}.
     */
    @Deprecated
    public void onCloseScreen() {
    }

    /**
     * Gets called after a {@link class_437} got opened via {@link class_310#method_1507(class_437)}.<br>
     * The {@link class_437} is already initialized at the time this method gets called.
     */
    public void onOpenScreen() {
    }

    /**
     * Gets called before the current {@link class_437} gets resized.<br>
     * Does NOT get called on initial resize (when opening the screen). Use {@link MenuBackground#onOpenScreen()} for that instead.
     */
    public void onBeforeResizeScreen() {
    }

    /**
     * Gets called after the current {@link class_437} got resized.<br>
     * Does NOT get called on initial resize (when opening the screen). Use {@link MenuBackground#onOpenScreen()} for that instead.
     */
    public void onAfterResizeScreen() {
    }

    /**
     * Gets called right after the background got enabled in a layout.<br>
     * This gets called whenever the background gets enabled, which means it will also trigger on every (re-)init and resize of the target {@link class_437}.
     */
    public void onAfterEnable() {
    }

    /**
     * Gets called before the background gets disabled or removed. This is the case when, for example, customizations get disabled
     * for the target {@link class_437}, when the parent {@link Layout} gets disabled or when the background gets removed/replaced in the editor.
     */
    public void onDisableOrRemove() {
    }

    /**
     * The memory of a {@link MenuBackground} remembers variables across instance rebuilding.<br>
     * It can be used if a background needs to access data of its ancestors.<br><br>
     *
     * Every background (based on its instance identifier) has its own memory.
     */
    @NotNull
    public RuntimePropertyContainer getMemory() {
        if (this.cachedMemory == null) {
            this.cachedMemory = ElementMemories.getMemory(this.getInstanceIdentifier());
        }
        return this.cachedMemory;
    }

    @NotNull
    public String getInstanceIdentifier() {
        return this.instanceIdentifier;
    }

    @Nullable
    public Layout getParentLayout() {
        ScreenCustomizationLayer layer = ScreenCustomizationLayerHandler.getActiveLayer();
        if (layer != null) {
            for (Layout layout : layer.activeLayouts) {
                if (layout.menuBackgrounds.contains(this)) return layout;
            }
        }
        return null;
    }

    @Nullable
    public MenuBackground copy() {
        try {
            return this.builder.deserializeBackgroundInternal(this.builder.serializedBackgroundInternal(this));
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static boolean isEditor() {
        return (class_310.method_1551().field_1755 instanceof LayoutEditorScreen);
    }

    public static int getScreenWidth() {
        return AbstractElement.getScreenWidth();
    }

    public static int getScreenHeight() {
        return AbstractElement.getScreenHeight();
    }

    @Override
    public void method_25365(boolean var1) {
    }

    @Override
    public boolean method_25370() {
        return false;
    }

    @Override
    public @NotNull class_6380 method_37018() {
        return class_6380.field_33784;
    }

    @Override
    public void method_37020(@NotNull class_6382 narrationElementOutput) {
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public void setFocusable(boolean focusable) {
        throw new RuntimeException("MenuBackgrounds are not focusable!");
    }

    @Override
    public boolean isNavigatable() {
        return false;
    }

    @Override
    public void setNavigatable(boolean navigatable) {
        throw new RuntimeException("MenuBackgrounds are not navigatable!");
    }

}
