package de.keksuccino.fancymenu.customization.background.backgrounds.video.mcef;

import de.keksuccino.fancymenu.customization.background.MenuBackgroundBuilder;
import de.keksuccino.fancymenu.customization.background.SerializedMenuBackground;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.SerializationUtils;
import de.keksuccino.fancymenu.util.resource.ResourceSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_437;

public class MCEFVideoMenuBackgroundBuilder extends MenuBackgroundBuilder<MCEFVideoMenuBackground> {

    public MCEFVideoMenuBackgroundBuilder() {
        super("video_mcef");
    }

    @Override
    public void buildNewOrEditInstance(class_437 currentScreen, @Nullable MCEFVideoMenuBackground backgroundToEdit, @NotNull Consumer<MCEFVideoMenuBackground> backgroundConsumer) {
        MCEFVideoMenuBackground back = (backgroundToEdit != null) ? (MCEFVideoMenuBackground) backgroundToEdit.copy() : null;
        if (back == null) {
            back = new MCEFVideoMenuBackground(this);
        }
        MCEFVideoMenuBackgroundConfigScreen s = new MCEFVideoMenuBackgroundConfigScreen(back, background -> {
            if (background != null) {
                backgroundConsumer.accept(background);
            } else {
                backgroundConsumer.accept(backgroundToEdit);
            }
            class_310.method_1551().method_1507(currentScreen);
        });
        class_310.method_1551().method_1507(s);
    }

    @Override
    public MCEFVideoMenuBackground deserializeBackground(SerializedMenuBackground serialized) {

        MCEFVideoMenuBackground background = new MCEFVideoMenuBackground(this);

        String source = serialized.getValue("source");
        background.rawVideoUrlSource = (source != null) ? ResourceSource.of(source) : null;
        background.loop = SerializationUtils.deserializeBoolean(background.loop, serialized.getValue("loop"));
        background.volume = SerializationUtils.deserializeNumber(Float.class, background.volume, serialized.getValue("volume"));
        String soundSource = serialized.getValue("sound_source");
        if (soundSource != null) background.soundSource = Objects.requireNonNullElse(getSoundSourceByName(soundSource), class_3419.field_15250);

        background.parallaxEnabled = SerializationUtils.deserializeBoolean(background.parallaxEnabled, serialized.getValue("parallax"));
        background.parallaxIntensityString = Objects.requireNonNullElse(serialized.getValue("parallax_intensity"), "0.02");
        background.invertParallax = SerializationUtils.deserializeBoolean(background.invertParallax, serialized.getValue("invert_parallax"));

        return background;

    }

    @Override
    public SerializedMenuBackground serializedBackground(MCEFVideoMenuBackground background) {

        SerializedMenuBackground serialized = new SerializedMenuBackground();

        if (background.rawVideoUrlSource != null) {
            serialized.putProperty("source", background.rawVideoUrlSource.getSerializationSource());
        }
        serialized.putProperty("loop", "" + background.loop);
        serialized.putProperty("volume", "" + background.volume);
        serialized.putProperty("sound_source", background.soundSource.method_14840());

        serialized.putProperty("parallax", "" + background.parallaxEnabled);
        serialized.putProperty("parallax_intensity", background.parallaxIntensityString);
        serialized.putProperty("invert_parallax", "" + background.invertParallax);

        return serialized;

    }

    @Override
    public @NotNull class_2561 getDisplayName() {
        return class_2561.method_43471("fancymenu.backgrounds.video_mcef");
    }

    @Override
    public @Nullable class_2561[] getDescription() {
        return LocalizationUtils.splitLocalizedLines("fancymenu.backgrounds.video_mcef.desc");
    }

    @Nullable
    protected static class_3419 getSoundSourceByName(@NotNull String name) {
        for (class_3419 source : class_3419.values()) {
            if (source.method_14840().equals(name)) return source;
        }
        return null;
    }

}
