package de.keksuccino.fancymenu.customization.background.backgrounds.video.mcef;

import de.keksuccino.fancymenu.customization.element.elements.video.SetVideoVolumeScreen;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.SerializationUtils;
import de.keksuccino.fancymenu.util.cycle.CommonCycles;
import de.keksuccino.fancymenu.util.cycle.LocalizedGenericValueCycle;
import de.keksuccino.fancymenu.util.input.CharacterFilter;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.TextInputScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.resource.ResourceChooserScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorScreen;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.fancymenu.util.resource.ResourceSource;
import org.jetbrains.annotations.NotNull;
import java.util.Arrays;
import java.util.function.Consumer;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_437;

public class MCEFVideoMenuBackgroundConfigScreen extends CellScreen {

    @NotNull
    protected Consumer<MCEFVideoMenuBackground> callback;
    @NotNull MCEFVideoMenuBackground background;

    protected MCEFVideoMenuBackgroundConfigScreen(@NotNull MCEFVideoMenuBackground background, @NotNull Consumer<MCEFVideoMenuBackground> callback) {
        super(class_2561.method_43471("fancymenu.backgrounds.video_mcef.configure"));
        this.background = background;
        this.callback = callback;
    }

    @Override
    protected void initCells() {

        this.addStartEndSpacerCell();

        this.addWidgetCell(new ExtendedButton(0, 0, 20, 20, class_2561.method_43471("fancymenu.elements.video_mcef.set_source"), button -> {
            class_310.method_1551().method_1507(ResourceChooserScreen.video(null, source -> {
                if (source != null) {
                    this.background.rawVideoUrlSource = ResourceSource.of(source);
                }
                class_310.method_1551().method_1507(this);
            }).setSource((this.background.rawVideoUrlSource != null) ? this.background.rawVideoUrlSource.getSerializationSource() : null, false));
        }), true);

        this.addCycleButtonCell(CommonCycles.cycleEnabledDisabled("fancymenu.elements.video_mcef.loop", this.background.loop), true, (value, button) -> {
            this.background.loop = value.getAsBoolean();
        });

        this.addWidgetCell(new ExtendedButton(0, 0, 20, 20, class_2561.method_43471("fancymenu.elements.video_mcef.volume"), button -> {
            class_310.method_1551().method_1507(new SetVideoVolumeScreen(this.background.volume, vol -> {
                if (vol != null) {
                    this.background.volume = vol;
                }
                class_310.method_1551().method_1507(this);
            }));
        }), true);

        LocalizedGenericValueCycle<class_3419> soundSourceCycle = CommonCycles.cycle("fancymenu.elements.video_mcef.sound_channel", Arrays.asList(class_3419.values()), this.background.soundSource)
                .setValueNameSupplier(consumes -> class_1074.method_4662("soundCategory." + consumes.method_14840()))
                .setValueComponentStyleSupplier(consumes -> class_2583.field_24360.method_36139(UIBase.getUIColorTheme().warning_text_color.getColorInt()));
        this.addCycleButtonCell(soundSourceCycle, true, (value, button) -> {
            this.background.soundSource = value;
        });

        this.addCellGroupEndSpacerCell();

        this.addCycleButtonCell(CommonCycles.cycleEnabledDisabled("fancymenu.backgrounds.image.configure.parallax", this.background.parallaxEnabled), true, (value, button) -> {
            this.background.parallaxEnabled = value.getAsBoolean();
        });

        this.addWidgetCell(new ExtendedButton(0, 0, 0, 20, class_2561.method_43471("fancymenu.backgrounds.image.configure.parallax_intensity"), var1 -> {
            final class_437 currentScreen = class_310.method_1551().field_1755;
            TextEditorScreen s = TextEditorScreen.build(class_2561.method_43471("fancymenu.backgrounds.image.configure.parallax_intensity"), null, callback -> {
                if (callback != null) {
                    this.background.parallaxIntensityString = callback;
                }
                class_310.method_1551().method_1507(currentScreen);
            });
            s.setText(this.background.parallaxIntensityString);
            class_310.method_1551().method_1507(s);
        }).setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.backgrounds.image.configure.parallax_intensity.desc"))), true);

        WidgetCell invertParallaxCell = this.addCycleButtonCell(CommonCycles.cycleEnabledDisabled("fancymenu.backgrounds.image.configure.invert_parallax", this.background.invertParallax), true, (value, button) -> {
            this.background.invertParallax = value.getAsBoolean();
        });
        if (invertParallaxCell.widget instanceof ExtendedButton b) {
            b.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.backgrounds.image.configure.invert_parallax.desc")));
        }

        this.addStartEndSpacerCell();

    }

    @Override
    protected void method_25426() {

        super.method_25426();

        if (this.doneButton != null) {
            this.doneButton.setTooltipSupplier(consumes -> {
                if (this.background.rawVideoUrlSource == null) return Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.backgrounds.video_mcef.configure.no_video"));
                return null;
            });
        }

    }

    @Override
    public boolean allowDone() {
        return (this.background.rawVideoUrlSource != null);
    }

    @Override
    protected void onCancel() {
        this.callback.accept(null);
    }

    @Override
    protected void onDone() {
        this.callback.accept(this.background);
    }

}