package de.keksuccino.fancymenu.customization.element.elements.dragger;

import net.minecraft.class_1144;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_6382;
import org.jetbrains.annotations.NotNull;

public class DraggerWidget extends class_339 {

    @NotNull
    public DraggingCallback draggingCallback;
    @NotNull
    public MouseCallback mouseCallback;
    protected boolean leftMouseDown = false;

    public DraggerWidget(int x, int y, int width, int height, @NotNull DraggingCallback draggingCallback, @NotNull MouseCallback mouseCallback) {
        super(x, y, width, height, class_2561.method_43473());
        this.draggingCallback = draggingCallback;
        this.mouseCallback = mouseCallback;
    }

    @Override
    protected void method_48579(@NotNull class_332 guiGraphics, int i, int i1, float v) {
    }

    @Override
    protected void method_47399(@NotNull class_6382 narrationElementOutput) {
    }

    @Override
    public void method_25354(@NotNull class_1144 soundManager) {
        //don't play click/down sound
    }

    @Override
    public boolean method_25402(class_11909 event, boolean isDoubleClick) {
        if (this.canClick()) {
            this.leftMouseDown = true;
            this.mouseCallback.onClickOrRelease(event.comp_4798(), event.comp_4799(), false);
            return true;
        }
        return super.method_25402(event, isDoubleClick);
    }

    @Override
    public boolean method_25406(class_11909 event) {
        if (this.leftMouseDown) {
            this.leftMouseDown = false;
            this.mouseCallback.onClickOrRelease(event.comp_4798(), event.comp_4799(), true);
            return true;
        }
        return super.method_25406(event);
    }

    @Override
    public boolean method_25403(class_11909 event, double dragX, double dragY) {
        if (this.leftMouseDown) {
            this.draggingCallback.onDrag(event.comp_4798(), event.comp_4799(), dragX, dragY);
            return true;
        }
        return super.method_25403(event, dragX, dragY);
    }

    protected boolean canClick() {
        return (this.method_49606() && this.method_37303() && this.field_22764);
    }

    @FunctionalInterface
    public interface DraggingCallback {
        void onDrag(double mouseX, double mouseY, double dragX, double dragY);
    }

    @FunctionalInterface
    public interface MouseCallback {
        void onClickOrRelease(double mouseX, double mouseY, boolean released);
    }

}
