package de.keksuccino.fancymenu.customization.element.elements.inputfield;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.variables.VariableHandler;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinAbstractWidget;
import de.keksuccino.fancymenu.util.ListUtils;
import de.keksuccino.fancymenu.util.input.CharacterFilter;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.ExtendedEditBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_332;
import net.minecraft.class_364;

public class InputFieldElement extends AbstractElement {

    public String linkedVariable;
    public InputFieldType type = InputFieldType.TEXT;
    public int maxTextLength = 10000;
    public ExtendedEditBox editBox;
    public String lastValue = "";
    public boolean navigatable = true;

    public InputFieldElement(ElementBuilder<InputFieldElement, InputFieldEditorElement> builder) {
        super(builder);
        this.allowDepthTestManipulation = true;
    }

    @Override
    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {

        if (this.shouldRender()) {

            //Handle editor mode for text field
            if (isEditor()) {
                this.editBox.field_22763 = false;
                this.editBox.method_1888(false);
                if (this.linkedVariable != null) {
                    if (VariableHandler.variableExists(this.linkedVariable)) {
                        String var = Objects.requireNonNull(VariableHandler.getVariable(this.linkedVariable)).getValue();
                        this.editBox.method_1852(var);
                    }
                }
            }

            this.editBox.setNavigatable(this.navigatable);

            this.editBox.method_46421(this.getAbsoluteX());
            this.editBox.method_46419(this.getAbsoluteY());
            this.editBox.method_25358(this.getAbsoluteWidth());
            ((IMixinAbstractWidget)this.editBox).setHeightFancyMenu(this.getAbsoluteHeight());
            this.editBox.method_25394(graphics, mouseX, mouseY, partial);

            //Update variable value on change
            if (!isEditor()) {
                if (this.linkedVariable != null) {
                    if (!this.lastValue.equals(this.editBox.method_1882())) {
                        VariableHandler.setVariable(linkedVariable, this.editBox.method_1882());
                    }
                    if (VariableHandler.variableExists(this.linkedVariable)) {
                        String val = Objects.requireNonNull(VariableHandler.getVariable(this.linkedVariable)).getValue();
                        if (!this.editBox.method_1882().equals(val)) {
                            this.editBox.method_1852(val);
                        }
                    } else {
                        this.editBox.method_1852("");
                    }
                }
                this.lastValue = this.editBox.method_1882();
            }

        }

    }

    @Override
    public @Nullable List<class_364> getWidgetsToRegister() {
        return ListUtils.of(this.editBox);
    }

    public enum InputFieldType {

        INTEGER_ONLY("integer", CharacterFilter.buildIntegerFiler()),
        DECIMAL_ONLY("decimal", CharacterFilter.buildDecimalFiler()),
        URL("url", CharacterFilter.buildUrlFilter()),
        TEXT("text", null);

        final String name;
        final CharacterFilter filter;

        InputFieldType(String name, CharacterFilter filter) {
            this.name = name;
            this.filter = filter;
        }

        public String getName() {
            return this.name;
        }

        public CharacterFilter getFilter() {
            return this.filter;
        }

        public static InputFieldType getByName(String name) {
            for (InputFieldType i : InputFieldType.values()) {
                if (i.getName().equals(name)) {
                    return i;
                }
            }
            return null;
        }

    }

}
