package de.keksuccino.fancymenu.customization.gameintro;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayer;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayerHandler;
import de.keksuccino.fancymenu.events.screen.*;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import de.keksuccino.fancymenu.util.rendering.AspectRatio;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.screen.ScreenRenderUtils;
import de.keksuccino.fancymenu.util.rendering.ui.screen.scrollnormalizer.ScrollScreenNormalizer;
import de.keksuccino.fancymenu.util.resource.PlayableResource;
import de.keksuccino.fancymenu.util.resource.RenderableResource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import java.util.Objects;
import net.minecraft.class_1074;
import net.minecraft.class_10799;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4071;
import net.minecraft.class_437;

public class GameIntroOverlay extends class_4071 {

    private static final Logger LOGGER = LogManager.getLogger();

    protected class_327 font = class_310.method_1551().field_1772;
    @NotNull
    protected class_437 fadeTo;
    protected PlayableResource intro;
    protected float opacity = 1.0F;
    protected long start = -1;
    protected boolean fadeToInitialized = false;
    protected int width;
    protected int height;

    public GameIntroOverlay(@NotNull class_437 fadeTo, @NotNull PlayableResource intro) {
        super();
        this.fadeTo = Objects.requireNonNull(fadeTo);
        this.intro = Objects.requireNonNull(intro);
        this.intro.waitForReady(5000);
    }

    @Override
    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {

        this.width = class_310.method_1551().method_22683().method_4486();
        this.height = class_310.method_1551().method_22683().method_4502();

        //----------------------

        if (this.start == -1) {
            this.start = System.currentTimeMillis();
            this.intro.stop();
            this.intro.play();
        }

        if (this.endOfIntroReached() && !this.fadeToInitialized) {
            this.initFadeToScreen();
        }

        this.tickFadeOut();

        //Close screen after finished playing
        if (this.endOfIntroReached() && (!this.fadeOutIntro() || (this.opacity < 0.1F))) {
            this.close();
            return;
        }

        if (this.endOfIntroReached()) {
            ScreenRenderUtils.executeAllPreRenderTasks(graphics, mouseX, mouseY, partial);
            EventHandler.INSTANCE.postEvent(new RenderScreenEvent.Pre(this.fadeTo, graphics, mouseX, mouseY, partial));
            this.fadeTo.method_25394(graphics, mouseX, mouseY, partial);
            EventHandler.INSTANCE.postEvent(new RenderScreenEvent.Post(this.fadeTo, graphics, mouseX, mouseY, partial));
            ScreenRenderUtils.executeAllPostRenderTasks(graphics, mouseX, mouseY, partial);
        } else {
            graphics.method_25294(0, 0, this.width, this.height, DrawableColor.BLACK.getColorInt());
        }

        this.renderIntro(graphics, mouseX, mouseY, partial);

        this.renderSkipText(graphics, mouseX, mouseY, partial);

    }

    protected void renderIntro(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {

        if (this.intro instanceof RenderableResource r) {

            AspectRatio ratio = r.getAspectRatio();
            int[] size = ratio.getAspectRatioSizeByMinimumSize(this.width, this.height);
            int aspectWidth = size[0];
            int aspectHeight = size[1];
            int x = (this.width / 2) - (aspectWidth / 2);
            int y = (this.height / 2) - (aspectHeight / 2);

            class_2960 location = r.getResourceLocation();
            if (location != null) {
                 
                graphics.method_25291(class_10799.field_56883, location, x, y, 0.0F, 0.0F, aspectWidth, aspectHeight, aspectWidth, aspectHeight, DrawableColor.WHITE.getColorIntWithAlpha(this.opacity));
            }

        }

    }

    protected void renderSkipText(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        if (FancyMenu.getOptions().gameIntroAllowSkip.getValue()) {
            float scale = 1.3F;
            String customSkipText = FancyMenu.getOptions().gameIntroCustomSkipText.getValue();
            if (!customSkipText.isEmpty() && LocalizationUtils.isLocalizationKey(customSkipText)) {
                customSkipText = class_1074.method_4662(customSkipText);
            }
            class_2561 skipComp = customSkipText.isEmpty() ? class_2561.method_43471("fancymenu.game_intro.press_any_key") : class_2561.method_43470(customSkipText);
            graphics.method_51448().pushMatrix();
            graphics.method_51448().scale(scale, scale);
             
            int normalizedWidth = (int)(this.width / scale);
            int normalizedHeight = (int)(this.height / scale);
            int textX = (normalizedWidth / 2) - (this.font.method_27525(skipComp) / 2);
            int textY = normalizedHeight - 40;
            graphics.method_51439(this.font, skipComp, textX, textY, DrawableColor.WHITE.getColorIntWithAlpha(Math.max(0.1F, 0.6F * this.opacity)), false);
            graphics.method_51448().popMatrix();
        }
    }

    protected boolean fadeOutIntro() {
        return FancyMenu.getOptions().gameIntroFadeOut.getValue();
    }

    protected boolean endOfIntroReached() {
        if (this.start == -1) return false;
        long now = System.currentTimeMillis();
        //If not playing (anymore) 2 seconds after starting to play it, consider the playable resource finished
        return ((this.start + 2000) < now) && !this.intro.isPlaying();
    }

    protected void tickFadeOut() {
        if (this.endOfIntroReached() && this.fadeOutIntro()) {
            this.opacity -= 0.02F;
        }
    }

    protected void initFadeToScreen() {

        ScreenCustomization.setIsNewMenu(true);

        ScreenCustomizationLayer layer = ScreenCustomizationLayerHandler.getLayerOfScreen(this.fadeTo);
        if (layer != null) layer.resetLayer();

        EventHandler.INSTANCE.postEvent(new InitOrResizeScreenStartingEvent(this.fadeTo, InitOrResizeScreenEvent.InitializationPhase.INIT));
        EventHandler.INSTANCE.postEvent(new InitOrResizeScreenEvent.Pre(this.fadeTo, InitOrResizeScreenEvent.InitializationPhase.INIT));

        this.fadeTo.method_25423(class_310.method_1551(), class_310.method_1551().method_22683().method_4486(), class_310.method_1551().method_22683().method_4502());

        ScrollScreenNormalizer.normalizeScrollableScreen(this.fadeTo);

        EventHandler.INSTANCE.postEvent(new InitOrResizeScreenEvent.Post(this.fadeTo, InitOrResizeScreenEvent.InitializationPhase.INIT));
        EventHandler.INSTANCE.postEvent(new InitOrResizeScreenCompletedEvent(this.fadeTo, InitOrResizeScreenEvent.InitializationPhase.INIT));

        this.fadeToInitialized = true;

    }

    protected void close() {
        if (!this.fadeToInitialized) this.initFadeToScreen();
        class_310.method_1551().method_18502(null);
    }

    public void keyPressed(class_11908 event) {
        //Handle "Press Any Key to Skip" if enabled
        if (FancyMenu.getOptions().gameIntroAllowSkip.getValue()) {
            this.close();
        }
    }

    public void mouseClicked(class_11909 event, boolean isDoubleClick) {
        //Handle "Press Any Key to Skip" if enabled
        if (FancyMenu.getOptions().gameIntroAllowSkip.getValue()) {
            this.close();
        }
    }

}
