package de.keksuccino.fancymenu.customization.layer;

import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1041;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_6379;
import net.minecraft.class_8089;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.action.blocks.AbstractExecutableBlock;
import de.keksuccino.fancymenu.customization.background.MenuBackground;
import de.keksuccino.fancymenu.customization.screen.identifier.ScreenIdentifierHandler;
import de.keksuccino.fancymenu.events.widget.RenderedGuiListHeaderFooterEvent;
import de.keksuccino.fancymenu.customization.element.elements.button.vanillawidget.VanillaWidgetElement;
import de.keksuccino.fancymenu.customization.layout.Layout;
import de.keksuccino.fancymenu.customization.layout.LayoutBase;
import de.keksuccino.fancymenu.customization.widget.ScreenWidgetDiscoverer;
import de.keksuccino.fancymenu.events.widget.RenderTabNavigationBarHeaderBackgroundEvent;
import de.keksuccino.fancymenu.util.ScreenUtils;
import de.keksuccino.fancymenu.util.TaskExecutor;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import de.keksuccino.fancymenu.util.event.acara.EventPriority;
import de.keksuccino.fancymenu.util.event.acara.EventListener;
import de.keksuccino.fancymenu.events.screen.*;
import de.keksuccino.fancymenu.customization.widget.WidgetMeta;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.layout.LayoutHandler;
import de.keksuccino.fancymenu.events.ModReloadEvent;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementContainer;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinScreen;
import de.keksuccino.fancymenu.util.ScreenTitleUtils;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CustomizableScreen;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import de.keksuccino.fancymenu.util.resource.resources.audio.IAudio;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import de.keksuccino.fancymenu.util.window.WindowHandler;
import de.keksuccino.konkrete.math.MathUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SuppressWarnings({"unused", "deprecation"})
public class ScreenCustomizationLayer implements ElementFactory {

	private static final Logger LOGGER = LogManager.getLogger();

	public static final class_2960 MENU_BACKGROUND = class_2960.method_60654("textures/gui/menu_background.png");
	public static final class_2960 INWORLD_MENU_BACKGROUND = class_2960.method_60654("textures/gui/inworld_menu_background.png");

	protected String screenIdentifier;
	public LayoutBase layoutBase = new LayoutBase();
	@NotNull
	public List<AbstractElement> allElements = new ArrayList<>();
	public Layout.OrderedElementCollection normalElements = new Layout.OrderedElementCollection();
	public List<VanillaWidgetElement> vanillaWidgetElements = new ArrayList<>();
	public Map<String, RandomLayoutContainer> randomLayoutGroups = new HashMap<>();
	public List<Layout> activeLayouts = new ArrayList<>();
	public List<String> delayAppearanceFirstTime = new ArrayList<>();
	public List<ScreenCustomizationLayer.ThreadCaller> delayThreads = new ArrayList<>();
	public boolean backgroundDrawable;
	public boolean forceDisableCustomMenuTitle = false;
	public float backgroundOpacity = 1.0F;
	public Map<LoadingRequirementContainer, Boolean> cachedLayoutWideLoadingRequirements = new HashMap<>();
	@NotNull
	public List<WidgetMeta> cachedScreenWidgetMetas = new ArrayList<>();
	/** The first {@link class_8089} of the target {@link class_437}, if it has one. This is NULL if the {@link class_437} has no {@link class_8089}. **/
	@Nullable
	public class_8089 cachedTabNavigationBar = null;
	public boolean loadEarly = false;

	public static Map<Class<?>, class_2561> cachedOriginalMenuTitles = new HashMap<>();

	public ScreenCustomizationLayer(@NotNull String screenIdentifier) {
		Objects.requireNonNull(screenIdentifier);
		this.screenIdentifier = screenIdentifier;
		EventHandler.INSTANCE.registerListenersOf(this);
	}

	@NotNull
	public String getScreenIdentifier() {
		return this.screenIdentifier;
	}

	public void resetLayer() {
		this.delayAppearanceFirstTime.clear();
		for (RandomLayoutContainer c : this.randomLayoutGroups.values()) {
			c.reset(true);
		}
	}

	@EventListener
	public void onModReload(ModReloadEvent e) {
		RandomLayoutContainer.CACHED_PICKS.clear();
		this.resetLayer();
	}

	@EventListener
	public void onOpenScreen(OpenScreenEvent e) {

		if (!this.shouldCustomize(e.getScreen())) return;

		//Cache original menu title
		if (!cachedOriginalMenuTitles.containsKey(e.getScreen().getClass())) {
			cachedOriginalMenuTitles.put(e.getScreen().getClass(), e.getScreen().method_25440());
		}

	}

	@EventListener
	public void onOpenScreenPostInit(OpenScreenPostInitEvent e) {

		if (!this.shouldCustomize(e.getScreen())) return;

		this.allElements.forEach(AbstractElement::_onOpenScreen);

		this.layoutBase.menuBackgrounds.forEach(MenuBackground::onOpenScreen);

		this.layoutBase.openScreenExecutableBlocks.forEach(AbstractExecutableBlock::execute);

	}

	@EventListener
	public void onCloseScreen(CloseScreenEvent e) {

		if (!this.shouldCustomize(e.getScreen())) return;

		this.allElements.forEach(element -> {
			element.onCloseScreen(e.getClosedScreen(), e.getNewScreen());
			element.onCloseScreen();
			element.onDestroyElement();
		});

		this.layoutBase.menuBackgrounds.forEach(menuBackground -> menuBackground.onCloseScreen(e.getClosedScreen(), e.getNewScreen()));
		this.layoutBase.menuBackgrounds.forEach(MenuBackground::onCloseScreen);

		if (this.layoutBase.closeAudio != null) {
			final ResourceSupplier<IAudio> closeAudioSupplier = this.layoutBase.closeAudio;
			IAudio audio = closeAudioSupplier.get();
			if ((audio != null) && audio.isReady()) {
				audio.stop();
				audio.play();
			} else {
				final AtomicBoolean played = new AtomicBoolean(false);
				TaskExecutor.scheduleAtFixedRate((future) -> {
					if (played.get()) return;
					IAudio audio2 = closeAudioSupplier.get();
					if ((audio2 != null) && audio2.isReady()) {
						audio2.stop();
						audio2.play();
						played.set(true);
						future.cancel(true);
					}
				}, 100, 100, TimeUnit.MILLISECONDS, true);
			}
		}

		this.layoutBase.closeScreenExecutableBlocks.forEach(AbstractExecutableBlock::execute);

	}

	@EventListener
	public void onInitOrResizeScreenPre(InitOrResizeScreenEvent.Pre e) {

		this.cachedTabNavigationBar = null;

		for (ThreadCaller t : this.delayThreads) {
			t.running.set(false);
		}
		this.delayThreads.clear();

		if (!this.shouldCustomize(e.getScreen())) return;

		this.allElements.forEach(element -> {
			//Call onResizeScreen() for all OLD elements BEFORE resizing the screen
			if (e.getInitializationPhase() == InitOrResizeScreenEvent.InitializationPhase.RESIZE) {
				element.onBeforeResizeScreen();
			}
			//Call onDestroyElement() for all OLD elements before resizing the screen, because they get rebuild on resize
			element.onDestroyElement();
		});

		if (e.getInitializationPhase() == InitOrResizeScreenEvent.InitializationPhase.RESIZE) {
			this.layoutBase.menuBackgrounds.forEach(MenuBackground::onBeforeResizeScreen);
		}

		List<MenuBackground> oldMenuBackgrounds = new ArrayList<>(this.layoutBase.menuBackgrounds);

		List<Layout> rawLayouts = LayoutHandler.getEnabledLayoutsForScreenIdentifier(this.getScreenIdentifier(), true);
		List<Layout> normalLayouts = new ArrayList<>();

		this.activeLayouts.clear();
		this.layoutBase = new LayoutBase();
		this.normalElements = new Layout.OrderedElementCollection();
		this.vanillaWidgetElements.clear();
		this.allElements.clear();
		this.backgroundOpacity = 1.0F;
		this.backgroundDrawable = false;
		this.cachedLayoutWideLoadingRequirements.clear();

		for (RandomLayoutContainer c : this.randomLayoutGroups.values()) {
			c.clearLayouts();
		}

		for (Layout layout : rawLayouts) {

			LoadingRequirementContainer layoutWideRequirementContainer = layout.layoutWideLoadingRequirementContainer;
			this.cachedLayoutWideLoadingRequirements.put(layoutWideRequirementContainer, layoutWideRequirementContainer.requirementsMet());
			if (!layoutWideRequirementContainer.requirementsMet()) {
				continue;
			}

			if (layout.randomMode) {
				String group = layout.randomGroup;
				if (!this.randomLayoutGroups.containsKey(group)) {
					this.randomLayoutGroups.put(group, new RandomLayoutContainer(group, this));
				}
				RandomLayoutContainer randomContainer = this.randomLayoutGroups.get(group);
				if (randomContainer != null) {
					randomContainer.addLayout(layout);
				}
			} else {
				normalLayouts.add(layout);
			}

		}

		List<String> trashLayoutGroups = new ArrayList<>();
		for (Map.Entry<String, RandomLayoutContainer> m : this.randomLayoutGroups.entrySet()) {
			if (m.getValue().getLayouts().isEmpty()) {
				trashLayoutGroups.add(m.getKey());
			}
		}
		for (String s : trashLayoutGroups) {
			this.randomLayoutGroups.remove(s);
		}

		this.activeLayouts = new ArrayList<>(normalLayouts);
		this.randomLayoutGroups.values().forEach((container) -> this.activeLayouts.add(container.getRandomLayout()));

		//Sort layouts by its index, so the layout with the smallest index is first in the list
		this.activeLayouts.sort(Comparator.comparingInt(l -> l.layoutIndex));

		//Stack active layouts
		this.layoutBase = LayoutBase.stackLayoutBases(this.activeLayouts.toArray(new LayoutBase[]{}));

        class_1041 window = class_310.method_1551().method_22683();

        //Handle forced GUI scale
        if (this.layoutBase.forcedScale != 0) {
            float newscale = this.layoutBase.forcedScale;
            if (newscale <= 0) {
                newscale = 1;
            }
            WindowHandler.setGuiScale(newscale);
            e.getScreen().field_22789 = window.method_4486();
            e.getScreen().field_22790 = window.method_4502();
        }

        //Handle auto-scaling
        if ((this.layoutBase.autoScalingWidth != 0) && (this.layoutBase.autoScalingHeight != 0) && (this.layoutBase.forcedScale != 0)) {
            double guiWidth = e.getScreen().field_22789 * WindowHandler.getGuiScale();
            double guiHeight = e.getScreen().field_22790 * WindowHandler.getGuiScale();
            double percentX = (guiWidth / (double)this.layoutBase.autoScalingWidth) * 100.0D;
            double percentY = (guiHeight / (double)this.layoutBase.autoScalingHeight) * 100.0D;
            double newScaleX = (percentX / 100.0D) * WindowHandler.getGuiScale();
            double newScaleY = (percentY / 100.0D) * WindowHandler.getGuiScale();
            double newScale = Math.min(newScaleX, newScaleY);
            WindowHandler.setGuiScale(newScale);
            e.getScreen().field_22789 = window.method_4486();
            e.getScreen().field_22790 = window.method_4502();
        }

		oldMenuBackgrounds.forEach(menuBackground -> {
			if (!this.layoutBase.menuBackgrounds.contains(menuBackground)) menuBackground.onDisableOrRemove();
		});

		this.layoutBase.menuBackgrounds.forEach(MenuBackground::onAfterEnable);

	}

	@EventListener
	public void onInitOrResizeScreenPost(InitOrResizeScreenEvent.Post e) {

		this.cachedTabNavigationBar = null;

		if (!this.shouldCustomize(e.getScreen())) return;

		for (class_4068 renderable : e.getRenderables()) {
			if (renderable instanceof class_8089 bar) {
				this.cachedTabNavigationBar = bar;
				break;
			}
		}

		if (ScreenCustomization.isNewMenu() && (this.layoutBase.openAudio != null)) {
			final ResourceSupplier<IAudio> openAudioSupplier = this.layoutBase.openAudio;
			IAudio audio = openAudioSupplier.get();
			if ((audio != null) && audio.isReady()) {
				audio.stop();
				audio.play();
			} else {
				final AtomicBoolean played = new AtomicBoolean(false);
				TaskExecutor.scheduleAtFixedRate((future) -> {
					if (played.get()) return;
					IAudio audio2 = openAudioSupplier.get();
					if ((audio2 != null) && audio2.isReady()) {
						audio2.stop();
						audio2.play();
						played.set(true);
						future.cancel(true);
					}
				}, 100, 100, TimeUnit.MILLISECONDS, true);
			}
		}

		this.cachedScreenWidgetMetas = ScreenWidgetDiscoverer.getWidgetsOfScreen(e.getScreen());

		this.constructElementInstances(this.getScreenIdentifier(), this.cachedScreenWidgetMetas, this.activeLayouts, this.normalElements, this.vanillaWidgetElements);
		this.allElements.addAll(this.normalElements.backgroundElements);
		this.allElements.addAll(this.normalElements.foregroundElements);
		this.allElements.addAll(this.vanillaWidgetElements);

		for (AbstractElement ae : this.allElements) {
			//Add widgets of element to screen
			List<class_364> widgetsToRegister = ae.getWidgetsToRegister();
			if (widgetsToRegister != null) {
				//Element children get always added at pos 0, so reverse the list to preserve the natural widget order
				widgetsToRegister = Lists.reverse(widgetsToRegister);
				for (class_364 w : widgetsToRegister) {
					if ((w instanceof class_6379) && !((IMixinScreen)e.getScreen()).getChildrenFancyMenu().contains(w)) {
						((IMixinScreen)e.getScreen()).getChildrenFancyMenu().addFirst(w);
						if (e.getScreen() instanceof CustomizableScreen c) c.removeOnInitChildrenFancyMenu().add(w);
					}
				}
			}
			//Update vanilla widgets before render, so they don't get rendered uncustomized for one tick
			if (ae instanceof VanillaWidgetElement v) {
				v.updateWidget();
			}
		}

		//Add all elements to the screen's widget list
		for (AbstractElement ae : Lists.reverse(this.allElements)) {
			((IMixinScreen)e.getScreen()).getChildrenFancyMenu().addFirst(ae);
			if (e.getScreen() instanceof CustomizableScreen c) c.removeOnInitChildrenFancyMenu().add(ae);
		}

		//Add menu background to screen's widget list
		this.layoutBase.menuBackgrounds.forEach(menuBackground -> {
			((IMixinScreen)e.getScreen()).getChildrenFancyMenu().addFirst(menuBackground);
			if (e.getScreen() instanceof CustomizableScreen c) c.removeOnInitChildrenFancyMenu().add(menuBackground);
		});

		if (e.getInitializationPhase() == InitOrResizeScreenEvent.InitializationPhase.RESIZE) {
			this.layoutBase.menuBackgrounds.forEach(MenuBackground::onAfterResizeScreen);
		}

	}

	@EventListener
	public void onScreenTickPre(ScreenTickEvent.Post e) {

		if (!this.shouldCustomize(e.getScreen())) return;

		this.layoutBase.menuBackgrounds.forEach(MenuBackground::tick);

		for (AbstractElement element : this.allElements) {
			element.tick();
		}

	}

	@EventListener(priority = EventPriority.VERY_HIGH)
	public void onRenderPre(RenderScreenEvent.Pre e) {

		if (!this.shouldCustomize(e.getScreen())) return;

		//Re-init screen if layout-wide loading requirements changed
		for (Map.Entry<LoadingRequirementContainer, Boolean> m : this.cachedLayoutWideLoadingRequirements.entrySet()) {
			if (m.getKey().requirementsMet() != m.getValue()) {
				ScreenCustomization.reInitCurrentScreen();
				break;
			}
		}

		//Set custom menu title
		if ((this.layoutBase.customMenuTitle != null) && !this.forceDisableCustomMenuTitle) {
			ScreenTitleUtils.setScreenTitle(e.getScreen(), class_2561.method_43470(PlaceholderParser.replacePlaceholders(this.layoutBase.customMenuTitle)));
		}

		//Render vanilla button elements (render in pre, because Vanilla Widget elements don't actually render the widget, they just manage it, so it's important to call their render logic before everything else)
		for (AbstractElement element : new ArrayList<>(this.vanillaWidgetElements)) {
			element.renderInternal(e.getGraphics(), e.getMouseX(), e.getMouseY(), e.getPartial());
		}

	}

	@EventListener
	public void onRenderPost(RenderScreenEvent.Post e) {

		if (!this.shouldCustomize(e.getScreen())) return;

		//Render background elements in foreground if it wasn't possible to render to the menu background
		if (!this.backgroundDrawable) {
			for (AbstractElement element : new ArrayList<>(this.normalElements.backgroundElements)) {
				element.renderInternal(e.getGraphics(), e.getMouseX(), e.getMouseY(), e.getPartial());
			}
		}
		//Render foreground elements
		for (AbstractElement element : new ArrayList<>(this.normalElements.foregroundElements)) {
			element.renderInternal(e.getGraphics(), e.getMouseX(), e.getMouseY(), e.getPartial());
		}

	}

	@EventListener
	public void drawToBackground(RenderedScreenBackgroundEvent e) {
		this.renderBackground(e.getGraphics(), e.getMouseX(), e.getMouseY(), e.getPartial(), e.getScreen());
	}

	@EventListener
	public void onRenderListHeaderFooterPre(RenderedGuiListHeaderFooterEvent e) {

		class_332 graphics = e.getGraphics();

		if (this.shouldCustomize(class_310.method_1551().field_1755)) {

			class_350<?> list = e.getList();

			ITexture headerTexture = (this.layoutBase.scrollListHeaderTexture != null) ? this.layoutBase.scrollListHeaderTexture.get() : null;
			ITexture footerTexture = (this.layoutBase.scrollListFooterTexture != null) ? this.layoutBase.scrollListFooterTexture.get() : null;

			boolean canRenderCustom = (headerTexture != null) || (footerTexture != null) || !this.layoutBase.renderScrollListHeaderShadow || !this.layoutBase.renderScrollListFooterShadow;
			if (!canRenderCustom) return;

			if (headerTexture != null) {
				class_2960 loc = headerTexture.getResourceLocation();
				if (loc != null) {
					if (this.layoutBase.preserveScrollListHeaderFooterAspectRatio) {
						int[] headerSize = headerTexture.getAspectRatio().getAspectRatioSizeByMinimumSize(list.method_25368(), list.method_46427());
						int headerWidth = headerSize[0];
						int headerHeight = headerSize[1];
						int headerX = list.method_46426() + (list.method_25368() / 2) - (headerWidth / 2);
						int headerY = (list.method_46427() / 2) - (headerHeight / 2);
						graphics.method_44379(list.method_46426(), 0, list.method_55442(), list.method_46427());
						graphics.method_25290(class_10799.field_56883, loc, headerX, headerY, 0.0F, 0.0F, headerWidth, headerHeight, headerWidth, headerHeight);
						graphics.method_44380();
					} else if (this.layoutBase.repeatScrollListHeaderTexture) {
						RenderingUtils.blitRepeat(graphics, loc, list.method_46426(), 0, list.method_25368(), list.method_46427(), headerTexture.getWidth(), headerTexture.getHeight(), -1);
					} else {
						graphics.method_25290(class_10799.field_56883, loc, list.method_46426(), 0, 0.0F, 0.0F, list.method_25368(), list.method_46427(), list.method_25368(), list.method_46427());
					}
				}
			}

			if (footerTexture != null) {
				class_2960 loc = footerTexture.getResourceLocation();
				if (loc != null) {
					if (this.layoutBase.preserveScrollListHeaderFooterAspectRatio) {
						int footerOriginalHeight = ScreenUtils.getScreenHeight() - list.method_55443();
						if (footerOriginalHeight <= 0) footerOriginalHeight = 1;
						int[] footerSize = footerTexture.getAspectRatio().getAspectRatioSizeByMinimumSize(list.method_25368(), footerOriginalHeight);
						int footerWidth = footerSize[0];
						int footerHeight = footerSize[1];
						int footerX = list.method_46426() + (list.method_25368() / 2) - (footerWidth / 2);
						int footerY = list.method_55443() + (footerOriginalHeight / 2) - (footerHeight / 2);
						graphics.method_44379(list.method_46426(), list.method_55443(), list.method_55442(), list.method_55443() + footerOriginalHeight);
						graphics.method_25290(class_10799.field_56883, loc, footerX, footerY, 0.0F, 0.0F, footerWidth, footerHeight, footerWidth, footerHeight);
						graphics.method_44380();
					} else if (this.layoutBase.repeatScrollListFooterTexture) {
						int footerHeight = ScreenUtils.getScreenHeight() - list.method_55443();
						if (footerHeight <= 0) footerHeight = 1;
						RenderingUtils.blitRepeat(graphics, loc, list.method_46426(), list.method_55443(), list.method_25368(), footerHeight, footerTexture.getWidth(), footerTexture.getHeight(), -1);
					} else {
						int footerHeight = ScreenUtils.getScreenHeight() - list.method_55443();
						if (footerHeight <= 0) footerHeight = 1;
						graphics.method_25290(class_10799.field_56883, loc, list.method_46426(), list.method_55443(), 0.0F, 0.0F, list.method_25368(), footerHeight, list.method_25368(), footerHeight);
					}
				}
			}

		}

	}

	@EventListener
	public void onRenderTabNavigationBarHeaderBackgroundPre(RenderTabNavigationBarHeaderBackgroundEvent.Pre e) {

		class_332 graphics = e.getGraphics();

		if (this.shouldCustomize(class_310.method_1551().field_1755)) {

			ITexture headerTexture = (this.layoutBase.scrollListHeaderTexture != null) ? this.layoutBase.scrollListHeaderTexture.get() : null;

			if (headerTexture != null) {
				class_2960 loc = headerTexture.getResourceLocation();
				if (loc != null) {
					e.setCanceled(true);
					if (this.layoutBase.preserveScrollListHeaderFooterAspectRatio) {
						int[] headerSize = headerTexture.getAspectRatio().getAspectRatioSizeByMinimumSize(e.getHeaderWidth(), e.getHeaderHeight());
						int headerWidth = headerSize[0];
						int headerHeight = headerSize[1];
						int headerX = (e.getHeaderWidth() / 2) - (headerWidth / 2);
						int headerY = (e.getHeaderHeight() / 2) - (headerHeight / 2);
						graphics.method_44379(0, 0, e.getHeaderWidth(), e.getHeaderHeight());
						graphics.method_25290(class_10799.field_56883, loc, headerX, headerY, 0.0F, 0.0F, headerWidth, headerHeight, headerWidth, headerHeight);
						graphics.method_44380();
					} else if (this.layoutBase.repeatScrollListHeaderTexture) {
						RenderingUtils.blitRepeat(graphics, loc, 0, 0, e.getHeaderWidth(), e.getHeaderHeight(), headerTexture.getWidth(), headerTexture.getHeight(), -1);
					} else {
						graphics.method_25290(class_10799.field_56883, loc, 0, 0, 0.0F, 0.0F, e.getHeaderWidth(), e.getHeaderHeight(), e.getHeaderWidth(), e.getHeaderHeight());
					}
				}
			}

		}

	}

	protected void renderBackground(class_332 graphics, int mouseX, int mouseY, float partial, class_437 screen) {

		if (!this.shouldCustomize(screen)) return;

		this.layoutBase.menuBackgrounds.forEach(menuBackground -> {

			menuBackground.keepBackgroundAspectRatio = this.layoutBase.preserveBackgroundAspectRatio;
			menuBackground.opacity = this.backgroundOpacity;
			menuBackground.method_25394(graphics, mouseX, mouseY, partial);
			menuBackground.opacity = 1.0F;

		});

		if (!this.layoutBase.menuBackgrounds.isEmpty()) {

			if (this.layoutBase.applyVanillaBackgroundBlur) {
				class_310.method_1551().field_1773.method_57796();
			}

			if (this.layoutBase.showScreenBackgroundOverlayOnCustomBackground) {
				int overlayY = 0;
				if (this.cachedTabNavigationBar != null) overlayY = this.cachedTabNavigationBar.method_48202().method_49619();
				this._renderBackgroundOverlay(graphics, 0, overlayY, screen.field_22789, screen.field_22790);
			}

		}

		//Render background elements
		for (AbstractElement elements : new ArrayList<>(this.normalElements.backgroundElements)) {
			elements.renderInternal(graphics, mouseX, mouseY, partial);
		}

		this.backgroundDrawable = true;

	}

	protected void _renderBackgroundOverlay(class_332 graphics, int x, int y, int width, int height) {
		renderBackgroundOverlay(graphics, x, y, width, height);
	}

	public static void renderBackgroundOverlay(class_332 graphics, int x, int y, int width, int height) {
		class_2960 location = (class_310.method_1551().field_1687 == null) ? MENU_BACKGROUND : INWORLD_MENU_BACKGROUND;
		graphics.method_25291(class_10799.field_56883, location, x, y, 0, 0.0F, 0, width, height, 32, 32);
	}

	@Nullable
	public AbstractElement getElementByInstanceIdentifier(String instanceIdentifier) {
		instanceIdentifier = instanceIdentifier.replace("vanillabtn:", "").replace("button_compatibility_id:", "");
		for (AbstractElement element : this.allElements) {
			if (element.getInstanceIdentifier().equals(instanceIdentifier)) {
				return element;
			}
		}
		return null;
	}

	@Nullable
	public MenuBackground getMenuBackgroundByInstanceIdentifier(@NotNull String identifier) {
		for (MenuBackground b : this.layoutBase.menuBackgrounds) {
			if (b.getInstanceIdentifier().equals(identifier)) return b;
		}
		return null;
	}

	@SuppressWarnings("all")
	protected boolean shouldCustomize(@Nullable class_437 screen) {
		if (screen == null) return false;
		if (ScreenCustomizationLayerHandler.isBeforeFinishInitialMinecraftReload() && !this.loadEarly) return false;
		if (!ScreenIdentifierHandler.isIdentifierOfScreen(this.getScreenIdentifier(), screen)) return false;
		if (!ScreenCustomization.isCustomizationEnabledForScreen(screen)) return false;
		return true;
	}

	public static class ThreadCaller {
		AtomicBoolean running = new AtomicBoolean(true);
	}

	public static class RandomLayoutContainer {

		public static final Map<String, String> CACHED_PICKS = new HashMap<>();
		
		public final String id;
		protected List<Layout> layouts = new ArrayList<>();
		@Nullable
		protected String cachedGroupIdentifier = null;
		
		public ScreenCustomizationLayer parent;
		
		public RandomLayoutContainer(String id, ScreenCustomizationLayer parent) {
			this.id = id;
			this.parent = parent;
		}
		
		public List<Layout> getLayouts() {
			return this.layouts;
		}
		
		public void addLayout(Layout layout) {
			this.layouts.add(layout);
		}
		
		public void addLayouts(List<Layout> layouts) {
			this.layouts.addAll(layouts);
		}
		
		public void clearLayouts() {
			this.layouts.clear();
		}

		public boolean isOnlyFirstTime() {
			for (Layout l : this.layouts) {
				if (l.randomOnlyFirstTime) return true;
			}
			return false;
		}

		public boolean isUniversalGroup() {
			if (this.layouts.isEmpty()) return false;
			for (Layout l : this.layouts) {
				if (!l.isUniversalLayout()) return false;
			}
			return true;
		}

		public String getGroupIdentifier() {
			if (this.cachedGroupIdentifier != null) return this.cachedGroupIdentifier;
			if (this.layouts.isEmpty()) {
				this.cachedGroupIdentifier = ScreenCustomization.generateUniqueIdentifier();
			} else {
				List<String> layoutIds = new ArrayList<>();
				for (Layout l : this.layouts) {
					layoutIds.add(l.runtimeLayoutIdentifier);
				}
				layoutIds.sort(Comparator.naturalOrder());
				StringBuilder id = new StringBuilder();
				for (String s : layoutIds) {
					id.append(s);
				}
				this.cachedGroupIdentifier = id.toString();
			}
			return this.cachedGroupIdentifier;
		}
		
		@Nullable
		public Layout getRandomLayout() {

			if (!this.layouts.isEmpty()) {

				String cachedPickedLayoutIdentifier = CACHED_PICKS.get(this.getGroupIdentifier());

				// Reset cache when it's a new screen
				if (!this.isOnlyFirstTime() && ScreenCustomization.isNewMenu()) {
					cachedPickedLayoutIdentifier = null;
				}

				// Return cached layout if there is one and it's still valid
				if (cachedPickedLayoutIdentifier != null) {
					if (LayoutHandler.isLayoutLoaded(cachedPickedLayoutIdentifier)) {
						for (Layout layout : this.layouts) {
							if (layout.runtimeLayoutIdentifier.equals(cachedPickedLayoutIdentifier)) return layout;
						}
					} else {
						this.reset(true);
					}
				}

				// Resetting the group could cause it to not have any layouts anymore, so check again just to be sure
				if (this.layouts.isEmpty()) return null;

				// Pick a random layout from the group, cache it and then return it
				int i = MathUtils.getRandomNumberInRange(0, this.layouts.size()-1);
				Layout layout = this.layouts.get(i);
				CACHED_PICKS.put(this.getGroupIdentifier(), layout.runtimeLayoutIdentifier);
				return layout;

			}

			return null;

		}

		public void garbageCollectInvalidLayouts() {
			this.layouts.removeIf(layout -> !LayoutHandler.isLayoutLoaded(layout.runtimeLayoutIdentifier));
		}

		public void reset(boolean keepValidLayouts) {
			CACHED_PICKS.remove(this.getGroupIdentifier());
			this.garbageCollectInvalidLayouts();
			this.cachedGroupIdentifier = null;
			if (!keepValidLayouts) this.layouts.clear();
		}

	}

}
