package de.keksuccino.fancymenu.customization.layout.editor;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.background.MenuBackground;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.HideableElement;
import de.keksuccino.fancymenu.customization.element.SerializedElement;
import de.keksuccino.fancymenu.customization.element.editor.AbstractEditorElement;
import de.keksuccino.fancymenu.customization.element.elements.button.vanillawidget.VanillaWidgetEditorElement;
import de.keksuccino.fancymenu.customization.element.elements.button.vanillawidget.VanillaWidgetElement;
import de.keksuccino.fancymenu.customization.element.elements.button.vanillawidget.VanillaWidgetElementBuilder;
import de.keksuccino.fancymenu.customization.layer.ElementFactory;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayer;
import de.keksuccino.fancymenu.customization.layout.Layout;
import de.keksuccino.fancymenu.customization.layout.LayoutHandler;
import de.keksuccino.fancymenu.customization.layout.editor.buddy.BuddyWidget;
import de.keksuccino.fancymenu.customization.layout.editor.widget.AbstractLayoutEditorWidget;
import de.keksuccino.fancymenu.customization.layout.editor.widget.LayoutEditorWidgetRegistry;
import de.keksuccino.fancymenu.customization.screen.identifier.ScreenIdentifierHandler;
import de.keksuccino.fancymenu.customization.widget.ScreenWidgetDiscoverer;
import de.keksuccino.fancymenu.customization.widget.WidgetMeta;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinScreen;
import de.keksuccino.fancymenu.util.ListUtils;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.ObjectUtils;
import de.keksuccino.fancymenu.util.ScreenTitleUtils;
import de.keksuccino.fancymenu.util.file.FileUtils;
import de.keksuccino.fancymenu.util.file.type.groups.FileTypeGroup;
import de.keksuccino.fancymenu.util.file.type.types.FileTypes;
import de.keksuccino.fancymenu.util.input.CharacterFilter;
import de.keksuccino.fancymenu.util.input.InputConstants;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.contextmenu.v2.ContextMenu;
import de.keksuccino.fancymenu.util.rendering.ui.menubar.v2.MenuBar;
import de.keksuccino.fancymenu.util.rendering.ui.screen.NotificationScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.filebrowser.SaveFileScreen;
import de.keksuccino.fancymenu.util.rendering.ui.widget.CustomizableWidget;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import de.keksuccino.fancymenu.util.window.WindowHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import java.util.*;
import net.minecraft.class_1041;
import net.minecraft.class_10799;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_424;
import net.minecraft.class_437;
import net.minecraft.class_9848;

@SuppressWarnings("all")
public class LayoutEditorScreen extends class_437 implements ElementFactory {

	private static final Logger LOGGER = LogManager.getLogger();

	public static final boolean FORCE_DISABLE_BUDDY = true;

	protected static final Map<SerializedElement, ElementBuilder<?,?>> COPIED_ELEMENTS_CLIPBOARD = new LinkedHashMap<>();
	public static final int ELEMENT_DRAG_CRUMPLE_ZONE = 5;

	@Nullable
	protected static LayoutEditorScreen currentInstance = null;

	@Nullable
	public class_437 layoutTargetScreen;
	@NotNull
	public Layout layout;
	public List<AbstractEditorElement> normalEditorElements = new ArrayList<>();
	public List<VanillaWidgetEditorElement> vanillaWidgetEditorElements = new ArrayList<>();
	public LayoutEditorHistory history = new LayoutEditorHistory(this);
	public MenuBar menuBar;
	public AnchorPointOverlay anchorPointOverlay = new AnchorPointOverlay(this);
	public ContextMenu rightClickMenu;
	public ContextMenu activeElementContextMenu = null;
	public List<AbstractLayoutEditorWidget> layoutEditorWidgets = new ArrayList<>();
	protected boolean isMouseSelection = false;
	protected int mouseSelectionStartX = 0;
	protected int mouseSelectionStartY = 0;
	public int leftMouseDownPosX = 0;
	public int leftMouseDownPosY = 0;
	protected boolean elementMovingStarted = false;
	protected boolean elementResizingStarted = false;
	protected boolean mouseDraggingStarted = false;
	protected List<AbstractEditorElement> currentlyDraggedElements = new ArrayList<>();
	protected int rightClickMenuOpenPosX = -1000;
	protected int rightClickMenuOpenPosY = -1000;
	protected LayoutEditorHistory.Snapshot preDragElementSnapshot;
	public final List<WidgetMeta> cachedVanillaWidgetMetas = new ArrayList<>();
	public boolean unsavedChanges = false;
	protected final BuddyWidget buddyWidget = new BuddyWidget(0, 0);
	public boolean justOpened = true;

	public LayoutEditorScreen(@NotNull Layout layout) {
		this(null, layout);
	}

	public LayoutEditorScreen(@Nullable class_437 layoutTargetScreen, @NotNull Layout layout) {

		super(class_2561.method_43470(""));

		this.layoutTargetScreen = layoutTargetScreen;
		layout.updateLastEditedTime();
		layout.saveToFileIfPossible();
		this.layout = layout.copy();

		if (this.layoutTargetScreen != null) {
			class_2561 cachedOriTitle = ScreenCustomizationLayer.cachedOriginalMenuTitles.get(this.layoutTargetScreen.getClass());
			if (cachedOriTitle != null) {
				ScreenTitleUtils.setScreenTitle(this.layoutTargetScreen, cachedOriTitle);
			}
		}

		//Load all element instances before init, so the layout instance elements don't get wiped when updating it
		this.constructElementInstances();

		this.getAllElements().forEach(element -> {
			element.element._onOpenScreen();
		});

	}

	@Override
	protected void method_25426() {

		this.currentlyDraggedElements.clear();

		this.anchorPointOverlay.resetOverlay();

		for (WidgetMeta m : this.cachedVanillaWidgetMetas) {
			if (m.getWidget() instanceof CustomizableWidget w) {
				w.resetWidgetCustomizationsFancyMenu();
			}
		}

		//Build widget instances only once (don't build in constructor to avoid stack overflows in builders)
		if ((this.layoutEditorWidgets == null) || this.layoutEditorWidgets.isEmpty()) {
			this.layoutEditorWidgets = LayoutEditorWidgetRegistry.buildWidgetInstances(this);
		}

		this.closeRightClickMenu();
		this.rightClickMenu = LayoutEditorUI.buildRightClickContextMenu(this);
		this.method_25429(this.rightClickMenu);

		if (this.menuBar != null) {
			this.menuBar.closeAllContextMenus();
		}
		this.menuBar = LayoutEditorUI.buildMenuBar(this, (this.menuBar == null) || this.menuBar.isExpanded());
		this.method_25429(this.menuBar);

		for (AbstractLayoutEditorWidget w : Lists.reverse(new ArrayList<>(this.layoutEditorWidgets))) {
			this.method_25429(w);
		}

		this.isMouseSelection = false;
		this.preDragElementSnapshot = null;

		this.closeActiveElementMenu(true);

		this.serializeElementInstancesToLayoutInstance();

        //Handle forced GUI scale
        if (this.layout.forcedScale != 0) {
            float newscale = this.layout.forcedScale;
            if (newscale <= 0) {
                newscale = 1;
            }
            class_1041 m = class_310.method_1551().method_22683();
            WindowHandler.setGuiScale(newscale);
            this.field_22789 = m.method_4486();
            this.field_22790 = m.method_4502();
        }

        //Handle auto-scaling
        if ((this.layout.autoScalingWidth != 0) && (this.layout.autoScalingHeight != 0)) {
            class_1041 m = class_310.method_1551().method_22683();
            double guiWidth = this.field_22789 * WindowHandler.getGuiScale();
            double guiHeight = this.field_22790 * WindowHandler.getGuiScale();
            double percentX = (guiWidth / (double)this.layout.autoScalingWidth) * 100.0D;
            double percentY = (guiHeight / (double)this.layout.autoScalingHeight) * 100.0D;
            double newScaleX = (percentX / 100.0D) * WindowHandler.getGuiScale();
            double newScaleY = (percentY / 100.0D) * WindowHandler.getGuiScale();
            double newScale = Math.min(newScaleX, newScaleY);
            WindowHandler.setGuiScale(newScale);
            this.field_22789 = m.method_4486();
            this.field_22790 = m.method_4502();
        }

		this.getAllElements().forEach(element -> {
			if (!this.justOpened) element.element.onBeforeResizeScreen();
			element.element.onDestroyElement();
		});

		if (this.justOpened) this.layout.menuBackgrounds.forEach(MenuBackground::onOpenScreen);

		if (!this.justOpened) this.layout.menuBackgrounds.forEach(MenuBackground::onBeforeResizeScreen);

		this.constructElementInstances();

		if (!this.justOpened) this.layout.menuBackgrounds.forEach(MenuBackground::onAfterResizeScreen);

		this.layout.menuBackgrounds.forEach(MenuBackground::onAfterEnable);

		for (AbstractLayoutEditorWidget w : this.layoutEditorWidgets) {
			w.refresh();
		}

		if (FancyMenu.getOptions().enableBuddy.getValue() && !FORCE_DISABLE_BUDDY) {
			this.method_25429(this.buddyWidget);
			this.buddyWidget.setScreenSize(this.field_22789, this.field_22790);
		}

		this.justOpened = false;

	}

	@Override
	public boolean method_25422() {
		return false;
	}

	@Override
	public void method_25393() {

		if (FancyMenu.getOptions().enableBuddy.getValue() && !FORCE_DISABLE_BUDDY) {
			this.buddyWidget.tick();
		}

		for (AbstractLayoutEditorWidget w : this.layoutEditorWidgets) {
			w.tick();
		}

		for (AbstractEditorElement e : this.getAllElements()) {
			e.element.tick();
		}

		this.layout.menuBackgrounds.forEach(MenuBackground::tick);

	}

	@Override
	public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {

		//Clear active element context menu if not open
		if ((this.activeElementContextMenu != null) && !this.activeElementContextMenu.isOpen()) {
			this.activeElementContextMenu = null;
		}

		this.method_25420(graphics, mouseX, mouseY, partial);

		this.renderElements(graphics, mouseX, mouseY, partial);

		this.renderMouseSelectionRectangle(graphics, mouseX, mouseY);

		this.anchorPointOverlay.method_25394(graphics, mouseX, mouseY, partial);

		this.renderLayoutEditorWidgets(graphics, mouseX, mouseY, partial);

		if (FancyMenu.getOptions().enableBuddy.getValue() && !FORCE_DISABLE_BUDDY) {
			this.buddyWidget.method_25394(graphics, mouseX, mouseY, partial);
		}

		this.menuBar.method_25394(graphics, mouseX, mouseY, partial);

		this.rightClickMenu.method_25394(graphics, mouseX, mouseY, partial);

		//Render active element context menu
		if (this.activeElementContextMenu != null) {
			this.activeElementContextMenu.method_25394(graphics, mouseX, mouseY, partial);
		}

	}

	protected void renderLayoutEditorWidgets(class_332 graphics, int mouseX, int mouseY, float partial) {
		for (AbstractLayoutEditorWidget w : this.layoutEditorWidgets) {
			if (w.isVisible()) w.method_25394(graphics, mouseX, mouseY, partial);
		}
	}

	protected void renderMouseSelectionRectangle(class_332 graphics, int mouseX, int mouseY) {
		if (this.isMouseSelection) {
			int startX = Math.min(this.mouseSelectionStartX, mouseX);
			int startY = Math.min(this.mouseSelectionStartY, mouseY);
			int endX = Math.max(this.mouseSelectionStartX, mouseX);
			int endY = Math.max(this.mouseSelectionStartY, mouseY);
			graphics.method_25294(startX, startY, endX, endY, RenderingUtils.replaceAlphaInColor(UIBase.getUIColorTheme().layout_editor_mouse_selection_rectangle_color.getColorInt(), 70));
			UIBase.renderBorder(graphics, startX, startY, endX, endY, 1, UIBase.getUIColorTheme().layout_editor_mouse_selection_rectangle_color.getColor(), true, true, true, true);
		}
	}

	protected void renderElements(class_332 graphics, int mouseX, int mouseY, float partial) {

		//Render normal elements behind vanilla if renderBehindVanilla
		if (this.layout.renderElementsBehindVanilla) {
			for (AbstractEditorElement e : new ArrayList<>(this.normalEditorElements)) {
				if (!e.isSelected()) e.method_25394(graphics, mouseX, mouseY, partial);
			}
		}
		//Render vanilla button elements
		for (VanillaWidgetEditorElement e : new ArrayList<>(this.vanillaWidgetEditorElements)) {
			if (!e.isSelected() && !e.isHidden()) e.method_25394(graphics, mouseX, mouseY, partial);
		}
		//Render normal elements before vanilla if NOT renderBehindVanilla
		if (!this.layout.renderElementsBehindVanilla) {
			for (AbstractEditorElement e : new ArrayList<>(this.normalEditorElements)) {
				if (!e.isSelected()) e.method_25394(graphics, mouseX, mouseY, partial);
			}
		}

		//Render selected elements last, so they're always visible
		List<AbstractEditorElement> selected = this.getSelectedElements();
		for (AbstractEditorElement e : selected) {
			e.method_25394(graphics, mouseX, mouseY, partial);
		}

	}

	@Override
	public void method_25420(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {

		graphics.method_25294(0, 0, this.field_22789, this.field_22790, UIBase.getUIColorTheme().screen_background_color_darker.getColorInt());

		this.layout.menuBackgrounds.forEach(menuBackground -> {

			menuBackground.keepBackgroundAspectRatio = this.layout.preserveBackgroundAspectRatio;
			menuBackground.opacity = 1.0F;
			menuBackground.method_25394(graphics, mouseX, mouseY, partial);

		});

		if (!this.layout.menuBackgrounds.isEmpty()) {

			if (this.layout.applyVanillaBackgroundBlur) {
				class_310.method_1551().field_1773.method_57796();
			}

			if (this.layout.showScreenBackgroundOverlayOnCustomBackground) {
				ScreenCustomizationLayer.renderBackgroundOverlay(graphics, 0, 0, this.field_22789, this.field_22790);
			}

		}

		this.renderScrollListHeaderFooterPreview(graphics, mouseX, mouseY, partial);

		renderGrid(graphics, this.field_22789, this.field_22790);

	}

	@SuppressWarnings("unused")
	protected void renderScrollListHeaderFooterPreview(class_332 graphics, int mouseX, int mouseY, float partial) {

		if (this.layout.showScrollListHeaderFooterPreviewInEditor) {

			int x0 = 0;
			int x1 = this.field_22789;
			int y0 = 48;
			int y1 = this.field_22790 - 64;

			ITexture headerTexture = (this.layout.scrollListHeaderTexture != null) ? this.layout.scrollListHeaderTexture.get() : null;
			ITexture footerTexture = (this.layout.scrollListFooterTexture != null) ? this.layout.scrollListFooterTexture.get() : null;

			//Header Texture
			if (headerTexture != null) {
				class_2960 loc = headerTexture.getResourceLocation();
				if (loc != null) {
					if (this.layout.preserveScrollListHeaderFooterAspectRatio) {
						int[] headerSize = headerTexture.getAspectRatio().getAspectRatioSizeByMinimumSize(this.field_22789, y0);
						int headerWidth = headerSize[0];
						int headerHeight = headerSize[1];
						int headerX = x0 + (this.field_22789 / 2) - (headerWidth / 2);
						int headerY = (y0 / 2) - (headerHeight / 2);
						graphics.method_44379(x0, 0, x0 + this.field_22789, y0);
						graphics.method_25290(class_10799.field_56883, loc, headerX, headerY, 0.0F, 0.0F, headerWidth, headerHeight, headerWidth, headerHeight);
						graphics.method_44380();
					} else if (this.layout.repeatScrollListHeaderTexture) {
						RenderingUtils.blitRepeat(graphics, loc, x0, 0, this.field_22789, y0, headerTexture.getWidth(), headerTexture.getHeight(), class_9848.method_61318(1.0F, 1.0F, 1.0F, 1.0F));
					} else {
						graphics.method_25291(class_10799.field_56883, loc, x0, 0, 0.0F, 0.0F, this.field_22789, y0, this.field_22789, y0, class_9848.method_61318(1.0F, 1.0F, 1.0F, 1.0F));
					}
				}
			}
			//Footer Texture
			if (footerTexture != null) {
				class_2960 loc = footerTexture.getResourceLocation();
				if (loc != null) {
					if (this.layout.preserveScrollListHeaderFooterAspectRatio) {
						int footerOriginalHeight = this.field_22790 - y1;
						int[] footerSize = footerTexture.getAspectRatio().getAspectRatioSizeByMinimumSize(this.field_22789, footerOriginalHeight);
						int footerWidth = footerSize[0];
						int footerHeight = footerSize[1];
						int footerX = x0 + (this.field_22789 / 2) - (footerWidth / 2);
						int footerY = y1 + (footerOriginalHeight / 2) - (footerHeight / 2);
						graphics.method_44379(x0, y1, x0 + this.field_22789, y1 + footerOriginalHeight);
						graphics.method_25290(class_10799.field_56883, loc, footerX, footerY, 0.0F, 0.0F, footerWidth, footerHeight, footerWidth, footerHeight);
						graphics.method_44380();
					} else if (this.layout.repeatScrollListFooterTexture) {
						int footerHeight = this.field_22790 - y1;
						RenderingUtils.blitRepeat(graphics, loc, x0, y1, this.field_22789, footerHeight, footerTexture.getWidth(), footerTexture.getHeight(), class_9848.method_61318(1.0F, 1.0F, 1.0F, 1.0F));
					} else {
						int footerHeight = this.field_22790 - y1;
						graphics.method_25290(class_10799.field_56883, loc, x0, y1, 0.0F, 0.0F, this.field_22789, footerHeight, this.field_22789, footerHeight);
					}
				}
			}

			graphics.method_25290(class_10799.field_56883, class_437.field_49895, 0, y0 - 2, 0.0F, 0.0F, this.field_22789, 2, 32, 2);
			graphics.method_25290(class_10799.field_56883, class_437.field_49896, 0, y1, 0.0F, 0.0F, this.field_22789, 2, 32, 2);

		}

	}

	@SuppressWarnings("all")
	public static void renderGrid(@NotNull class_332 graphics, int screenWidth, int screenHeight) {

		if (FancyMenu.getOptions().showLayoutEditorGrid.getValue()) {

			float scale = UIBase.calculateFixedScale(1.0F);
			int scaledWidth = (int)((float)screenWidth / scale);
			int scaledHeight = (int)((float)screenHeight / scale);

			graphics.method_51448().pushMatrix();
			graphics.method_51448().scale(scale, scale);

			int gridSize = FancyMenu.getOptions().layoutEditorGridSize.getValue();
			int lineThickness = 1;

			//Draw centered vertical line
			graphics.method_25294((scaledWidth / 2) - 1, 0, (scaledWidth / 2) + 1, scaledHeight, UIBase.getUIColorTheme().layout_editor_grid_color_center.getColorInt());

			//Draw vertical lines center -> left
			int linesVerticalToLeftPosX = (scaledWidth / 2) - gridSize - 1;
			while (linesVerticalToLeftPosX > 0) {
				int minY = 0;
				int maxY = scaledHeight;
				int maxX = linesVerticalToLeftPosX + lineThickness;
				graphics.method_25294(linesVerticalToLeftPosX, minY, maxX, maxY, UIBase.getUIColorTheme().layout_editor_grid_color_normal.getColorInt());
				linesVerticalToLeftPosX -= gridSize;
			}

			//Draw vertical lines center -> right
			int linesVerticalToRightPosX = (scaledWidth / 2) + gridSize;
			while (linesVerticalToRightPosX < scaledWidth) {
				int minY = 0;
				int maxY = scaledHeight;
				int maxX = linesVerticalToRightPosX + lineThickness;
				graphics.method_25294(linesVerticalToRightPosX, minY, maxX, maxY, UIBase.getUIColorTheme().layout_editor_grid_color_normal.getColorInt());
				linesVerticalToRightPosX += gridSize;
			}

			//Draw centered horizontal line
			graphics.method_25294(0, (scaledHeight / 2) - 1, scaledWidth, (scaledHeight / 2) + 1, UIBase.getUIColorTheme().layout_editor_grid_color_center.getColorInt());

			//Draw horizontal lines center -> top
			int linesHorizontalToTopPosY = (scaledHeight / 2) - gridSize - 1;
			while (linesHorizontalToTopPosY > 0) {
				int minX = 0;
				int maxX = scaledWidth;
				int maxY = linesHorizontalToTopPosY + lineThickness;
				graphics.method_25294(minX, linesHorizontalToTopPosY, maxX, maxY, UIBase.getUIColorTheme().layout_editor_grid_color_normal.getColorInt());
				linesHorizontalToTopPosY -= gridSize;
			}

			//Draw horizontal lines center -> bottom
			int linesHorizontalToBottomPosY = (scaledHeight / 2) + gridSize;
			while (linesHorizontalToBottomPosY < scaledHeight) {
				int minX = 0;
				int maxX = scaledWidth;
				int maxY = linesHorizontalToBottomPosY + lineThickness;
				graphics.method_25294(minX, linesHorizontalToBottomPosY, maxX, maxY, UIBase.getUIColorTheme().layout_editor_grid_color_normal.getColorInt());
				linesHorizontalToBottomPosY += gridSize;
			}

			graphics.method_51448().popMatrix();

		}

	}

	protected void constructElementInstances() {

		//Clear element lists
		for (AbstractEditorElement e : this.getAllElements()) {
			e.resetElementStates();
		}
		this.normalEditorElements.clear();
		this.vanillaWidgetEditorElements.clear();

		Layout.OrderedElementCollection normalElements = new Layout.OrderedElementCollection();
		List<VanillaWidgetElement> vanillaWidgetElements = (this.layoutTargetScreen != null) ? new ArrayList<>() : null;

		this.cachedVanillaWidgetMetas.clear();
		if (this.layoutTargetScreen != null) {
			this.cachedVanillaWidgetMetas.addAll(ScreenWidgetDiscoverer.getWidgetsOfScreen(this.layoutTargetScreen, true));
		}
		for (WidgetMeta m : this.cachedVanillaWidgetMetas) {
			if (m.getWidget() instanceof CustomizableWidget w) {
				w.resetWidgetCustomizationsFancyMenu();
			}
		}

		this.constructElementInstances(this.layout.screenIdentifier, this.cachedVanillaWidgetMetas, this.layout, normalElements, vanillaWidgetElements);

		//Wrap normal elements
		for (AbstractElement e : ListUtils.mergeLists(normalElements.backgroundElements, normalElements.foregroundElements)) {
			AbstractEditorElement editorElement = e.builder.wrapIntoEditorElementInternal(e, this);
			if (editorElement != null) {
				this.normalEditorElements.add(editorElement);
			}
		}
		//Wrap vanilla elements
		if (vanillaWidgetElements != null) {
			for (VanillaWidgetElement e : vanillaWidgetElements) {
				VanillaWidgetEditorElement editorElement = (VanillaWidgetEditorElement) VanillaWidgetElementBuilder.INSTANCE.wrapIntoEditorElementInternal(e, this);
				if (editorElement != null) {
					this.vanillaWidgetEditorElements.add(editorElement);
				}
			}
		}

	}

	protected void serializeElementInstancesToLayoutInstance() {

		this.layout.serializedElements.clear();
		this.layout.serializedVanillaButtonElements.clear();
		this.layout.serializedDeepElements.clear();

		//Serialize normal elements
		for (AbstractEditorElement e : this.normalEditorElements) {
			SerializedElement serialized = e.element.builder.serializeElementInternal(e.element);
			if (serialized != null) {
				this.layout.serializedElements.add(serialized);
			}
		}
		//Serialize vanilla button elements
		for (VanillaWidgetEditorElement e : this.vanillaWidgetEditorElements) {
			SerializedElement serialized = VanillaWidgetElementBuilder.INSTANCE.serializeElementInternal(e.element);
			if (serialized != null) {
				this.layout.serializedVanillaButtonElements.add(serialized);
			}
		}

	}

	@NotNull
	public List<AbstractEditorElement> getAllElements() {
		List<AbstractEditorElement> elements = new ArrayList<>();
		List<AbstractEditorElement> selected = new ArrayList<>();
		List<AbstractEditorElement> elementsFinal = new ArrayList<>();
		if (this.layout.renderElementsBehindVanilla) {
			elements.addAll(this.normalEditorElements);
		}
		elements.addAll(this.vanillaWidgetEditorElements);
		if (!this.layout.renderElementsBehindVanilla) {
			elements.addAll(this.normalEditorElements);
		}
		//Put selected elements at the end, because they are always on top
		for (AbstractEditorElement e : elements) {
			if (!e.isSelected()) {
				elementsFinal.add(e);
			} else {
				selected.add(e);
			}
		}
		elementsFinal.addAll(selected);
		return elementsFinal;
	}

	@NotNull
	public List<AbstractEditorElement> getHoveredElements() {
		List<AbstractEditorElement> elements = new ArrayList<>();
		for (AbstractEditorElement e : this.getAllElements()) {
			if (e.isHovered()) {
				if (e.element.layerHiddenInEditor) continue;
				boolean hidden = (e instanceof HideableElement h) && h.isHidden();
				if (!hidden) elements.add(e);
			}
		}
		return elements;
	}

	@Nullable
	public AbstractEditorElement getTopHoveredElement() {
		List<AbstractEditorElement> hoveredElements = this.getHoveredElements();
		return (!hoveredElements.isEmpty()) ? hoveredElements.get(hoveredElements.size()-1) : null;
	}

	@NotNull
	public List<AbstractEditorElement> getSelectedElements() {
		List<AbstractEditorElement> l = new ArrayList<>();
		this.getAllElements().forEach(element -> {
			if (element.isSelected()) l.add(element);
		});
		return l;
	}

	@SuppressWarnings("all")
	@NotNull
	protected <E extends AbstractEditorElement> List<E> getSelectedElementsOfType(@NotNull Class<E> type) {
		List<E> l = new ArrayList<>();
		for (AbstractEditorElement e : this.getSelectedElements()) {
			if (type.isAssignableFrom(e.getClass())) {
				l.add((E)e);
			}
		}
		return l;
	}

	@Nullable
	public AbstractEditorElement getElementByInstanceIdentifier(@NotNull String instanceIdentifier) {
		instanceIdentifier = instanceIdentifier.replace("vanillabtn:", "").replace("button_compatibility_id:", "");
		for (AbstractEditorElement e : this.getAllElements()) {
			if (e.element.getInstanceIdentifier().equals(instanceIdentifier)) {
				return e;
			}
		}
		return null;
	}

	public void selectAllElements() {
		for (AbstractEditorElement e : this.getAllElements()) {
			if (e.element.layerHiddenInEditor) continue;
			e.setSelected(true);
		}
	}

	public void deselectAllElements() {
		for (AbstractEditorElement e : this.getAllElements()) {
			e.setSelected(false);
		}
	}

	@SuppressWarnings("all")
	public boolean deleteElement(@NotNull AbstractEditorElement element) {
		if (element.settings.isDestroyable()) {
			if (!element.settings.shouldHideInsteadOfDestroy()) {
				this.normalEditorElements.remove(element);
				this.vanillaWidgetEditorElements.remove(element);
				for (AbstractLayoutEditorWidget w : this.layoutEditorWidgets) {
					w.editorElementRemovedOrHidden(element);
				}
				return true;
			} else if (element instanceof HideableElement hideable) {
				hideable.setHidden(true);
				return true;
			}
		}
		return false;
	}

	protected boolean isElementOverlappingArea(@NotNull AbstractEditorElement element, int xStart, int yStart, int xEnd, int yEnd) {
		int elementStartX = element.getX();
		int elementStartY = element.getY();
		int elementEndX = element.getX() + element.getWidth();
		int elementEndY = element.getY() + element.getHeight();
		return (xEnd > elementStartX) && (yEnd > elementStartY) && (yStart < elementEndY) && (xStart < elementEndX);
	}

	public boolean allSelectedElementsMovable() {
		for (AbstractEditorElement e : this.getSelectedElements()) {
			if (e.element.layerHiddenInEditor) return false;
			if (!e.settings.isMovable()) return false;
		}
		return true;
	}

	public boolean canMoveLayerUp(AbstractEditorElement element) {
		int index = this.normalEditorElements.indexOf(element);
		if (index == -1) return false;
		return index < this.normalEditorElements.size()-1;
	}

	public boolean canMoveLayerDown(AbstractEditorElement element) {
		int index = this.normalEditorElements.indexOf(element);
		return index > 0;
	}

	/**
	 * Returns the element the given one was moved above or NULL if there was no element above the given one.
	 */
	@Nullable
	public AbstractEditorElement moveLayerUp(@NotNull AbstractEditorElement element) {
		AbstractEditorElement movedAbove = null;
		try {
			if (this.normalEditorElements.contains(element)) {
				List<AbstractEditorElement> newNormalEditorElements = new ArrayList<>();
				int index = this.normalEditorElements.indexOf(element);
				int i = 0;
				if (index < (this.normalEditorElements.size() - 1)) {
					for (AbstractEditorElement e : this.normalEditorElements) {
						if (e != element) {
							newNormalEditorElements.add(e);
							if (i == index+1) {
								movedAbove = e;
								newNormalEditorElements.add(element);
							}
						}
						i++;
					}
					this.normalEditorElements = newNormalEditorElements;
				}
			}
		} catch (Exception ex) {
			ex.printStackTrace();
		}
		return movedAbove;
	}

	/**
	 * Returns the element the given one was moved behind or NULL if there was no element behind the given one.
	 */
	@Nullable
	public AbstractEditorElement moveLayerDown(AbstractEditorElement element) {
		AbstractEditorElement movedBehind = null;
		try {
			if (this.normalEditorElements.contains(element)) {
				List<AbstractEditorElement> newNormalEditorElements = new ArrayList<>();
				int index = this.normalEditorElements.indexOf(element);
				int i = 0;
				if (index > 0) {
					for (AbstractEditorElement e : this.normalEditorElements) {
						if (e != element) {
							if (i == index-1) {
								newNormalEditorElements.add(element);
								movedBehind = e;
							}
							newNormalEditorElements.add(e);
						}
						i++;
					}
					this.normalEditorElements = newNormalEditorElements;
				}
			}
		} catch (Exception ex) {
			ex.printStackTrace();
		}
		return movedBehind;
	}

	/**
	 * Moves a layer element to a specific position in the layer order.
	 *
	 * @param element The element to move
	 * @param targetIndex The index to move the element to (in the normalEditorElements list)
	 * @return true if the move was successful, false otherwise
	 */
	public boolean moveLayerToPosition(AbstractEditorElement element, int targetIndex) {
		try {
			if (this.normalEditorElements.contains(element)) {
				int sourceIndex = this.normalEditorElements.indexOf(element);

				// Skip if element is already at the target position
				if (sourceIndex == targetIndex) {
					return false;
				}

				// Create a new list for the reordered elements
				List<AbstractEditorElement> newNormalEditorElements = new ArrayList<>(this.normalEditorElements);

				// Remove the element from its current position
				newNormalEditorElements.remove(element);

				// Make sure targetIndex is valid after removal
				int adjustedTargetIndex = targetIndex;
				if (sourceIndex < targetIndex) {
					adjustedTargetIndex--;
				}

				// Insert at the target position
				if (adjustedTargetIndex >= newNormalEditorElements.size()) {
					newNormalEditorElements.add(element);
				} else if (adjustedTargetIndex < 0) {
					newNormalEditorElements.add(0, element);
				} else {
					newNormalEditorElements.add(adjustedTargetIndex, element);
				}

				// Update the elements list
				this.normalEditorElements = newNormalEditorElements;

				// Notify widgets about the change
				boolean movedUp = sourceIndex > targetIndex;
				this.layoutEditorWidgets.forEach(widget -> widget.editorElementOrderChanged(element, movedUp));

				// Mark layout as having unsaved changes
				this.unsavedChanges = true;

				return true;
			}
		} catch (Exception ex) {
			LOGGER.error("Failed to move layer to position", ex);
		}
		return false;
	}

	public void copyElementsToClipboard(AbstractEditorElement... elements) {
		if ((elements != null) && (elements.length > 0)) {
			COPIED_ELEMENTS_CLIPBOARD.clear();
			for (AbstractEditorElement e : elements) {
				if (e.element.layerHiddenInEditor) continue;
				if (e.settings.isCopyable()) {
					SerializedElement serialized = e.element.builder.serializeElementInternal(e.element);
					if (serialized != null) {
						serialized.putProperty("instance_identifier", ScreenCustomization.generateUniqueIdentifier());
						COPIED_ELEMENTS_CLIPBOARD.put(serialized, e.element.builder);
					}
				}
			}
		}
	}

	public void pasteElementsFromClipboard() {
		if (!COPIED_ELEMENTS_CLIPBOARD.isEmpty()) {
			this.deselectAllElements();
			for (Map.Entry<SerializedElement, ElementBuilder<?,?>> m : COPIED_ELEMENTS_CLIPBOARD.entrySet()) {
				m.getKey().putProperty("instance_identifier", ScreenCustomization.generateUniqueIdentifier());
				AbstractElement deserialized = m.getValue().deserializeElementInternal(m.getKey());
				if (deserialized != null) {
					AbstractEditorElement deserializedEditorElement = m.getValue().wrapIntoEditorElementInternal(deserialized, this);
					if (deserializedEditorElement != null) {
						this.normalEditorElements.add(deserializedEditorElement);
						this.layoutEditorWidgets.forEach(widget -> widget.editorElementAdded(deserializedEditorElement));
						deserializedEditorElement.element.layerHiddenInEditor = false;
						deserializedEditorElement.setSelected(true);
					}
				}
			}
		}
	}

	public void saveLayout() {
		if (this.layout.layoutFile != null) {
			this.layout.updateLastEditedTime();
			this.serializeElementInstancesToLayoutInstance();
			if (!this.layout.saveToFileIfPossible()) {
				class_310.method_1551().method_1507(NotificationScreen.error((call) -> {
					class_310.method_1551().method_1507(this);
				}, LocalizationUtils.splitLocalizedStringLines("fancymenu.editor.saving_failed.generic")));
			} else {
				this.unsavedChanges = false;
				LayoutHandler.reloadLayouts();
			}
		} else {
			this.saveLayoutAs();
		}
	}

	public void saveLayoutAs() {
		String fileNamePreset = "universal_layout";
		if (this.layoutTargetScreen != null) {
			fileNamePreset = ScreenIdentifierHandler.getIdentifierOfScreen(this.layoutTargetScreen) + "_layout";
		}
		fileNamePreset = fileNamePreset.toLowerCase();
		fileNamePreset = CharacterFilter.buildOnlyLowercaseFileNameFilter().filterForAllowedChars(fileNamePreset);
		fileNamePreset = FileUtils.generateAvailableFilename(LayoutHandler.LAYOUT_DIR.getAbsolutePath(), fileNamePreset, "txt");
		if (this.layout.layoutFile != null) {
			fileNamePreset = this.layout.layoutFile.getName();
		}
		SaveFileScreen s = (SaveFileScreen) SaveFileScreen.build(LayoutHandler.LAYOUT_DIR, fileNamePreset, "txt", (call) -> {
			if (call != null) {
				try {
					this.layout.updateLastEditedTime();
					this.serializeElementInstancesToLayoutInstance();
					this.layout.layoutFile = call.getAbsoluteFile();
					//Unregister old layout if it gets overridden with new one
					if (this.layout.layoutFile.isFile()) {
						Layout old = LayoutHandler.getLayout(this.layout.getLayoutName());
						if (old != null) old.delete(false);
					}
					if (!this.layout.saveToFileIfPossible()) {
						class_310.method_1551().method_1507(NotificationScreen.error((call2) -> {
							class_310.method_1551().method_1507(this);
						}, LocalizationUtils.splitLocalizedStringLines("fancymenu.editor.saving_failed.generic")));
					} else {
						this.unsavedChanges = false;
						LayoutHandler.reloadLayouts();
					}
				} catch (Exception ex) {
					ex.printStackTrace();
					class_310.method_1551().method_1507(NotificationScreen.error((call2) -> {
						class_310.method_1551().method_1507(this);
					}, LocalizationUtils.splitLocalizedStringLines("fancymenu.editor.saving_failed.generic")));
				}
			}
			class_310.method_1551().method_1507(this);
		}).setVisibleDirectoryLevelsAboveRoot(2).setShowSubDirectories(false);
		FileTypeGroup<?> fileTypeGroup = FileTypeGroup.of(FileTypes.TXT_TEXT);
		fileTypeGroup.setDisplayName(class_2561.method_43471("fancymenu.file_types.groups.text"));
		s.setFileTypes(fileTypeGroup);
		class_310.method_1551().method_1507(s);
	}

	public void onUpdateSelectedElements() {
		List<AbstractEditorElement> selected = this.getSelectedElements();
		if (selected.size() > 1) {
			for (AbstractEditorElement e : selected) {
				e.setMultiSelected(true);
			}
		} else if (selected.size() == 1) {
			selected.get(0).setMultiSelected(false);
		}
	}

	public void openRightClickMenuAtMouse(int mouseX, int mouseY) {
		if (this.rightClickMenu != null) {
			this.rightClickMenuOpenPosX = mouseX;
			this.rightClickMenuOpenPosY = mouseY;
			this.rightClickMenu.openMenuAtMouse();
		}
	}

	public void closeRightClickMenu() {
		if (this.rightClickMenu != null) {
			if (this.rightClickMenu.isUserNavigatingInMenu()) return;
			this.rightClickMenuOpenPosX = -1000;
			this.rightClickMenuOpenPosY = -1000;
			this.rightClickMenu.closeMenu();
		}
	}

	public void openElementContextMenuAtMouseIfPossible() {
		this.closeActiveElementMenu();
		List<AbstractEditorElement> selectedElements = this.getSelectedElements();
		if (selectedElements.size() == 1) {
			this.activeElementContextMenu = selectedElements.get(0).rightClickMenu;
			((IMixinScreen)this).getChildrenFancyMenu().add(0, this.activeElementContextMenu);
			this.activeElementContextMenu.openMenuAtMouse();
		} else if (selectedElements.size() > 1) {
			List<ContextMenu> menus = ObjectUtils.getOfAll(ContextMenu.class, selectedElements, consumes -> consumes.rightClickMenu);
			this.activeElementContextMenu = ContextMenu.stackContextMenus(menus);
			((IMixinScreen)this).getChildrenFancyMenu().add(0, this.activeElementContextMenu);
			this.activeElementContextMenu.openMenuAtMouse();
		}
	}

	public void closeActiveElementMenu(boolean forceClose) {
		if (this.activeElementContextMenu != null) {
			if (!forceClose && this.activeElementContextMenu.isUserNavigatingInMenu()) return;
			this.activeElementContextMenu.closeMenu();
			this.method_37066(this.activeElementContextMenu);
		}
		this.activeElementContextMenu = null;
	}

	public void closeActiveElementMenu() {
		this.closeActiveElementMenu(false);
	}

	public boolean isUserNavigatingInRightClickMenu() {
		return (this.rightClickMenu != null) && this.rightClickMenu.isUserNavigatingInMenu();
	}

	public boolean isUserNavigatingInElementMenu() {
		return (this.activeElementContextMenu != null) && this.activeElementContextMenu.isUserNavigatingInMenu();
	}

	public void saveWidgetSettings() {
		for (AbstractLayoutEditorWidget w : this.layoutEditorWidgets) {
			w.getBuilder().writeSettingsInternal(w);
		}
	}

	@NotNull
	public List<AbstractEditorElement> getCurrentlyDraggedElements() {
		return this.currentlyDraggedElements;
	}

	/**
	 * Returns NULL if there was an error while trying to get the element chain.
	 */
	@Nullable
	protected List<AbstractEditorElement> getElementChildChainOfExcluding(@NotNull AbstractEditorElement element) {
		Objects.requireNonNull(element);
		List<AbstractEditorElement> chain = new ArrayList<>();
		try {
			AbstractEditorElement e = element;
			while (true) {
				e = this.getChildElementOf(e);
				if (e == null) break;
				if (e == element) throw new IllegalStateException("Child of origin element is its own child. This shouldn't be possible and comes from an invalid ELEMENT anchor point. You need to manually fix this.");
				if (chain.contains(e)) throw new IllegalStateException("Chain already contains element! This shouldn't be possible and probably comes from an invalid ELEMENT anchor who's child is its parent or similar scenarios (sweet home Alabama). You need to manually fix this.");
				chain.add(e);
			}
		} catch (Exception ex) {
			LOGGER.error("[FANCYMENU] There was an error while trying to get the element chain!", ex);
			return null;
		}
		return chain;
	}

	@Nullable
	protected AbstractEditorElement getChildElementOf(@NotNull AbstractEditorElement element) {
		for (AbstractEditorElement e : this.getAllElements()) {
			String parentOfE = e.element.getAnchorPointElementIdentifier();
			if ((parentOfE != null) && parentOfE.equals(element.element.getInstanceIdentifier())) return e;
		}
		return null;
	}

	protected void moveSelectedElementsByXYOffset(int offsetX, int offsetY) {
		List<AbstractEditorElement> selected = this.getSelectedElements();
		if ((!selected.isEmpty()) && this.allSelectedElementsMovable()) {
			this.history.saveSnapshot();
		}
		boolean multiSelect = selected.size() > 1;
		for (AbstractEditorElement e : selected) {
			if (this.allSelectedElementsMovable()) {
				if (!multiSelect || !e.isElementAnchorAndParentIsSelected()) {
					e.element.posOffsetX = e.element.posOffsetX + offsetX;
					e.element.posOffsetY = e.element.posOffsetY + offsetY;
				}
			} else if (!e.settings.isMovable()) {
				e.renderMovingNotAllowedTime = System.currentTimeMillis() + 800;
			}
		}
	}

	//Called before mouseDragged
	@Override
	public boolean method_25402(class_11909 event, boolean isDoubleClick) {

		this.leftMouseDownPosX = (int) event.comp_4798();
		this.leftMouseDownPosY = (int) event.comp_4799();

		boolean menuBarContextOpen = (this.menuBar != null) && this.menuBar.isEntryContextMenuOpen();

		if (super.method_25402(event, isDoubleClick)) {
			this.closeRightClickMenu();
			this.closeActiveElementMenu();
			return true;
		}

		//Skip the first click out of the menu bar context menus
		if (menuBarContextOpen) return true;

		AbstractEditorElement topHoverElement = this.getTopHoveredElement();

		boolean topHoverGotSelected = false;
		if (topHoverElement != null) {
			//Select hovered element on left- and right-click
			if (!this.rightClickMenu.isUserNavigatingInMenu() && ((this.activeElementContextMenu == null) || !this.activeElementContextMenu.isUserNavigatingInMenu())) {
				if (!topHoverElement.isSelected()) {
					topHoverElement.setSelected(true);
					topHoverElement.recentlyLeftClickSelected = true;
					topHoverGotSelected = true;
				}
			}
		}
		boolean canStartMouseSelection = true;
		//Handle mouse click for elements
		for (AbstractEditorElement e : this.getAllElements()) {
			e.method_25402(event, isDoubleClick);
			if (e.isHovered() || e.isGettingResized() || (e.getHoveredResizeGrabber() != null)) {
				canStartMouseSelection = false;
			}
		}
		//Handle mouse selection
		if ((event.method_74245() == 0) && canStartMouseSelection) {
			this.isMouseSelection = true;
			this.mouseSelectionStartX = (int) event.comp_4798();
			this.mouseSelectionStartY = (int) event.comp_4799();
		}
		//Deselect all elements
		if (!this.rightClickMenu.isUserNavigatingInMenu() && ((this.activeElementContextMenu == null) || !this.activeElementContextMenu.isUserNavigatingInMenu()) && !event.method_74240()) {
			if ((event.method_74245() == 0) || ((event.method_74245() == 1) && ((topHoverElement == null) || topHoverGotSelected))) {
				for (AbstractEditorElement e : this.getAllElements()) {
					if (!e.isGettingResized() && ((topHoverElement == null) || (e != topHoverElement))) e.setSelected(false);
				}
			}
		}
		//Close active element context menu
		this.closeActiveElementMenu();
		//Close background right-click context menu
		if ((event.method_74245() == 0) && !this.rightClickMenu.isUserNavigatingInMenu()) {
			this.closeRightClickMenu();
		}
		//Open background right-click context menu
		if (topHoverElement == null) {
			if (event.method_74245() == 1) {
				this.openRightClickMenuAtMouse((int) event.comp_4798(), (int) event.comp_4799());
			}
		} else if (!topHoverElement.element.layerHiddenInEditor) {
			this.closeRightClickMenu();
			//Set and open active element context menu
			if (event.method_74245() == 1) {
				this.openElementContextMenuAtMouseIfPossible();
			}
		}

		return false;

	}

	//Called after mouseDragged
	@Override
	public boolean method_25406(class_11909 event) {

		this.anchorPointOverlay.method_25406(event);

		boolean cachedMovingStarted = this.elementMovingStarted;

		this.elementMovingStarted = false;
		this.elementResizingStarted = false;
		this.currentlyDraggedElements.clear();

		boolean mouseWasInDraggingMode = this.mouseDraggingStarted;
		this.mouseDraggingStarted = false;

		boolean cachedMouseSelection = this.isMouseSelection;
		if (event.method_74245() == 0) {
			this.isMouseSelection = false;
		}

		//Imitate super.mouseReleased in a way that doesn't suck
		this.method_25398(false);
		for(class_364 child : this.method_25396()) {
			if (child.method_25406(event)) return true;
		}

		List<AbstractEditorElement> hoveredElements = this.getHoveredElements();
		AbstractEditorElement topHoverElement = !hoveredElements.isEmpty() ? hoveredElements.get(hoveredElements.size()-1) : null;

		//Deselect hovered element on left-click if CTRL pressed
		if (!mouseWasInDraggingMode && !cachedMouseSelection && (event.method_74245() == 0) && (topHoverElement != null) && topHoverElement.isSelected() && !topHoverElement.recentlyMovedByDragging && !topHoverElement.recentlyLeftClickSelected && event.method_74240()) {
			topHoverElement.setSelected(false);
		}

		boolean elementRecentlyMovedByDragging = false;

		//Handle mouse released for all elements
		for (AbstractEditorElement e : this.getAllElements()) {
			if (e.recentlyMovedByDragging) elementRecentlyMovedByDragging = true;
			e.method_25406(event);
			e.recentlyLeftClickSelected = false;
		}

		//Save snapshot from before started dragging element(s)
		if (cachedMovingStarted && (this.preDragElementSnapshot != null)) {
			this.history.saveSnapshot(this.preDragElementSnapshot);
		}
		this.preDragElementSnapshot = null;

		return false;

	}

	@Override
	public boolean method_25403(class_11909 event, double $$3, double $$4) {

		if (super.method_25403(event, $$3, $$4)) return true;

		if (this.isMouseSelection) {
			for (AbstractEditorElement e : this.getAllElements()) {
				if (e.element.layerHiddenInEditor) continue;
				boolean b = this.isElementOverlappingArea(e, Math.min(this.mouseSelectionStartX, (int)event.comp_4798()), Math.min(this.mouseSelectionStartY, (int)event.comp_4799()), Math.max(this.mouseSelectionStartX, (int)event.comp_4798()), Math.max(this.mouseSelectionStartY, (int)event.comp_4799()));
				if (!b && event.method_74240()) continue; //skip deselect if CTRL pressed
				e.setSelected(b);
			}
		}

		int draggingDiffX = (int) (event.comp_4799() - this.leftMouseDownPosX);
		int draggingDiffY = (int) (event.comp_4799() - this.leftMouseDownPosY);
		if ((draggingDiffX != 0) || (draggingDiffY != 0)) {
			this.mouseDraggingStarted = true;
		}

		List<AbstractEditorElement> allElements = this.getAllElements();

		if (!this.elementResizingStarted) {
			allElements.forEach(element -> element.updateResizingStartPos((int)event.comp_4798(), (int)event.comp_4799()));
		}
		this.elementResizingStarted = true;

		boolean movingCrumpleZonePassed = (Math.abs(draggingDiffX) >= ELEMENT_DRAG_CRUMPLE_ZONE) || (Math.abs(draggingDiffY) >= ELEMENT_DRAG_CRUMPLE_ZONE);
		if (movingCrumpleZonePassed) {
			if (!this.elementMovingStarted) {
				if (this.preDragElementSnapshot == null) {
					this.preDragElementSnapshot = this.history.createSnapshot();
				}
				allElements.forEach(element -> {
					element.updateMovingStartPos((int)event.comp_4798(), (int)event.comp_4799());
					element.movingCrumpleZonePassed = true;
				});
				if (this.allSelectedElementsMovable()) {
					this.currentlyDraggedElements.addAll(this.getSelectedElements());
				}
			}
			this.elementMovingStarted = true;
		}
		for (AbstractEditorElement e : allElements) {
			if (e.method_25403(event, $$3, $$4)) {
				break;
			}
		}

		return false;

	}

	@Override
	public boolean method_25401(double mouseX, double mouseY, double scrollDeltaX, double scrollDeltaY) {
		boolean handled = false;
		if (FancyMenu.getOptions().enableBuddy.getValue() && !FORCE_DISABLE_BUDDY) {
			handled = this.buddyWidget.method_25401(mouseX, mouseY, scrollDeltaX, scrollDeltaY);
		}
		if (!handled && super.method_25401(mouseX, mouseY, scrollDeltaX, scrollDeltaY)) {
			return true;
		}
		return handled;
	}

	@Override
	public boolean method_25404(class_11908 event) {

		this.anchorPointOverlay.method_25404(event);

		if (super.method_25404(event)) return true;

		for (AbstractEditorElement abstractEditorElement : this.getAllElements()) {
			if (abstractEditorElement.element.layerHiddenInEditor) continue;
			if (abstractEditorElement.method_25404(event)) return true;
		}

		String key = GLFW.glfwGetKeyName(event.comp_4795(), event.comp_4796());
		if (key == null) key = "";

		//ARROW LEFT
		if (event.comp_4795() == InputConstants.field_31983) {
			this.moveSelectedElementsByXYOffset(-1, 0);
			return true;
		}

		//ARROW UP
		if (event.comp_4795() == InputConstants.field_31932) {
			this.moveSelectedElementsByXYOffset(0, -1);
			return true;
		}

		//ARROW RIGHT
		if (event.comp_4795() == InputConstants.field_31984) {
			this.moveSelectedElementsByXYOffset(1, 0);
			return true;
		}

		//ARROW DOWN
		if (event.comp_4795() == InputConstants.field_31982) {
			this.moveSelectedElementsByXYOffset(0, 1);
			return true;
		}

		//CTRL + A
		if (key.equals("a") && event.method_74240()) {
			this.selectAllElements();
		}

		//CTRL + C
		if (key.equals("c") && event.method_74240()) {
			this.copyElementsToClipboard(this.getSelectedElements().toArray(new AbstractEditorElement[0]));
			return true;
		}

		//CTRL + V
		if (key.equals("v") && event.method_74240()) {
			this.pasteElementsFromClipboard();
			return true;
		}

		//CTRL + S
		if (key.equals("s") && event.method_74240()) {
			this.saveLayout();
			return true;
		}

		//CTRL + Z
		if (key.equals("z") && event.method_74240()) {
			this.history.stepBack();
			return true;
		}

		//CTRL + Y
		if (key.equals("y") && event.method_74240()) {
			this.history.stepForward();
			return true;
		}

		//CTRL + G
		if (key.equals("g") && event.method_74240()) {
			try {
				FancyMenu.getOptions().showLayoutEditorGrid.setValue(!FancyMenu.getOptions().showLayoutEditorGrid.getValue());
			} catch (Exception e) {
				e.printStackTrace();
			}
			return true;
		}

		//DEL
		if (event.comp_4795() == InputConstants.field_31987) {
			this.history.saveSnapshot();
			for (AbstractEditorElement e : this.getSelectedElements()) {
				if (e.element.layerHiddenInEditor) continue;
				e.deleteElement();
			}
			return true;
		}

		return super.method_25404(event);

	}

	@Override
	public boolean method_16803(class_11908 event) {

		this.anchorPointOverlay.method_16803(event);

		for (AbstractEditorElement abstractEditorElement : this.getAllElements()) {
			if (abstractEditorElement.method_16803(event)) return true;
		}

		return super.method_16803(event);

	}

	public void closeEditor() {
		this.saveWidgetSettings();
		this.buddyWidget.cleanup();
		this.getAllElements().forEach(element -> {
			element.element.onDestroyElement();
			element.element.onCloseScreen(null, null);
			element.element.onCloseScreen();
		});
		this.layout.menuBackgrounds.forEach(menuBackground -> menuBackground.onCloseScreen(null, null));
		this.layout.menuBackgrounds.forEach(MenuBackground::onCloseScreen);
		currentInstance = null;
		if (this.layoutTargetScreen != null) {
			if (!((IMixinScreen)this.layoutTargetScreen).get_initialized_FancyMenu()) {
				class_310.method_1551().method_1507(this.layoutTargetScreen);
			} else {
				class_310.method_1551().method_1507(new class_424(class_2561.method_43470("Closing editor..")));
				class_310.method_1551().field_1755 = this.layoutTargetScreen;
				ScreenCustomization.reInitCurrentScreen();
			}
		} else {
			class_310.method_1551().method_1507(null);
		}
	}

	public LayoutEditorScreen setAsCurrentInstance() {
		currentInstance = this;
		return this;
	}

	/**
	 * The currently active editor instance. This is NULL when not in the editor.
	 */
	@Nullable
	public static LayoutEditorScreen getCurrentInstance() {
		return currentInstance;
	}

}
