package de.keksuccino.fancymenu.customization.listener.listeners;

import de.keksuccino.fancymenu.customization.listener.AbstractListener;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.UUID;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class OnEntitySpawnedListener extends AbstractListener {

    @Nullable
    private String cachedEntityKey;
    @Nullable
    private String cachedDistanceToPlayer;
    @Nullable
    private String cachedEntityPosX;
    @Nullable
    private String cachedEntityPosY;
    @Nullable
    private String cachedEntityPosZ;
    @Nullable
    private String cachedEntityUuid;
    @Nullable
    private String cachedDimensionKey;
    private boolean isSameDimensionAsPlayer;

    public OnEntitySpawnedListener() {
        super("entity_spawned");
    }

    public void onEntitySpawned(@Nullable String entityKey, @Nullable UUID entityUuid, double posX, double posY, double posZ, @Nullable String levelKey) {
        this.cachedEntityKey = entityKey;
        this.cachedEntityUuid = (entityUuid != null) ? entityUuid.toString() : null;
        this.cachedEntityPosX = Double.toString(posX);
        this.cachedEntityPosY = Double.toString(posY);
        this.cachedEntityPosZ = Double.toString(posZ);
        this.cachedDimensionKey = levelKey;
        this.cachedDistanceToPlayer = this.computeDistanceToPlayer(posX, posY, posZ, levelKey);
        this.notifyAllInstances();
    }

    @Nullable
    private String computeDistanceToPlayer(double posX, double posY, double posZ, @Nullable String levelKey) {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1724 == null) {
            this.isSameDimensionAsPlayer = false;
            return null;
        }
        String playerLevelKey = minecraft.field_1724.method_73183() != null ? minecraft.field_1724.method_73183().method_27983().method_29177().toString() : null;
        boolean sameDimension = (levelKey != null && playerLevelKey != null && playerLevelKey.equals(levelKey)) || (levelKey == null && playerLevelKey == null);
        this.isSameDimensionAsPlayer = sameDimension;
        if (!sameDimension) {
            return "-1";
        }
        class_243 playerPos = minecraft.field_1724.method_73189();
        double distance = playerPos.method_1022(new class_243(posX, posY, posZ));
        if (Double.isFinite(distance)) {
            return Double.toString(distance);
        }
        return null;
    }

    @Override
    protected void buildCustomVariablesAndAddToList(List<CustomVariable> list) {
        list.add(new CustomVariable("entity_key", () -> this.cachedEntityKey != null ? this.cachedEntityKey : "ERROR"));
        list.add(new CustomVariable("distance_to_player", () -> this.cachedDistanceToPlayer != null ? this.cachedDistanceToPlayer : "0"));
        list.add(new CustomVariable("entity_pos_x", () -> this.cachedEntityPosX != null ? this.cachedEntityPosX : "0"));
        list.add(new CustomVariable("entity_pos_y", () -> this.cachedEntityPosY != null ? this.cachedEntityPosY : "0"));
        list.add(new CustomVariable("entity_pos_z", () -> this.cachedEntityPosZ != null ? this.cachedEntityPosZ : "0"));
        list.add(new CustomVariable("entity_uuid", () -> this.cachedEntityUuid != null ? this.cachedEntityUuid : "ERROR"));
        list.add(new CustomVariable("dimension_key", () -> this.cachedDimensionKey != null ? this.cachedDimensionKey : "UNKNOWN"));
        list.add(new CustomVariable("is_same_dimension_as_player", () -> Boolean.toString(this.isSameDimensionAsPlayer)));
    }

    @Override
    public @NotNull class_2561 getDisplayName() {
        return class_2561.method_43471("fancymenu.listeners.on_entity_spawned");
    }

    @Override
    public @NotNull List<class_2561> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedLines("fancymenu.listeners.on_entity_spawned.desc"));
    }
}
