package de.keksuccino.fancymenu.customization.listener.listeners;

import de.keksuccino.fancymenu.customization.listener.AbstractListener;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class OnInteractedWithBlockListener extends AbstractListener {

    @Nullable
    private String cachedBlockKey;
    @Nullable
    private String cachedBlockPosX;
    @Nullable
    private String cachedBlockPosY;
    @Nullable
    private String cachedBlockPosZ;

    public OnInteractedWithBlockListener() {
        super("interacted_with_block");
    }

    public void onBlockInteracted(@NotNull class_2338 blockPos, @NotNull class_2680 blockState) {
        class_2960 blockLocation = class_7923.field_41175.method_10221(blockState.method_26204());
        this.cachedBlockKey = blockLocation != null ? blockLocation.toString() : null;
        this.cachedBlockPosX = Integer.toString(blockPos.method_10263());
        this.cachedBlockPosY = Integer.toString(blockPos.method_10264());
        this.cachedBlockPosZ = Integer.toString(blockPos.method_10260());
        this.notifyAllInstances();
    }

    @Override
    protected void buildCustomVariablesAndAddToList(List<CustomVariable> list) {
        list.add(new CustomVariable("block_key", () -> this.cachedBlockKey != null ? this.cachedBlockKey : "ERROR"));
        list.add(new CustomVariable("block_pos_x", () -> this.cachedBlockPosX != null ? this.cachedBlockPosX : "0"));
        list.add(new CustomVariable("block_pos_y", () -> this.cachedBlockPosY != null ? this.cachedBlockPosY : "0"));
        list.add(new CustomVariable("block_pos_z", () -> this.cachedBlockPosZ != null ? this.cachedBlockPosZ : "0"));
    }

    @Override
    public @NotNull class_2561 getDisplayName() {
        return class_2561.method_43471("fancymenu.listeners.on_interacted_with_block");
    }

    @Override
    public @NotNull List<class_2561> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedLines("fancymenu.listeners.on_interacted_with_block.desc"));
    }
}
