package de.keksuccino.fancymenu.customization.listener.listeners;

import de.keksuccino.fancymenu.customization.listener.AbstractListener;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Objects;
import net.minecraft.class_1959;
import net.minecraft.class_2561;
import net.minecraft.class_5321;

public class OnLeaveBiomeListener extends AbstractListener {

    private static final Logger LOGGER = LogManager.getLogger();

    @Nullable
    private class_5321<class_1959> lastBiomeKey;
    @Nullable
    private String cachedBiomeKey;

    public OnLeaveBiomeListener() {
        super("leave_biome");
    }

    public void onBiomeLeft(@Nullable class_5321<class_1959> biomeKey) {

        if (Objects.equals(this.lastBiomeKey, biomeKey)) {
            return;
        }

        this.lastBiomeKey = biomeKey;
        this.cachedBiomeKey = (biomeKey != null) ? biomeKey.method_29177().toString() : null;

        if (biomeKey != null) {
            this.notifyAllInstances();
        }

    }

    @Override
    protected void buildCustomVariablesAndAddToList(List<CustomVariable> list) {
        list.add(new CustomVariable("biome_key", () -> {
            if (this.cachedBiomeKey == null) return "ERROR";
            return this.cachedBiomeKey;
        }));
    }

    @Override
    public @NotNull class_2561 getDisplayName() {
        return class_2561.method_43471("fancymenu.listeners.on_leave_biome");
    }

    @Override
    public @NotNull List<class_2561> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedLines("fancymenu.listeners.on_leave_biome.desc"));
    }
}
