package de.keksuccino.fancymenu.customization.listener.listeners;

import de.keksuccino.fancymenu.customization.listener.AbstractListener;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.time.Instant;
import java.util.List;
import net.minecraft.class_2561;

public class OnQuitMinecraftListener extends AbstractListener {

    @Nullable
    private String cachedTimestampMillis;
    @Nullable
    private String cachedTimestampIso;

    public OnQuitMinecraftListener() {
        super("quit_minecraft");
    }

    public void onQuitMinecraft() {
        long now = System.currentTimeMillis();
        this.cachedTimestampMillis = Long.toString(now);
        this.cachedTimestampIso = Instant.ofEpochMilli(now).toString();
        this.notifyAllInstances();
    }

    @Override
    protected void buildCustomVariablesAndAddToList(List<CustomVariable> list) {
        list.add(new CustomVariable("timestamp_millis", () -> this.cachedTimestampMillis != null ? this.cachedTimestampMillis : "ERROR"));
        list.add(new CustomVariable("timestamp_iso", () -> this.cachedTimestampIso != null ? this.cachedTimestampIso : "ERROR"));
    }

    @Override
    public @NotNull class_2561 getDisplayName() {
        return class_2561.method_43471("fancymenu.listeners.on_quit_minecraft");
    }

    @Override
    public @NotNull List<class_2561> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedLines("fancymenu.listeners.on_quit_minecraft.desc"));
    }
}
