package de.keksuccino.fancymenu.customization.listener.listeners;

import de.keksuccino.fancymenu.customization.listener.AbstractListener;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_2561;

public class OnStartedFreezingListener extends AbstractListener {

    @Nullable
    private String cachedIntensity;

    public OnStartedFreezingListener() {
        super("started_freezing");
    }

    public void onStartedFreezing(float intensity) {
        this.cachedIntensity = Float.toString(Math.max(intensity, 0.0F));
        this.notifyAllInstances();
    }

    @Override
    protected void buildCustomVariablesAndAddToList(List<CustomVariable> list) {
        list.add(new CustomVariable("freezing_intensity", () -> this.cachedIntensity != null ? this.cachedIntensity : "0"));
    }

    @Override
    public @NotNull class_2561 getDisplayName() {
        return class_2561.method_43471("fancymenu.listeners.on_started_freezing");
    }

    @Override
    public @NotNull List<class_2561> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedLines("fancymenu.listeners.on_started_freezing.desc"));
    }
}
