package de.keksuccino.fancymenu.customization.loadingrequirement.requirements.gui;

import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.customization.loadingrequirement.LoadingRequirement;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementInstance;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.ScreenTitleUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.StringBuilderScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorFormattingRule;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.EditBoxSuggestions;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_1074;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7417;

public class IsMenuTitleRequirement extends LoadingRequirement {

    private static final Logger LOGGER = LogManager.getLogger();

    public IsMenuTitleRequirement() {
        super("is_menu_title");
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isRequirementMet(@Nullable String value) {

        if (value != null) {
            class_437 s = class_310.method_1551().field_1755;
            if (s != null) {
                String key = null;
                String text;
                class_2561 title = ScreenTitleUtils.getTitleOfScreen(s);
                if (title instanceof class_5250) {
                    class_7417 cc = title.method_10851();
                    if (cc instanceof class_2588 t) {
                        key = t.method_11022();
                    }
                }
                text = title.getString();
                if ((key != null) && !class_1074.method_4662(value).equals(value)) {
                    return key.equals(value);
                }
                return text.equals(value);
            }
        }

        return false;

    }

    @Override
    public @NotNull String getDisplayName() {
        return class_1074.method_4662("fancymenu.requirements.is_menu_title");
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines("fancymenu.requirements.is_menu_title.desc"));
    }

    @Override
    public String getCategory() {
        return class_1074.method_4662("fancymenu.requirements.categories.gui");
    }

    @Override
    public String getValueDisplayName() {
        return "";
    }

    @Override
    public String getValuePreset() {
        return "Example Title";
    }

    @Override
    public List<TextEditorFormattingRule> getValueFormattingRules() {
        return null;
    }

    @Override
    public void editValue(@NotNull class_437 parentScreen, @NotNull LoadingRequirementInstance requirementInstance) {
        IsMenuTitleValueConfigScreen s = new IsMenuTitleValueConfigScreen(Objects.requireNonNullElse(requirementInstance.value, ""), callback -> {
            if (callback != null) {
                requirementInstance.value = callback;
            }
            class_310.method_1551().method_1507(parentScreen);
        });
        class_310.method_1551().method_1507(s);
    }

    public static class IsMenuTitleValueConfigScreen extends StringBuilderScreen {

        @NotNull
        protected String menuTitleOrKey;

        protected TextInputCell menuTitleOrKeyCell;
        protected EditBoxSuggestions localizationKeySuggestions;

        protected IsMenuTitleValueConfigScreen(@NotNull String value, @NotNull Consumer<String> callback) {
            super(class_2561.method_43471("fancymenu.elements.requirements.edit_value"), callback);
            this.menuTitleOrKey = value;
        }

        @Override
        protected void initCells() {

            this.addSpacerCell(20);

            String id = this.getMenuTitleOrKeyString();
            this.addLabelCell(class_2561.method_43471("fancymenu.requirements.is_menu_title.value"));
            this.menuTitleOrKeyCell = this.addTextInputCell(null, true, true).setText(id);

            this.localizationKeySuggestions = EditBoxSuggestions.createWithCustomSuggestions(this, this.menuTitleOrKeyCell.editBox, EditBoxSuggestions.SuggestionsRenderPosition.ABOVE_EDIT_BOX, LocalizationUtils.getLocalizationKeys());
            UIBase.applyDefaultWidgetSkinTo(this.localizationKeySuggestions);
            this.menuTitleOrKeyCell.editBox.method_1863(s -> this.localizationKeySuggestions.method_23934());

            this.addSpacerCell(10);

            String key = "[UNKNOWN OR UNIVERSAL LAYOUT]";
            String plain = "[UNKNOWN OR UNIVERSAL LAYOUT]";
            LayoutEditorScreen editor = LayoutEditorScreen.getCurrentInstance();
            if (editor != null) {
                if (editor.layoutTargetScreen != null) {
                    String k = ScreenTitleUtils.getTitleLocalizationKeyOfScreen(editor.layoutTargetScreen);
                    if (k != null) key = k;
                    plain = ScreenTitleUtils.getTitleOfScreen(editor.layoutTargetScreen).getString();
                }
            }
            this.addLabelCell(class_2561.method_43469("fancymenu.requirements.is_menu_title.value.current_menu_title_key", class_2561.method_43470(key).method_10862(class_2583.field_24360.method_10982(false))).method_10862(class_2583.field_24360.method_10982(true)));
            this.addLabelCell(class_2561.method_43469("fancymenu.requirements.is_menu_title.value.current_menu_title_plain", class_2561.method_43470(plain).method_10862(class_2583.field_24360.method_10982(false))).method_10862(class_2583.field_24360.method_10982(true)));

            this.addSpacerCell(20);

        }

        @Override
        public void method_25394(class_332 graphics, int mouseX, int mouseY, float partial) {
            super.method_25394(graphics, mouseX, mouseY, partial);
            this.localizationKeySuggestions.method_23923(graphics, mouseX, mouseY);
        }

        @Override
        public boolean method_25404(class_11908 event) {
            if (this.localizationKeySuggestions.method_23924(event)) return true;
            return super.method_25404(event);
        }

        @Override
        public boolean method_25401(double $$0, double $$1, double scrollDeltaX, double scrollDeltaY) {
            if (this.localizationKeySuggestions.method_23921(scrollDeltaY)) return true;
            return super.method_25401($$0, $$1, scrollDeltaX, scrollDeltaY);
        }

        @Override
        public boolean method_25402(class_11909 event, boolean isDoubleClick) {
            if (this.localizationKeySuggestions.method_23922(event)) return true;
            return super.method_25402(event, isDoubleClick);
        }

        @Override
        public @NotNull String buildString() {
            return this.getMenuTitleOrKeyString();
        }

        @NotNull
        protected String getMenuTitleOrKeyString() {
            if (this.menuTitleOrKeyCell != null) {
                return this.menuTitleOrKeyCell.getText();
            }
            return this.menuTitleOrKey;
        }

    }

}
