package de.keksuccino.fancymenu.customization.loadingrequirement.requirements.world.player;

import de.keksuccino.fancymenu.customization.loadingrequirement.LoadingRequirement;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorFormattingRule;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import javax.annotation.Nullable;
import net.minecraft.class_1074;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;
import java.util.List;

public class IsRainingRequirement extends LoadingRequirement {

    private static final Logger LOGGER = LogManager.getLogger();

    public IsRainingRequirement() {
        super("is_raining");
    }

    @Override
    public boolean canRunAsync() {
        return false;
    }

    @Override
    public boolean hasValue() {
        return false;
    }

    @Override
    public boolean isRequirementMet(@Nullable String value) {
        try {
            class_638 level = class_310.method_1551().field_1687;
            class_746 player = class_310.method_1551().field_1724;
            if ((level != null) && (player != null)) {
                return isRainingAt(level, player.method_24515());
            }
        } catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to handle '" + this.getIdentifier() + "' loading requirement!", ex);
        }
        return false;
    }

    private static boolean isRainingAt(@NotNull class_1937 level, @NotNull class_2338 pos) {
        class_1959 biome = level.method_23753(pos).comp_349();
        if (!level.method_8419()) return false;
        return (biome.method_48162(pos, level.method_8615()) == class_1959.class_1963.field_9382);
    }

    @Override
    public @NotNull String getDisplayName() {
        return class_1074.method_4662("fancymenu.requirements.world.is_raining");
    }

    @Override
    public List<String> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.requirements.world.is_raining.desc"));
    }

    @Override
    public String getCategory() {
        return class_1074.method_4662("fancymenu.requirements.categories.world");
    }

    @Override
    public String getValueDisplayName() {
        return null;
    }

    @Override
    public String getValuePreset() {
        return null;
    }

    @Override
    public List<TextEditorFormattingRule> getValueFormattingRules() {
        return null;
    }

}
