package de.keksuccino.fancymenu.customization.loadingrequirement.ui;

import de.keksuccino.fancymenu.util.rendering.ui.screen.ConfirmationScreen;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.ScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.TextListScrollAreaEntry;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementContainer;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementGroup;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementInstance;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.util.function.Consumer;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class ManageRequirementsScreen extends class_437 {

    protected LoadingRequirementContainer container;
    protected Consumer<LoadingRequirementContainer> callback;

    protected ScrollArea requirementsScrollArea = new ScrollArea(0, 0, 0, 0);
    protected ExtendedButton addRequirementButton;
    protected ExtendedButton addGroupButton;
    protected ExtendedButton editButton;
    protected ExtendedButton removeButton;
    protected ExtendedButton doneButton;
    protected ExtendedButton cancelButton;

    public ManageRequirementsScreen(@NotNull LoadingRequirementContainer container, @NotNull Consumer<LoadingRequirementContainer> callback) {
        super(class_2561.method_43470(class_1074.method_4662("fancymenu.requirements.screens.manage_screen.manage")));
        this.container = container;
        this.callback = callback;
        this.updateRequirementsScrollArea();
    }

    @Override
    protected void method_25426() {

        this.addRequirementButton = new ExtendedButton(0, 0, 150, 20, class_1074.method_4662("fancymenu.requirements.screens.add_requirement"), (button) -> {
            BuildRequirementScreen s = new BuildRequirementScreen(this, this.container, null, (call) -> {
                if (call != null) {
                    this.container.addInstance(call);
                    this.updateRequirementsScrollArea();
                }
            });
            class_310.method_1551().method_1507(s);
        });
        this.method_25429(this.addRequirementButton);
        this.addRequirementButton.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.requirements.screens.manage_screen.add_requirement.desc")).setDefaultStyle());
        UIBase.applyDefaultWidgetSkinTo(this.addRequirementButton);

        this.addGroupButton = new ExtendedButton(0, 0, 150, 20, class_1074.method_4662("fancymenu.requirements.screens.add_group"), (button) -> {
            BuildRequirementGroupScreen s = new BuildRequirementGroupScreen(this, this.container, null, (call) -> {
                if (call != null) {
                    this.container.addGroup(call);
                    this.updateRequirementsScrollArea();
                }
            });
            class_310.method_1551().method_1507(s);
        });
        this.method_25429(this.addGroupButton);
        this.addGroupButton.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.requirements.screens.manage_screen.add_group.desc")).setDefaultStyle());
        UIBase.applyDefaultWidgetSkinTo(this.addGroupButton);

        this.editButton = new ExtendedButton(0, 0, 150, 20, "", (button) -> {
            class_437 s = null;
            if (this.isInstanceSelected()) {
                s = new BuildRequirementScreen(this, this.container, this.getSelectedInstance(), (call) -> {
                    if (call != null) {
                        this.updateRequirementsScrollArea();
                    }
                });
            } else if (this.isGroupSelected()) {
                s = new BuildRequirementGroupScreen(this, this.container, this.getSelectedGroup(), (call) -> {
                    if (call != null) {
                        this.updateRequirementsScrollArea();
                    }
                });
            }
            if (s != null) {
                class_310.method_1551().method_1507(s);
            }
        }) {
            @Override
            public void method_25394(@NotNull class_332 graphics, int p_93658_, int p_93659_, float p_93660_) {
                ManageRequirementsScreen s = ManageRequirementsScreen.this;
                if (!s.isInstanceSelected() && !s.isGroupSelected()) {
                    this.setLabel(class_1074.method_4662("fancymenu.requirements.screens.manage_screen.edit.generic"));
                    this.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.requirements.screens.manage_screen.no_entry_selected")).setDefaultStyle());
                    this.field_22763 = false;
                } else {
                    if (s.isInstanceSelected()) {
                        this.setLabel(class_1074.method_4662("fancymenu.requirements.screens.edit_requirement"));
                    } else {
                        this.setLabel(class_1074.method_4662("fancymenu.requirements.screens.edit_group"));
                    }
                    this.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.requirements.screens.manage_screen.edit.desc")).setDefaultStyle());
                    this.field_22763 = true;
                }
                super.method_25394(graphics, p_93658_, p_93659_, p_93660_);
            }
        };
        this.method_25429(this.editButton);
        UIBase.applyDefaultWidgetSkinTo(this.editButton);

        this.removeButton = new ExtendedButton(0, 0, 150, 20, "", (button) -> {
            class_437 s = null;
            if (this.isInstanceSelected()) {
                LoadingRequirementInstance i = this.getSelectedInstance();
                s = ConfirmationScreen.ofStrings((call) -> {
                    if (call) {
                        this.container.removeInstance(i);
                        this.updateRequirementsScrollArea();
                    }
                    class_310.method_1551().method_1507(this);
                }, LocalizationUtils.splitLocalizedStringLines("fancymenu.requirements.screens.remove_requirement.confirm"));
            } else if (this.isGroupSelected()) {
                LoadingRequirementGroup g = this.getSelectedGroup();
                s = ConfirmationScreen.ofStrings((call) -> {
                    if (call) {
                        this.container.removeGroup(g);
                        this.updateRequirementsScrollArea();
                    }
                    class_310.method_1551().method_1507(this);
                }, LocalizationUtils.splitLocalizedStringLines("fancymenu.requirements.screens.remove_group.confirm"));
            }
            if (s != null) {
                class_310.method_1551().method_1507(s);
            }
        }) {
            @Override
            public void method_25394(@NotNull class_332 graphics, int p_93658_, int p_93659_, float p_93660_) {
                ManageRequirementsScreen s = ManageRequirementsScreen.this;
                if (!s.isInstanceSelected() && !s.isGroupSelected()) {
                    this.setLabel(class_1074.method_4662("fancymenu.requirements.screens.manage_screen.remove.generic"));
                    this.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.requirements.screens.manage_screen.no_entry_selected")).setDefaultStyle());
                    this.field_22763 = false;
                } else {
                    if (s.isInstanceSelected()) {
                        this.setLabel(class_1074.method_4662("fancymenu.requirements.screens.remove_requirement"));
                    } else {
                        this.setLabel(class_1074.method_4662("fancymenu.requirements.screens.remove_group"));
                    }
                    this.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.requirements.screens.manage_screen.remove.desc")).setDefaultStyle());
                    this.field_22763 = true;
                }
                super.method_25394(graphics, p_93658_, p_93659_, p_93660_);
            }
        };
        this.method_25429(this.removeButton);
        UIBase.applyDefaultWidgetSkinTo(this.removeButton);

        this.cancelButton = new ExtendedButton(0, 0, 150, 20, class_1074.method_4662("fancymenu.common_components.cancel"), (button) -> {
            this.callback.accept(null);
        });
        this.method_25429(this.cancelButton);
        UIBase.applyDefaultWidgetSkinTo(this.cancelButton);

        this.doneButton = new ExtendedButton(0, 0, 150, 20, class_1074.method_4662("fancymenu.common_components.done"), (button) -> {
            this.callback.accept(this.container);
        });
        this.method_25429(this.doneButton);
        UIBase.applyDefaultWidgetSkinTo(this.doneButton);

    }

    @Override
    public void method_25419() {
        this.callback.accept(null);
    }

    @Override
    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {

        graphics.method_25294(0, 0, this.field_22789, this.field_22790, UIBase.getUIColorTheme().screen_background_color.getColorInt());

        class_2561 titleComp = this.field_22785.method_27661().method_27696(class_2583.field_24360.method_10982(true));
        graphics.method_51439(this.field_22793, titleComp, 20, 20, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);

        graphics.method_51433(this.field_22793, class_1074.method_4662("fancymenu.requirements.screens.manage_screen.requirements_and_groups"), 20, 50, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);

        this.requirementsScrollArea.setWidth(this.field_22789 - 20 - 150 - 20 - 20, true);
        this.requirementsScrollArea.setHeight(this.field_22790 - 85, true);
        this.requirementsScrollArea.setX(20, true);
        this.requirementsScrollArea.setY(50 + 15, true);
        this.requirementsScrollArea.render(graphics, mouseX, mouseY, partial);

        this.doneButton.method_46421(this.field_22789 - 20 - this.doneButton.method_25368());
        this.doneButton.method_46419(this.field_22790 - 20 - 20);
        this.doneButton.method_25394(graphics, mouseX, mouseY, partial);

        this.cancelButton.method_46421(this.field_22789 - 20 - this.cancelButton.method_25368());
        this.cancelButton.method_46419(this.doneButton.method_46427() - 5 - 20);
        this.cancelButton.method_25394(graphics, mouseX, mouseY, partial);

        this.removeButton.method_46421(this.field_22789 - 20 - this.removeButton.method_25368());
        this.removeButton.method_46419(this.cancelButton.method_46427() - 15 - 20);
        this.removeButton.method_25394(graphics, mouseX, mouseY, partial);

        this.editButton.method_46421(this.field_22789 - 20 - this.editButton.method_25368());
        this.editButton.method_46419(this.removeButton.method_46427() - 5 - 20);
        this.editButton.method_25394(graphics, mouseX, mouseY, partial);

        this.addGroupButton.method_46421(this.field_22789 - 20 - this.addGroupButton.method_25368());
        this.addGroupButton.method_46419(this.editButton.method_46427() - 5 - 20);
        this.addGroupButton.method_25394(graphics, mouseX, mouseY, partial);

        this.addRequirementButton.method_46421(this.field_22789 - 20 - this.addRequirementButton.method_25368());
        this.addRequirementButton.method_46419(this.addGroupButton.method_46427() - 5 - 20);
        this.addRequirementButton.method_25394(graphics, mouseX, mouseY, partial);

        super.method_25394(graphics, mouseX, mouseY, partial);

    }

    @Override
    public void method_25420(@NotNull class_332 $$0, int $$1, int $$2, float $$3) {
    }

    @Nullable
    protected LoadingRequirementInstance getSelectedInstance() {
        ScrollAreaEntry e = this.requirementsScrollArea.getFocusedEntry();
        if (e instanceof RequirementInstanceEntry) {
            return ((RequirementInstanceEntry)e).instance;
        }
        return null;
    }

    protected boolean isInstanceSelected() {
        return this.getSelectedInstance() != null;
    }

    @Nullable
    protected LoadingRequirementGroup getSelectedGroup() {
        ScrollAreaEntry e = this.requirementsScrollArea.getFocusedEntry();
        if (e instanceof RequirementGroupEntry) {
            return ((RequirementGroupEntry)e).group;
        }
        return null;
    }

    protected boolean isGroupSelected() {
        return this.getSelectedGroup() != null;
    }

    protected void updateRequirementsScrollArea() {

        this.requirementsScrollArea.clearEntries();

        for (LoadingRequirementGroup g : this.container.getGroups()) {
            RequirementGroupEntry e = new RequirementGroupEntry(this.requirementsScrollArea, g);
            this.requirementsScrollArea.addEntry(e);
        }

        for (LoadingRequirementInstance i : this.container.getInstances()) {
            RequirementInstanceEntry e = new RequirementInstanceEntry(this.requirementsScrollArea, i, 14);
            this.requirementsScrollArea.addEntry(e);
        }

    }

    public static class RequirementGroupEntry extends TextListScrollAreaEntry {

        public static final int HEADER_FOOTER_HEIGHT = 3;

        public LoadingRequirementGroup group;

        public RequirementGroupEntry(ScrollArea parent, LoadingRequirementGroup group) {
            super(parent, class_2561.method_43470(group.identifier).method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().description_area_text_color.getColorInt())).method_10852(class_2561.method_43470(" (" + class_1074.method_4662("fancymenu.requirements.screens.manage_screen.group.info", "" + group.getInstances().size()) + ")").method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().element_label_color_normal.getColorInt()))), UIBase.getUIColorTheme().listing_dot_color_3.getColor(), (entry) -> {});
            this.group = group;
            this.setHeight(this.getHeight() + (HEADER_FOOTER_HEIGHT * 2));
        }

    }

    public static class RequirementInstanceEntry extends ScrollAreaEntry {

        public static final int HEADER_FOOTER_HEIGHT = 3;

        public LoadingRequirementInstance instance;
        public final int lineHeight;
        public class_327 font = class_310.method_1551().field_1772;

        private final class_5250 displayNameComponent;
        private final class_5250 modeComponent;
        private final class_5250 valueComponent;

        public RequirementInstanceEntry(ScrollArea parent, LoadingRequirementInstance instance, int lineHeight) {

            super(parent, 100, 30);
            this.instance = instance;
            this.lineHeight = lineHeight;

            this.displayNameComponent = class_2561.method_43470(this.instance.requirement.getDisplayName()).method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().description_area_text_color.getColorInt()));
            String modeString = (this.instance.mode == LoadingRequirementInstance.RequirementMode.IF) ? class_1074.method_4662("fancymenu.requirements.screens.requirement.info.mode.normal") : class_1074.method_4662("fancymenu.requirements.screens.requirement.info.mode.opposite");
            this.modeComponent = class_2561.method_43470(class_1074.method_4662("fancymenu.requirements.screens.requirement.info.mode") + " ").method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().description_area_text_color.getColorInt())).method_10852(class_2561.method_43470(modeString).method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().element_label_color_normal.getColorInt())));
            String valueString = (this.instance.value != null) ? this.instance.value : class_1074.method_4662("fancymenu.requirements.screens.requirement.info.value.none");
            this.valueComponent = class_2561.method_43470(class_1074.method_4662("fancymenu.requirements.screens.requirement.info.value") + " ").method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().description_area_text_color.getColorInt())).method_10852(class_2561.method_43470(valueString).method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().element_label_color_normal.getColorInt())));

            this.setWidth(this.calculateWidth());
            this.setHeight((lineHeight * 3) + (HEADER_FOOTER_HEIGHT * 2));

        }

        @Override
        public void method_25394(class_332 graphics, int mouseX, int mouseY, float partial) {

            super.method_25394(graphics, mouseX, mouseY, partial);

            int centerYLine1 = this.getY() + HEADER_FOOTER_HEIGHT + (this.lineHeight / 2);
            int centerYLine2 = this.getY() + HEADER_FOOTER_HEIGHT + ((this.lineHeight / 2) * 3);
            int centerYLine3 = this.getY() + HEADER_FOOTER_HEIGHT + ((this.lineHeight / 2) * 5);

            renderListingDot(graphics, this.getX() + 5, centerYLine1 - 2, UIBase.getUIColorTheme().listing_dot_color_2.getColor());
            graphics.method_51439(this.font, this.displayNameComponent, (this.getX() + 5 + 4 + 3), (centerYLine1 - (this.font.field_2000 / 2)), -1, false);

            renderListingDot(graphics, this.getX() + 5 + 4 + 3, centerYLine2 - 2, UIBase.getUIColorTheme().listing_dot_color_1.getColor());
            graphics.method_51439(this.font, this.modeComponent, (this.getX() + 5 + 4 + 3 + 4 + 3), (centerYLine2 - (this.font.field_2000 / 2)), -1, false);

            renderListingDot(graphics, this.getX() + 5 + 4 + 3, centerYLine3 - 2, UIBase.getUIColorTheme().listing_dot_color_1.getColor());
            graphics.method_51439(this.font, this.valueComponent, (this.getX() + 5 + 4 + 3 + 4 + 3), (centerYLine3 - (this.font.field_2000 / 2)), -1, false);

        }

        private int calculateWidth() {
            int w = 5 + 4 + 3 + this.font.method_27525(this.displayNameComponent) + 5;
            int w2 = 5 + 4 + 3 + 4 + 3 + this.font.method_27525(this.modeComponent) + 5;
            int w3 = 5 + 4 + 3 + 4 + 3 + this.font.method_27525(this.valueComponent) + 5;
            if (w2 > w) {
                w = w2;
            }
            if (w3 > w) {
                w = w3;
            }
            return w;
        }

        @Override
        public void onClick(ScrollAreaEntry entry) {}

    }

}
