package de.keksuccino.fancymenu.customization.placeholder.placeholders.client;

import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.platform.Services;
import de.keksuccino.konkrete.Konkrete;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_310;

public class TotalModsPlaceholder extends Placeholder {

    private static final File MOD_DIRECTORY = new File(class_310.method_1551().field_1697, "mods");

    private static int cachedTotalMods = -10;

    public TotalModsPlaceholder() {
        super("totalmods");
    }

    @Override
    public boolean canRunAsync() {
        return false;
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        int loaded = getLoadedMods();
        int total = getTotalMods();
        if (total < loaded) {
            total = loaded;
        }
        return "" + total;
    }

    private static int getLoadedMods() {
        try {
            int i = 0;
            if (Konkrete.isOptifineLoaded) {
                i++;
            }
            return Services.PLATFORM.getLoadedModIds().size() + i;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return -1;
    }

    private static int getTotalMods() {
        if (cachedTotalMods == -10) {
            if (MOD_DIRECTORY.exists()) {
                int i = 0;
                File[] files = MOD_DIRECTORY.listFiles();
                if (files != null) {
                    for (File f : files) {
                        if (f.isFile() && f.getName().toLowerCase().endsWith(".jar")) {
                            i++;
                        }
                    }
                }
                cachedTotalMods = i+2;
            } else {
                cachedTotalMods = -1;
            }
        }
        return cachedTotalMods;
    }

    @Override
    public @Nullable List<String> getValueNames() {
        return null;
    }

    @Override
    public @NotNull String getDisplayName() {
        return class_1074.method_4662("fancymenu.placeholders.totalmods");
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines("fancymenu.placeholders.totalmods.desc"));
    }

    @Override
    public String getCategory() {
        return class_1074.method_4662("fancymenu.requirements.categories.client");
    }

    @Override
    public @NotNull DeserializedPlaceholderString getDefaultPlaceholderString() {
        DeserializedPlaceholderString dps = new DeserializedPlaceholderString();
        dps.placeholderIdentifier = this.getIdentifier();
        return dps;
    }

}
