package de.keksuccino.fancymenu.customization.placeholder.placeholders.scoreboard;

import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_268;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class ScoreboardPlayerTeamPlaceholder extends Placeholder {

    public ScoreboardPlayerTeamPlaceholder() {
        super("player_team");
    }

    @Override
    public boolean canRunAsync() {
        return false;
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        class_746 player = class_310.method_1551().field_1724;
        class_638 level = class_310.method_1551().field_1687;
        String playerName = dps.values.get("player_name");
        if ((player != null) && (level != null) && (playerName != null)) {
            class_268 team = level.method_8428().method_1164(playerName);
            if (team != null) return team.method_1197();
        }
        return "";
    }

    @Override
    public @Nullable List<String> getValueNames() {
        return List.of("player_name");
    }

    @Override
    public @NotNull String getDisplayName() {
        return class_1074.method_4662("fancymenu.placeholders.player_team");
    }

    @Override
    public @Nullable List<String> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.placeholders.player_team.desc"));
    }

    @Override
    public String getCategory() {
        return class_1074.method_4662("fancymenu.placeholders.categories.scoreboard");
    }

    @Override
    public @NotNull DeserializedPlaceholderString getDefaultPlaceholderString() {
        HashMap<String, String> values = new LinkedHashMap<>();
        values.put("player_name", "LadyAgnes");
        return new DeserializedPlaceholderString(this.getIdentifier(), values, "");
    }

}
