package de.keksuccino.fancymenu.customization.placeholder.placeholders.scoreboard;

import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import net.minecraft.class_1074;
import net.minecraft.class_266;
import net.minecraft.class_269;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_9013;
import net.minecraft.class_9015;
import net.minecraft.world.scores.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

public class ScoreboardScorePlaceholder extends Placeholder {

    public ScoreboardScorePlaceholder() {
        super("scoreboard_score");
    }

    @Override
    public boolean canRunAsync() {
        return false;
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        class_638 level = class_310.method_1551().field_1687;
        String playerName = dps.values.get("player");
        String objectiveName = dps.values.get("objective");
        
        if ((level != null) && (playerName != null) && (objectiveName != null)) {
            class_269 scoreboard = level.method_8428();
            class_266 objective = scoreboard.method_1170(objectiveName);
            
            if (objective != null) {
                class_9015 scoreHolder = class_9015.method_55422(playerName);
                class_9013 scoreInfo = scoreboard.method_55430(scoreHolder, objective);
                
                if (scoreInfo != null) {
                    return String.valueOf(scoreInfo.method_55397());
                }
            }
        }
        return "";
    }

    @Override
    public @Nullable List<String> getValueNames() {
        return List.of("player", "objective");
    }

    @Override
    public @NotNull String getDisplayName() {
        return class_1074.method_4662("fancymenu.placeholders.scoreboard.score");
    }

    @Override
    public @Nullable List<String> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.placeholders.scoreboard.score.desc"));
    }

    @Override
    public String getCategory() {
        return class_1074.method_4662("fancymenu.placeholders.categories.scoreboard");
    }

    @Override
    public @NotNull DeserializedPlaceholderString getDefaultPlaceholderString() {
        HashMap<String, String> values = new LinkedHashMap<>();
        values.put("player", "Player1");
        values.put("objective", "score");
        return new DeserializedPlaceholderString(this.getIdentifier(), values, "");
    }
}
