package de.keksuccino.fancymenu.customization.placeholder.placeholders.server;

import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.customization.server.ServerCache;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.konkrete.math.MathUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_642;

public class ServerMotdPlaceholder extends Placeholder {

    public ServerMotdPlaceholder() {
        super("servermotd");
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        String ip = dps.values.get("ip");
        String line = dps.values.get("line");
        if ((ip != null) && (line != null) && MathUtils.isInteger(line)) {
            return getServerMotdLine(ip, Integer.valueOf(line));
        }
        return null;
    }

    private static String getServerMotdLine(String ip, int line) {
        try {
            if (line > 2) {
                line = 2;
            }
            if (line < 1) {
                line = 1;
            }
            class_642 sd = ServerCache.getServer(ip);
            if (sd != null) {
                if (sd.field_3757 != null) {
                    List<String> lines = splitMotdLines(sd.field_3757.getString());
                    if (lines.size() >= 2) {
                        return lines.get(line-1);
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    private static List<String> splitMotdLines(String motd) {
        List<String> l = new ArrayList<>();
        try {
            if (motd.contains("\n")) {
                l.addAll(Arrays.asList(motd.split("\n")));
            } else {
                l.add(motd);
                l.add("");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return l;
    }

    @Override
    public @Nullable List<String> getValueNames() {
        List<String> l = new ArrayList<>();
        l.add("ip");
        l.add("line");
        return l;
    }

    @Override
    public @NotNull String getDisplayName() {
        return class_1074.method_4662("fancymenu.placeholders.servermotd");
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines("fancymenu.placeholders.servermotd.desc"));
    }

    @Override
    public String getCategory() {
        return class_1074.method_4662("fancymenu.requirements.categories.server");
    }

    @Override
    public @NotNull DeserializedPlaceholderString getDefaultPlaceholderString() {
        DeserializedPlaceholderString dps = new DeserializedPlaceholderString();
        dps.placeholderIdentifier = this.getIdentifier();
        dps.values.put("ip", "someserver.com:25565");
        dps.values.put("line", "1");
        return dps;
    }

}
