package de.keksuccino.fancymenu.customization.placeholder.placeholders.video.background;

import de.keksuccino.fancymenu.customization.element.elements.video.VideoElementController;
import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.class_1074;

public class VideoMenuBackgroundVolumePlaceholder extends Placeholder {

    private static final Logger LOGGER = LogManager.getLogger();

    public VideoMenuBackgroundVolumePlaceholder() {
        super("video_background_vol");
    }

    @Override
    public boolean canRunAsync() {
        return false;
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        String s = dps.values.get("background_identifier");
        if (s != null) {
            VideoElementController.VideoElementMeta meta = VideoElementController.getMeta(s);
            if (meta != null) {
                return "" + meta.volume;
            }
        }
        return "0.0";
    }

    @Override
    public @Nullable List<String> getValueNames() {
        List<String> l = new ArrayList<>();
        l.add("background_identifier");
        return l;
    }

    @Override
    public @NotNull String getDisplayName() {
        return class_1074.method_4662("fancymenu.placeholders.video_background_volume");
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines("fancymenu.placeholders.video_background_volume.desc"));
    }

    @Override
    public String getCategory() {
        return class_1074.method_4662("fancymenu.placeholders.categories.video");
    }

    @Override
    public @NotNull DeserializedPlaceholderString getDefaultPlaceholderString() {
        LinkedHashMap<String, String> m = new LinkedHashMap<>();
        m.put("background_identifier", "put_identifier_of_video_background_here");
        return DeserializedPlaceholderString.build(this.getIdentifier(), m);
    }

}
