package de.keksuccino.fancymenu.customization.placeholder.placeholders.world;

import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;

public abstract class AbstractWorldPlaceholder extends Placeholder {

    public AbstractWorldPlaceholder(@NotNull String identifier) {
        super(identifier);
    }

    @Override
    public boolean canRunAsync() {
        return false;
    }

    @Nullable
    protected class_746 getPlayer() {
        return class_310.method_1551().field_1724;
    }

    @Nullable
    protected class_638 getLevel() {
        return class_310.method_1551().field_1687;
    }

    @Override
    public @Nullable List<String> getValueNames() {
        return List.of();
    }

    @NotNull
    protected abstract String getLocalizationBase();

    @Override
    public @NotNull String getDisplayName() {
        return class_1074.method_4662(this.getLocalizationBase());
    }

    @Override
    public List<String> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedStringLines(this.getLocalizationBase() + ".desc"));
    }

    @Override
    public String getCategory() {
        return class_1074.method_4662("fancymenu.placeholders.categories.world");
    }

}
