package de.keksuccino.fancymenu.customization.placeholder.placeholders.world;

import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinBossHealthOverlay;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.SerializationUtils;
import de.keksuccino.fancymenu.util.rendering.text.TextFormattingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.widget.component.ComponentSerialization;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.util.*;
import net.minecraft.class_1074;
import net.minecraft.class_310;
import net.minecraft.class_345;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class BossNamePlaceholder extends Placeholder {

    public BossNamePlaceholder() {
        super("boss_name");
    }

    @Override
    public boolean canRunAsync() {
        return false;
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        class_746 player = class_310.method_1551().field_1724;
        class_638 level = class_310.method_1551().field_1687;
        int index = SerializationUtils.deserializeNumber(Integer.class, 0, dps.values.get("boss_index"));
        boolean asJson = SerializationUtils.deserializeBoolean(false, dps.values.get("as_json"));
        if ((player != null) && (level != null)) {
            Map<UUID, class_345> bosses = ((IMixinBossHealthOverlay)class_310.method_1551().field_1705.method_1740()).get_events_FancyMenu(); // this is a linked hash map, so indexes should work fine
            if (bosses.size() >= (index + 1)) {
                int i = 0;
                for (Map.Entry<UUID, class_345> m : bosses.entrySet()) {
                    if (index == i) {
                        if (asJson) {
                            return ComponentSerialization.Serializer.toJson(m.getValue().method_5414(), level.method_30349());
                        } else {
                            return TextFormattingUtils.convertComponentToString(m.getValue().method_5414());
                        }
                    }
                    i++;
                }
            }
        }
        return "";
    }

    @Override
    public @Nullable List<String> getValueNames() {
        return List.of("boss_index", "as_json");
    }

    @Override
    public @NotNull String getDisplayName() {
        return class_1074.method_4662("fancymenu.placeholders.world.boss_name");
    }

    @Override
    public @Nullable List<String> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.placeholders.world.boss_name.desc"));
    }

    @Override
    public String getCategory() {
        return class_1074.method_4662("fancymenu.placeholders.categories.world");
    }

    @Override
    public @NotNull DeserializedPlaceholderString getDefaultPlaceholderString() {
        HashMap<String, String> values = new LinkedHashMap<>();
        values.put("boss_index", "0");
        values.put("as_json", "false");
        return new DeserializedPlaceholderString(this.getIdentifier(), values, "");
    }

}
