package de.keksuccino.fancymenu.customization.placeholder.placeholders.world;

import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_742;

public class PlayerHasTagPlaceholder extends Placeholder {

    public PlayerHasTagPlaceholder() {
        super("player_has_tag");
    }

    @Override
    public boolean canRunAsync() {
        return false;
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        class_638 level = class_310.method_1551().field_1687;
        String playerName = dps.values.get("player_name");
        String tagName = dps.values.get("tag_name");
        
        if ((level != null) && (playerName != null) && (tagName != null)) {
            // Search for player by name
            for (class_742 player : level.method_18456()) {
                if (player.method_5477().getString().equals(playerName)) {
                    // Check if player has the specified tag
                    return String.valueOf(player.method_5752().contains(tagName));
                }
            }
        }
        return "false";
    }

    @Override
    public @Nullable List<String> getValueNames() {
        return List.of("player_name", "tag_name");
    }

    @Override
    public @NotNull String getDisplayName() {
        return class_1074.method_4662("fancymenu.placeholders.player_has_tag");
    }

    @Override
    public @Nullable List<String> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.placeholders.player_has_tag.desc"));
    }

    @Override
    public String getCategory() {
        return class_1074.method_4662("fancymenu.placeholders.categories.world");
    }

    @Override
    public @NotNull DeserializedPlaceholderString getDefaultPlaceholderString() {
        HashMap<String, String> values = new LinkedHashMap<>();
        values.put("player_name", "Steve");
        values.put("tag_name", "my_tag");
        return new DeserializedPlaceholderString(this.getIdentifier(), values, "");
    }

}
