package de.keksuccino.fancymenu.customization.screen.identifier;

import com.mojang.realmsclient.gui.screens.*;
import com.mojang.realmsclient.gui.screens.configuration.*;
import net.minecraft.*;
import net.minecraft.client.gui.screens.*;
import net.minecraft.client.gui.screens.inventory.*;
import net.minecraft.client.gui.screens.options.*;
import net.minecraft.client.gui.screens.worldselection.*;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.util.*;

public class UniversalScreenIdentifierRegistry {

    private static final Logger LOGGER = LogManager.getLogger();

    private static final Map<String, String> UNIVERSAL_IDENTIFIERS = new LinkedHashMap<>();

    static {

        register("title_screen", class_442.class.getName());
        register("realms_main_screen", class_4325.class.getName());
        register("realms_backup_info_screen", class_4379.class.getName());
        register("realms_backup_screen", class_4381.class.getName());
        register("realms_broken_world_screen", class_4384.class.getName());
        register("realms_client_outdated_screen", class_4387.class.getName());
        register("realms_configure_world_screen", class_4388.class.getName());
        register("realms_confirm_screen", class_4389.class.getName());
        register("realms_create_realm_screen", class_4390.class.getName());
        register("realms_download_latest_world_screen", class_4392.class.getName());
        register("realms_generic_error_screen", class_4394.class.getName());
        register("realms_invite_screen", class_4395.class.getName());
        register("realms_long_running_mco_task_screen", class_4398.class.getName());
        register("realms_notifications_screen", class_4399.class.getName());
        register("realms_parental_consent_screen", class_4400.class.getName());
        register("realms_pending_invites_screen", class_4401.class.getName());
        register("realms_reset_world_screen", class_4410.class.getName());
        register("realms_select_file_to_upload_screen", class_4416.class.getName());
        register("realms_select_world_template_screen", class_4419.class.getName());
        register("realms_slot_options_screen", class_4423.class.getName());
        register("realms_terms_screen", class_4426.class.getName());
        register("realms_upload_screen", class_4427.class.getName());
        register("accessibility_onboarding_screen", class_8032.class.getName());
        register("accessibility_options_screen", class_4189.class.getName());
        register("alert_screen", class_403.class.getName());
        register("backup_confirm_screen", class_405.class.getName());
        register("chat_options_screen", class_404.class.getName());
        register("chat_screen", class_408.class.getName());
        register("confirm_link_screen", class_407.class.getName());
        register("confirm_screen", class_410.class.getName());
        register("connect_screen", class_412.class.getName());
        register("create_buffet_world_screen", class_415.class.getName());
        register("create_flat_world_screen", class_413.class.getName());
        register("credits_and_attribution_screen", class_8219.class.getName());
        register("datapack_load_failure_screen", class_5346.class.getName());
        register("death_screen", class_418.class.getName());
        register("title_confirm_screen", class_418.class_8183.class.getName());
        register("demo_intro_screen", class_417.class.getName());
        register("direct_join_server_screen", class_420.class.getName());
        register("disconnected_screen", class_419.class.getName());
        register("error_screen", class_421.class.getName());
        register("generic_dirt_message_screen", class_424.class.getName());
        register("generic_waiting_screen", class_7534.class.getName());
        register("in_bed_chat_screen", class_423.class.getName());
        register("language_select_screen", class_426.class.getName());
        register("level_loading_screen", class_3928.class.getName());
        register("mouse_settings_screen", class_4288.class.getName());
        register("online_options_screen", class_6777.class.getName());
        register("options_screen", class_429.class.getName());
        register("options_sub_screen", class_4667.class.getName());
        register("out_of_memory_screen", class_428.class.getName());
        register("pause_screen", class_433.class.getName());
        register("popup_screen", class_8816.class.getName());
        register("preset_flat_world_screen", class_430.class.getName());
        register("progress_screen", class_435.class.getName());
        register("share_to_lan_screen", class_436.class.getName());
        register("skin_customization_screen", class_440.class.getName());
        register("sound_options_screen", class_443.class.getName());
        register("video_settings_screen", class_446.class.getName());
        register("win_screen", class_445.class.getName());
        register("stats_screen", class_447.class.getName());
        register("advancements_screen", class_457.class.getName());
        register("controls_screen", class_458.class.getName());
        register("key_binds_screen", class_459.class.getName());
        register("game_mode_switcher_screen", class_5289.class.getName());
        register("anvil_screen", class_471.class.getName());
        register("beacon_screen", class_466.class.getName());
        register("blast_furnace_screen", class_3871.class.getName());
        register("book_edit_screen", class_473.class.getName());
        register("book_view_screen", class_3872.class.getName());
        register("brewing_stand_screen", class_472.class.getName());
        register("cartography_table_screen", class_3934.class.getName());
        register("command_block_edit_screen", class_477.class.getName());
        register("container_screen", class_476.class.getName());
        register("crafting_screen", class_479.class.getName());
        register("creative_mode_inventory_screen", class_481.class.getName());
        register("dispenser_screen", class_480.class.getName());
        register("enchantment_screen", class_486.class.getName());
        register("furnace_screen", class_3873.class.getName());
        register("grindstone_screen", class_3802.class.getName());
        register("hanging_sign_edit_screen", class_7744.class.getName());
        register("hopper_screen", class_488.class.getName());
        register("horse_inventory_screen", class_491.class.getName());
        register("inventory_screen", class_490.class.getName());
        register("item_combiner_screen", class_4894.class.getName());
        register("jigsaw_block_edit_screen", class_3742.class.getName());
        register("lectern_screen", class_3935.class.getName());
        register("loom_screen", class_494.class.getName());
        register("merchant_screen", class_492.class.getName());
        register("minecart_command_block_edit_screen", class_496.class.getName());
        register("shulker_box_screen", class_495.class.getName());
        register("sign_edit_screen", class_498.class.getName());
        register("smithing_screen", class_4895.class.getName());
        register("smoker_screen", class_3874.class.getName());
        register("stonecutter_screen", class_3979.class.getName());
        register("structure_block_edit_screen", class_497.class.getName());
        register("join_multiplayer_screen", class_500.class.getName());
        register("safety_screen", class_4749.class.getName());
        register("warning_screen", class_7065.class.getName());
        register("pack_selection_screen", class_5375.class.getName());
        register("chat_report_screen", class_7538.class.getName());
        register("chat_selection_screen", class_7543.class.getName());
        register("report_reason_selection_screen", class_7551.class.getName());
        register("social_interactions_screen", class_5522.class.getName());
        register("telemetry_info_screen", class_7944.class.getName());
        register("confirm_experimental_features_screen", class_7745.class.getName());
        register("create_world_screen", class_525.class.getName());
        register("edit_game_rules_screen", class_5235.class.getName());
        register("edit_world_screen", class_524.class.getName());
        register("experiments_screen", class_8134.class.getName());
        register("optimize_world_screen", class_527.class.getName());
        register("select_world_screen", class_526.class.getName());
        register("realms_screen", class_4905.class.getName());

    }

    public static void register(@NotNull String universalIdentifier, @NotNull String targetScreenClassPath) {
        if (UNIVERSAL_IDENTIFIERS.containsKey(universalIdentifier)) {
            LOGGER.warn("[FANCYMENU] Universal identifier '" + universalIdentifier + "' already registered! Replacing identifier..");
        }
        UNIVERSAL_IDENTIFIERS.put(universalIdentifier, targetScreenClassPath);
    }

    @Nullable
    public static String getScreenForUniversalIdentifier(@NotNull String universalIdentifier) {
        return UNIVERSAL_IDENTIFIERS.get(universalIdentifier);
    }

    @NotNull
    public static String tryGetUniversalIdentifierFor(@NotNull String screenClassPath) {
        String universal = getUniversalIdentifierFor(screenClassPath);
        return (universal != null) ? universal : screenClassPath;
    }

    @Nullable
    public static String getUniversalIdentifierFor(@NotNull String screenClassPath) {
        if (universalIdentifierExists(screenClassPath)) return screenClassPath;
        for (Map.Entry<String, String> m : UNIVERSAL_IDENTIFIERS.entrySet()) {
            if (m.getValue().equals(screenClassPath)) return m.getKey();
        }
        return null;
    }

    @Nullable
    public static String getUniversalIdentifierFor(@NotNull class_437 screen) {
        return getUniversalIdentifierFor(screen.getClass().getName());
    }

    @NotNull
    public static List<String> getUniversalIdentifiers() {
        return new ArrayList<>(UNIVERSAL_IDENTIFIERS.keySet());
    }

    public static boolean universalIdentifierExists(@NotNull String identifier) {
        return UNIVERSAL_IDENTIFIERS.containsKey(identifier);
    }

}
