package de.keksuccino.fancymenu.customization.server;

import de.keksuccino.fancymenu.customization.ScreenCustomization;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_642;
import net.minecraft.class_644;

public class ServerCache {

    protected static final class_2561 CANT_CONNECT_TEXT = (class_2561.method_43471("multiplayer.status.cannot_connect")).method_27692(class_124.field_1079);

    protected static class_644 pinger = new class_644();
    protected static Map<String, class_642> servers = new HashMap<>();
    protected static Map<String, class_642> serversUpdated = new HashMap<>();

    public static void init() {
        new Thread(() -> {
            while (true) {
                try {
                    if (ScreenCustomization.isCustomizationEnabledForScreen(class_310.method_1551().field_1755)) {
                        pingServers();
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    Thread.sleep(30000);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    public static void cacheServer(class_642 server, class_642 serverUpdated) {
        if (server.field_3761 != null) {
            try {
                server.field_3758 = -1L;
                serverUpdated.field_3758 = -1L;
                servers.put(server.field_3761, server);
                serversUpdated.put(server.field_3761, serverUpdated);
                pingServers();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class_642 getServer(String ip) {
        if (!servers.containsKey(ip)) {
            cacheServer(new class_642(ip, ip, class_642.class_8678.field_45611), new class_642(ip, ip, class_642.class_8678.field_45611));
        }
        //Copy server data from old to new array only when server is done pinging
        if (servers.get(ip).field_3757 != null) {
            if (!servers.get(ip).field_3757.equals(class_2561.method_43471("multiplayer.status.pinging"))) {
                serversUpdated.get(ip).field_3758 = servers.get(ip).field_3758;
                serversUpdated.get(ip).field_3756 = servers.get(ip).field_3756;
                serversUpdated.get(ip).field_3757 = servers.get(ip).field_3757;
                serversUpdated.get(ip).field_3760 = servers.get(ip).field_3760;
                serversUpdated.get(ip).field_3753 = servers.get(ip).field_3753;
                serversUpdated.get(ip).field_3762 = servers.get(ip).field_3762;
            }
        }
        return serversUpdated.get(ip);
    }

    public static void removeServer(String ip) {
        servers.remove(ip);
        serversUpdated.remove(ip);
    }

    public static void clear() {
        servers.clear();
        serversUpdated.clear();
    }

    public static void pingServers() {
        List<class_642> l = new ArrayList<>(servers.values());
        for (class_642 d : l) {
            try {
                new Thread(() -> {
                    try {
                        pinger.method_3003(d, () -> {}, () -> {});
                        if ((d == null) || d.field_3753.getString().isEmpty()) {
                            d.field_3758 = -1L;
                            d.field_3757 = CANT_CONNECT_TEXT;
                        }
                    } catch (Exception ex) {
                        d.field_3758 = -1L;
                        d.field_3757 = CANT_CONNECT_TEXT;
                    }
                }).start();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

}
