package de.keksuccino.fancymenu.customization.widget;

import de.keksuccino.fancymenu.customization.screen.identifier.ScreenIdentifierHandler;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.ui.widget.UniqueWidget;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WidgetMeta {

	private final long longIdentifier;
	private String universalIdentifier;
	private final class_339 widget;
	private final class_437 screen;
	public class_2561 label;
	public int x;
	public int y;
	public int width;
	public int height;

	public WidgetMeta(@NotNull class_339 widget, long longIdentifier, @NotNull class_437 parentScreen) {
		this.longIdentifier = longIdentifier;
		this.widget = widget;
		this.screen = parentScreen;
		this.label = widget.method_25369();
		this.x = widget.method_46426();
		this.y = widget.method_46427();
		this.width = widget.method_25368();
		this.height = widget.method_25364();
	}

	@NotNull
	public class_339 getWidget() {
		return this.widget;
	}

	@NotNull
	public class_437 getScreen() {
		return this.screen;
	}

	public long getLongIdentifier() {
		return this.longIdentifier;
	}

	@Nullable
	public String getUniversalIdentifier() {
		if ((this.widget instanceof UniqueWidget u) && (u.getWidgetIdentifierFancyMenu() != null)) return u.getWidgetIdentifierFancyMenu();
		return this.universalIdentifier;
	}

	public void setUniversalIdentifier(String identifier) {
		this.universalIdentifier = identifier;
	}

	@NotNull
	public String getIdentifier() {
		if (this.getUniversalIdentifier() != null) {
			return this.getUniversalIdentifier();
		}
		return "" + this.getLongIdentifier();
	}

	@NotNull
	public String getLocator() {
		return ScreenIdentifierHandler.getIdentifierOfScreen(this.getScreen()) + ":" + this.getIdentifier();
	}

	@Nullable
	public String getWidgetLocalizationKey() {
		return LocalizationUtils.getComponentLocalizationKey(this.getWidget().method_25369());
	}

}
