package de.keksuccino.fancymenu.customization.widget.identification.identificationcontext;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.util.*;
import net.minecraft.class_437;

public class WidgetIdentificationContextRegistry {

    private static final Map<Class<? extends class_437>, WidgetIdentificationContext> CONTEXTS = new LinkedHashMap<>();

    public static void register(@NotNull WidgetIdentificationContext context) {
        if (CONTEXTS.containsKey(context.getTargetScreen())) {
            throw new RuntimeException("[FANCYMENU] WidgetIdentificationContext for '" + context.getTargetScreen().getName() + "' already registered! Can't replace contexts!");
        }
        CONTEXTS.put(context.getTargetScreen(), context);
    }

    @Nullable
    public static WidgetIdentificationContext getContextForScreen(@NotNull Class<? extends class_437> screenClass) {
        return CONTEXTS.get(screenClass);
    }

    @NotNull
    public static List<WidgetIdentificationContext> getContexts() {
        return new ArrayList<>(CONTEXTS.values());
    }

}
