package de.keksuccino.fancymenu.events.screen;

import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinScreen;
import de.keksuccino.fancymenu.util.event.acara.EventBase;
import org.jetbrains.annotations.NotNull;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_6379;

/**
 * Fired after rendering the screen background.<br>
 * This event only gets fired when the screen calls its background render method.
 **/
public class RenderedScreenBackgroundEvent extends EventBase {

    private final class_437 screen;
    private final class_332 graphics;
    private final int mouseX;
    private final int mouseY;
    private final float partial;

    public RenderedScreenBackgroundEvent(@NotNull class_437 screen, @NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        this.screen = Objects.requireNonNull(screen);
        this.graphics = Objects.requireNonNull(graphics);
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.partial = partial;
    }

    @NotNull
    public class_437 getScreen() {
        return this.screen;
    }

    @NotNull
    public class_332 getGraphics() {
        return graphics;
    }

    public int getMouseX() {
        return mouseX;
    }

    public int getMouseY() {
        return mouseY;
    }

    public float getPartial() {
        return partial;
    }

    public <T extends class_364 & class_6379> void addWidget(T widget) {
        this.getWidgets().add(widget);
        this.getNarratables().add(widget);
    }

    public <T extends class_364 & class_6379 & class_4068> void addRenderableWidget(T widget) {
        this.addWidget(widget);
        this.getRenderables().add(widget);
    }

    public List<class_364> getWidgets() {
        return ((IMixinScreen)this.getScreen()).getChildrenFancyMenu();
    }

    public List<class_4068> getRenderables() {
        return ((IMixinScreen)this.getScreen()).getRenderablesFancyMenu();
    }

    public List<class_6379> getNarratables() {
        return ((IMixinScreen)this.getScreen()).getNarratablesFancyMenu();
    }

    @Override
    public boolean isCancelable() {
        return false;
    }

}
