package de.keksuccino.fancymenu.events.screen;

import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinScreen;
import de.keksuccino.fancymenu.util.event.acara.EventBase;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFW;
import java.util.List;
import net.minecraft.class_11908;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_6379;

public class ScreenKeyReleasedEvent extends EventBase {

    private final class_437 screen;
    private final class_11908 event;

    public ScreenKeyReleasedEvent(@NotNull class_437 screen, @NotNull class_11908 event) {
        this.screen = screen;
        this.event = event;
    }

    @NotNull
    public class_437 getScreen() {
        return this.screen;
    }

    @NotNull
    public class_11908 getKeyEvent() {
        return event;
    }

    public int getKeycode() {
        return this.event.comp_4795();
    }

    public int getScancode() {
        return this.event.comp_4796();
    }

    public int getModifiers() {
        return this.event.comp_4797();
    }

    @NotNull
    public String getKeyName() {
        String key = GLFW.glfwGetKeyName(this.event.comp_4795(), this.event.comp_4796());
        if (key == null) key = "";
        return key;
    }

    public <T extends class_364 & class_6379> void addWidget(T widget) {
        this.getWidgets().add(widget);
        this.getNarratables().add(widget);
    }

    public <T extends class_364 & class_6379 & class_4068> void addRenderableWidget(T widget) {
        this.addWidget(widget);
        this.getRenderables().add(widget);
    }

    public List<class_364> getWidgets() {
        return ((IMixinScreen)this.getScreen()).getChildrenFancyMenu();
    }

    public List<class_4068> getRenderables() {
        return ((IMixinScreen)this.getScreen()).getRenderablesFancyMenu();
    }

    public List<class_6379> getNarratables() {
        return ((IMixinScreen)this.getScreen()).getNarratablesFancyMenu();
    }

    @Override
    public boolean isCancelable() {
        return false;
    }

}

