package de.keksuccino.fancymenu.events.widget;

import de.keksuccino.fancymenu.util.event.acara.EventBase;
import org.jetbrains.annotations.NotNull;
import java.util.Objects;
import net.minecraft.class_332;
import net.minecraft.class_8089;

public class RenderTabNavigationBarHeaderBackgroundEvent extends EventBase {

    private final class_8089 tabNavigationBar;
    private final class_332 graphics;
    private final int headerWidth;
    private final int headerHeight;

    protected RenderTabNavigationBarHeaderBackgroundEvent(@NotNull class_8089 tabNavigationBar, @NotNull class_332 graphics, int headerWidth, int headerHeight) {
        this.tabNavigationBar = Objects.requireNonNull(tabNavigationBar);
        this.graphics = Objects.requireNonNull(graphics);
        this.headerWidth = headerWidth;
        this.headerHeight = headerHeight;
    }

    public class_8089 getTabNavigationBar() {
        return tabNavigationBar;
    }

    public class_332 getGraphics() {
        return graphics;
    }

    public int getHeaderWidth() {
        return headerWidth;
    }

    public int getHeaderHeight() {
        return headerHeight;
    }

    @Override
    public boolean isCancelable() {
        return false;
    }

    public static class Pre extends RenderTabNavigationBarHeaderBackgroundEvent {

        public Pre(@NotNull class_8089 tabNavigationBar, @NotNull class_332 graphics, int headerWidth, int headerHeight) {
            super(tabNavigationBar, graphics, headerWidth, headerHeight);
        }

        @Override
        public boolean isCancelable() {
            return true;
        }

    }

    public static class Post extends RenderTabNavigationBarHeaderBackgroundEvent {

        public Post(@NotNull class_8089 tabNavigationBar, @NotNull class_332 graphics, int headerWidth, int headerHeight) {
            super(tabNavigationBar, graphics, headerWidth, headerHeight);
        }

    }

}
