package de.keksuccino.fancymenu.mixin.mixins.common.client;

import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.gen.Invoker;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_4717;
import net.minecraft.class_5481;
import net.minecraft.class_637;

@Mixin(class_4717.class)
public interface IMixinCommandSuggestions {

    @Accessor("allowSuggestions") boolean getAllowSuggestionsFancyMenu();

    @Accessor("keepSuggestions") boolean getKeepSuggestionsFancyMenu();

    @Nullable
    @Accessor("currentParse") ParseResults<class_637> getCurrentParseFancyMenu();
    @Accessor("currentParse") void setCurrentParseFancyMenu(ParseResults<class_637> currentParse);

    @Nullable
    @Accessor("pendingSuggestions") CompletableFuture<Suggestions> getPendingSuggestionsFancyMenu();
    @Accessor("pendingSuggestions") void setPendingSuggestionsFancyMenu(CompletableFuture<Suggestions> pendingSuggestions);

    @Accessor("commandUsage") List<class_5481> getCommandUsageFancyMenu();

    @Nullable
    @Accessor("suggestions") class_4717.class_464 getSuggestionsFancyMenu();
    @Accessor("suggestions") void setSuggestionsFancyMenu(class_4717.class_464 suggestions);

    @Invoker("updateUsageInfo") void invokeUpdateUsageInfoFancyMenu();

    @Invoker("sortSuggestions") List<Suggestion> invokeSortSuggestionsFancyMenu(Suggestions suggestions);

}
